/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.types;

import java.io.Serializable;
import java.util.Date;
import org.ojai.annotation.API;
import org.ojai.exceptions.ParseException;
import org.ojai.joda.Days;
import org.ojai.joda.LocalDate;
import org.ojai.joda.LocalTime;

@API.Public
public final class ODate
implements Comparable<ODate>,
Serializable {
    private static final long serialVersionUID = -5766126644406257565L;
    private static final LocalDate EPOCH_DATE = new LocalDate(1970, 1, 1);
    private static final LocalTime START_OF_DAY = new LocalTime(0, 0, 0);
    private volatile transient LocalDate date;
    private final int daysSinceEpoch;

    public static ODate parse(String dateStr) {
        try {
            return new ODate(LocalDate.parse(dateStr));
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e);
        }
    }

    public static ODate fromDaysSinceEpoch(int daysSinceEpoch) {
        return new ODate(daysSinceEpoch);
    }

    public ODate(int year, int month, int dayOfMonth) {
        this(new LocalDate(year, month, dayOfMonth));
    }

    public ODate(long epoh) {
        this(new LocalDate(epoh));
    }

    public ODate(Date date) {
        this(LocalDate.fromDateFields(date));
    }

    private ODate(int daysSinceEpoch) {
        this.daysSinceEpoch = daysSinceEpoch;
    }

    private ODate(LocalDate localDate) {
        this.date = localDate;
        this.daysSinceEpoch = Days.daysBetween(EPOCH_DATE, this.date).getDays();
    }

    public int getYear() {
        return this.getDate().getYear();
    }

    public int getMonth() {
        return this.getDate().getMonthOfYear();
    }

    public int getDayOfMonth() {
        return this.getDate().getDayOfMonth();
    }

    public int toDaysSinceEpoch() {
        return this.daysSinceEpoch;
    }

    public Date toDate() {
        return this.getDate().toDateTime(START_OF_DAY).toDate();
    }

    public String toDateStr() {
        return this.toString("yyyy-MM-dd");
    }

    public String toString(String pattern) {
        return this.getDate().toString(pattern);
    }

    public String toString() {
        return this.toDateStr();
    }

    public int hashCode() {
        return this.daysSinceEpoch;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ODate other = (ODate)obj;
        return this.daysSinceEpoch == other.daysSinceEpoch;
    }

    @Override
    public int compareTo(ODate o) {
        return this.daysSinceEpoch - o.daysSinceEpoch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalDate getDate() {
        if (this.date == null) {
            ODate oDate = this;
            synchronized (oDate) {
                if (this.date == null) {
                    this.date = EPOCH_DATE.plusDays(this.daysSinceEpoch);
                }
            }
        }
        return this.date;
    }
}

