/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.impl;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.EncodingException;
import org.ojai.json.Json;
import org.ojai.json.JsonOptions;
import org.ojai.json.impl.ByteArrayWriterOutputStream;
import org.ojai.json.impl.JsonValueBuilder;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.ojai.util.Decimals;
import org.ojai.util.impl.ContainerContext;

@API.Internal
public class JsonDocumentBuilder
implements DocumentBuilder {
    private JsonGenerator jsonGenerator;
    private ByteArrayWriterOutputStream b;
    private String cachedJson;
    private Stack<ContainerContext> ctxStack;
    private ContainerContext currentContext;
    private JsonOptions jsonOptions;
    private boolean checkContext;
    private static final DefaultPrettyPrinter PRETTY_PRINTER = new DefaultPrettyPrinter();

    public JsonDocumentBuilder() {
        this.b = new ByteArrayWriterOutputStream();
        this.initJsonGenerator(this.b);
    }

    protected JsonDocumentBuilder(OutputStream out) {
        this.initJsonGenerator(out);
    }

    public JsonDocumentBuilder setJsonOptions(JsonOptions options) {
        if (this.jsonOptions == null || this.jsonOptions.isPretty() != options.isPretty()) {
            if (options.isPretty()) {
                this.jsonGenerator.setPrettyPrinter((PrettyPrinter)PRETTY_PRINTER);
            } else {
                this.jsonGenerator.setPrettyPrinter(null);
            }
        }
        this.jsonOptions = options;
        return this;
    }

    private void initJsonGenerator(OutputStream out) {
        try {
            JsonFactory jFactory = new JsonFactory();
            this.jsonGenerator = jFactory.createGenerator(out, JsonEncoding.UTF8);
            this.ctxStack = new Stack();
            this.currentContext = ContainerContext.NULL;
            this.checkContext = true;
            this.setJsonOptions(JsonOptions.WITH_TAGS);
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    private RuntimeException transformIOException(IOException ie) {
        return ie instanceof JsonGenerationException ? new IllegalStateException(ie) : new EncodingException(ie);
    }

    private void preparePut() {
        this.checkContext(Value.Type.MAP);
    }

    private void prepareAdd() {
        this.checkContext(Value.Type.ARRAY);
        if (this.currentContext.getType() == Value.Type.ARRAY) {
            this.currentContext.incrementIndex();
        }
    }

    private void checkContext(Value.Type type) {
        Preconditions.checkState((!this.checkContext || this.currentContext.getType() == type ? 1 : 0) != 0, (String)"Mismatch in writeContext. Expected %s but found %s", (Object[])new Object[]{type, this.currentContext.getType()});
    }

    @Override
    public JsonDocumentBuilder put(String field, boolean value) {
        try {
            this.preparePut();
            this.jsonGenerator.writeBooleanField(field, value);
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder put(String field, String value) {
        try {
            this.preparePut();
            this.jsonGenerator.writeStringField(field, value);
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder put(String field, byte value) {
        return this.putLongWithTag(field, "$numberByte", value);
    }

    @Override
    public JsonDocumentBuilder put(String field, short value) {
        return this.putLongWithTag(field, "$numberShort", value);
    }

    @Override
    public JsonDocumentBuilder put(String field, int value) {
        return this.putLongWithTag(field, "$numberInt", value);
    }

    @Override
    public JsonDocumentBuilder put(String field, long value) {
        return this.putLongWithTag(field, "$numberLong", value);
    }

    @Override
    public JsonDocumentBuilder put(String field, float value) {
        try {
            this.preparePut();
            if (this.jsonOptions.isWithTags()) {
                this.putNewMap(field);
                this.jsonGenerator.writeNumberField("$numberFloat", value);
                this.endMap();
            } else {
                this.jsonGenerator.writeNumberField(field, value);
            }
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder put(String field, double value) {
        try {
            this.preparePut();
            if (this.isWholeNumberInLongRange(value)) {
                this.jsonGenerator.writeNumberField(field, (long)value);
            } else {
                this.jsonGenerator.writeNumberField(field, value);
            }
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder put(String field, BigDecimal value) {
        try {
            this.preparePut();
            if (this.jsonOptions.isWithTags()) {
                this.putNewMap(field);
                this.jsonGenerator.writeStringField("$decimal", value.toString());
                this.endMap();
            } else {
                this.jsonGenerator.writeNumberField(field, value);
            }
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder putDecimal(String field, long decimalValue) {
        return this.put(field, new BigDecimal(decimalValue));
    }

    @Override
    public JsonDocumentBuilder putDecimal(String field, double decimalValue) {
        return this.put(field, new BigDecimal(decimalValue));
    }

    @Override
    public JsonDocumentBuilder putDecimal(String field, int unscaledValue, int scale) {
        return this.put(field, Decimals.convertIntToDecimal(unscaledValue, scale));
    }

    @Override
    public JsonDocumentBuilder putDecimal(String field, long unscaledValue, int scale) {
        return this.put(field, Decimals.convertLongToDecimal(unscaledValue, scale));
    }

    @Override
    public JsonDocumentBuilder putDecimal(String field, byte[] unscaledValue, int scale) {
        return this.put(field, Decimals.convertByteToBigDecimal(unscaledValue, scale));
    }

    @Override
    public JsonDocumentBuilder put(String field, byte[] value) {
        try {
            this.preparePut();
            if (this.jsonOptions.isWithTags()) {
                this.putNewMap(field);
                this.jsonGenerator.writeBinaryField("$binary", value);
                this.endMap();
            } else {
                this.jsonGenerator.writeBinaryField(field, value);
            }
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder put(String field, byte[] value, int offset, int length) {
        try {
            this.preparePut();
            if (this.jsonOptions.isWithTags()) {
                this.putNewMap(field);
                this.jsonGenerator.writeFieldName("$binary");
                this.jsonGenerator.writeBinary(value, offset, length);
                this.endMap();
            } else {
                this.jsonGenerator.writeFieldName(field);
                this.jsonGenerator.writeBinary(value, offset, length);
            }
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder put(String field, ByteBuffer value) {
        byte[] bytes = new byte[value.remaining()];
        value.slice().get(bytes);
        return this.put(field, bytes);
    }

    private JsonDocumentBuilder putLongWithTag(String fieldname, String fieldTag, long value) {
        try {
            this.preparePut();
            if (this.jsonOptions.isWithTags()) {
                this.putNewMap(fieldname);
                this.jsonGenerator.writeNumberField(fieldTag, value);
                this.endMap();
            } else {
                this.jsonGenerator.writeNumberField(fieldname, value);
            }
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    private JsonDocumentBuilder putStringWithTag(String fieldname, String fieldTag, String value) {
        try {
            this.preparePut();
            if (this.jsonOptions.isWithTags()) {
                this.putNewMap(fieldname);
                this.jsonGenerator.writeStringField(fieldTag, value);
                this.endMap();
            } else {
                this.jsonGenerator.writeStringField(fieldname, value);
            }
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder put(String field, ODate value) {
        return this.putStringWithTag(field, "$dateDay", value.toDateStr());
    }

    @Override
    public JsonDocumentBuilder putDate(String field, int days) {
        return this.putStringWithTag(field, "$dateDay", ODate.fromDaysSinceEpoch(days).toDateStr());
    }

    @Override
    public JsonDocumentBuilder put(String field, OTime value) {
        return this.putStringWithTag(field, "$time", value.toTimeStr());
    }

    @Override
    public JsonDocumentBuilder putTime(String field, int millis) {
        if ((long)millis > 86400000L) {
            throw new IllegalArgumentException("Long value exceeds " + Long.toString(86400000L) + " " + Long.toString(millis));
        }
        return this.putStringWithTag(field, "$time", OTime.fromMillisOfDay(millis).toTimeStr());
    }

    @Override
    public JsonDocumentBuilder put(String field, OTimestamp value) {
        return this.putStringWithTag(field, "$date", value.toUTCString());
    }

    @Override
    public JsonDocumentBuilder putTimestamp(String field, long timeMillis) {
        return this.putStringWithTag(field, "$date", new OTimestamp(timeMillis).toUTCString());
    }

    @Override
    public JsonDocumentBuilder put(String field, OInterval value) {
        return this.putLongWithTag(field, "$interval", value.getTimeInMillis());
    }

    @Override
    public JsonDocumentBuilder putInterval(String field, long durationInMs) {
        return this.putLongWithTag(field, "$interval", durationInMs);
    }

    @Override
    public JsonDocumentBuilder putInterval(String field, int months, int days, int milliseconds) {
        long total_milliseconds = (long)milliseconds + ((long)days + (long)months * 30L) * 86400000L;
        return this.putLongWithTag(field, "$interval", total_milliseconds);
    }

    @Override
    public JsonDocumentBuilder putNewMap(String field) {
        try {
            this.preparePut();
            this.jsonGenerator.writeFieldName(field);
            this.jsonGenerator.writeStartObject();
            this.ctxStack.push(this.currentContext);
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder putNewArray(String field) {
        try {
            this.preparePut();
            this.jsonGenerator.writeFieldName(field);
            this.jsonGenerator.writeStartArray();
            this.currentContext = this.ctxStack.push(new ContainerContext(Value.Type.ARRAY));
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder putNull(String field) {
        try {
            this.preparePut();
            this.jsonGenerator.writeNullField(field);
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder put(String field, Value value) {
        Value.Type t = value.getType();
        switch (t) {
            case NULL: {
                this.putNull(field);
                break;
            }
            case BOOLEAN: {
                this.put(field, value.getBoolean());
                break;
            }
            case STRING: {
                this.put(field, value.getString());
                break;
            }
            case BYTE: {
                this.put(field, value.getByte());
                break;
            }
            case SHORT: {
                this.put(field, value.getShort());
                break;
            }
            case INT: {
                this.put(field, value.getInt());
                break;
            }
            case LONG: {
                this.put(field, value.getLong());
                break;
            }
            case FLOAT: {
                this.put(field, value.getFloat());
                break;
            }
            case DOUBLE: {
                this.put(field, value.getDouble());
                break;
            }
            case DECIMAL: {
                this.put(field, value.getDecimal());
                break;
            }
            case DATE: {
                this.put(field, value.getDate());
                break;
            }
            case TIME: {
                this.put(field, value.getTime());
                break;
            }
            case TIMESTAMP: {
                this.put(field, value.getTimestamp());
                break;
            }
            case INTERVAL: {
                this.put(field, value.getInterval());
                break;
            }
            case BINARY: {
                this.put(field, value.getBinary());
                break;
            }
            case MAP: {
                this.put(field, (Document)((Object)value));
                break;
            }
            case ARRAY: {
                this.putArray(field, value.getList());
                break;
            }
        }
        return this;
    }

    private JsonDocumentBuilder iterDocument(Iterator<Map.Entry<String, Value>> it) {
        while (it.hasNext()) {
            Map.Entry<String, Value> kv = it.next();
            String key = kv.getKey();
            Value value = kv.getValue();
            if (value.getType() == Value.Type.MAP) {
                this.putNewMap(key);
                this.iterDocument(((Document)((Object)value)).iterator());
                continue;
            }
            if (value.getType() == Value.Type.ARRAY) {
                this.putArray(key, value.getList());
                continue;
            }
            this.put(key, value);
        }
        this.endMap();
        return this;
    }

    @Override
    public JsonDocumentBuilder put(String field, Map<String, Object> value) {
        return this.put(field, JsonValueBuilder.initFrom(value));
    }

    @Override
    public JsonDocumentBuilder put(String field, Document value) {
        this.preparePut();
        Iterator<Map.Entry<String, Value>> it = value.iterator();
        this.putNewMap(field);
        return this.iterDocument(it);
    }

    @Override
    public DocumentBuilder setArrayIndex(int index) {
        this.checkContext(Value.Type.ARRAY);
        int lastIndex = this.currentContext.getIndex();
        if (index <= lastIndex) {
            throw new IllegalArgumentException(String.format("Specified index %d is not larger than the last written index %d", index, lastIndex));
        }
        int nullCount = index - lastIndex;
        for (int i = 1; i < nullCount; ++i) {
            this.addNull();
        }
        return this;
    }

    @Override
    public JsonDocumentBuilder add(boolean value) {
        try {
            this.prepareAdd();
            this.jsonGenerator.writeBoolean(value);
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder add(String value) {
        try {
            this.prepareAdd();
            this.jsonGenerator.writeString(value);
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder add(byte value) {
        return this.addLong("$numberByte", value);
    }

    @Override
    public JsonDocumentBuilder add(short value) {
        return this.addLong("$numberShort", value);
    }

    @Override
    public JsonDocumentBuilder add(int value) {
        return this.addLong("$numberInt", value);
    }

    @Override
    public JsonDocumentBuilder add(long value) {
        return this.addLong("$numberLong", value);
    }

    private JsonDocumentBuilder addLong(String tagName, long value) {
        try {
            this.prepareAdd();
            if (this.jsonOptions.isWithTags()) {
                this.jsonGenerator.writeStartObject();
                this.jsonGenerator.writeNumberField(tagName, value);
                this.jsonGenerator.writeEndObject();
            } else {
                this.jsonGenerator.writeNumber(value);
            }
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder add(float value) {
        try {
            this.prepareAdd();
            if (this.jsonOptions.isWithTags()) {
                this.jsonGenerator.writeStartObject();
                this.jsonGenerator.writeNumberField("$numberFloat", value);
                this.jsonGenerator.writeEndObject();
            } else {
                this.jsonGenerator.writeNumber(value);
            }
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder add(double value) {
        try {
            this.prepareAdd();
            if (this.isWholeNumberInLongRange(value)) {
                this.jsonGenerator.writeNumber((long)value);
            } else {
                this.jsonGenerator.writeNumber(value);
            }
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder add(BigDecimal value) {
        try {
            this.prepareAdd();
            if (this.jsonOptions.isWithTags()) {
                this.jsonGenerator.writeStartObject();
                this.jsonGenerator.writeStringField("$decimal", value.toPlainString());
                this.jsonGenerator.writeEndObject();
            } else {
                this.jsonGenerator.writeNumber(value);
            }
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder addDecimal(long decimalValue) {
        try {
            this.prepareAdd();
            if (this.jsonOptions.isWithTags()) {
                this.jsonGenerator.writeStartObject();
                this.jsonGenerator.writeStringField("$decimal", String.valueOf(decimalValue));
                this.jsonGenerator.writeEndObject();
            } else {
                this.jsonGenerator.writeNumber(decimalValue);
            }
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder addDecimal(double decimalValue) {
        try {
            this.prepareAdd();
            if (this.jsonOptions.isWithTags()) {
                this.jsonGenerator.writeStartObject();
                this.jsonGenerator.writeStringField("$decimal", String.valueOf(decimalValue));
                this.jsonGenerator.writeEndObject();
            } else {
                this.jsonGenerator.writeNumber(decimalValue);
            }
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder addDecimal(int unscaledValue, int scale) {
        return this.add(Decimals.convertIntToDecimal(unscaledValue, scale));
    }

    @Override
    public JsonDocumentBuilder addDecimal(long unscaledValue, int scale) {
        return this.add(Decimals.convertLongToDecimal(unscaledValue, scale));
    }

    @Override
    public JsonDocumentBuilder addDecimal(byte[] unscaledValue, int scale) {
        return this.add(Decimals.convertByteToBigDecimal(unscaledValue, scale));
    }

    @Override
    public JsonDocumentBuilder add(byte[] value) {
        try {
            this.prepareAdd();
            if (this.jsonOptions.isWithTags()) {
                this.jsonGenerator.writeStartObject();
                this.jsonGenerator.writeBinaryField("$binary", value);
                this.jsonGenerator.writeEndObject();
            } else {
                this.jsonGenerator.writeBinary(value);
            }
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder add(byte[] value, int offset, int length) {
        try {
            this.prepareAdd();
            if (this.jsonOptions.isWithTags()) {
                this.jsonGenerator.writeStartObject();
                this.jsonGenerator.writeFieldName("$binary");
                this.jsonGenerator.writeBinary(value, offset, length);
                this.jsonGenerator.writeEndObject();
            } else {
                this.jsonGenerator.writeBinary(value, offset, length);
            }
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder add(ByteBuffer value) {
        byte[] bytes = new byte[value.remaining()];
        value.slice().get(bytes);
        return this.add(bytes);
    }

    @Override
    public JsonDocumentBuilder addNull() {
        try {
            this.prepareAdd();
            this.jsonGenerator.writeNull();
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder add(Value value) {
        Value.Type t = value.getType();
        switch (t) {
            case NULL: {
                this.addNull();
                break;
            }
            case BOOLEAN: {
                this.add(value.getBoolean());
                break;
            }
            case STRING: {
                this.add(value.getString());
                break;
            }
            case BYTE: {
                this.add(value.getByte());
                break;
            }
            case SHORT: {
                this.add(value.getShort());
                break;
            }
            case INT: {
                this.add(value.getInt());
                break;
            }
            case LONG: {
                this.add(value.getLong());
                break;
            }
            case FLOAT: {
                this.add(value.getFloat());
                break;
            }
            case DOUBLE: {
                this.add(value.getDouble());
                break;
            }
            case DATE: {
                this.add(value.getDate());
                break;
            }
            case TIME: {
                this.add(value.getTime());
                break;
            }
            case TIMESTAMP: {
                this.add(value.getTimestamp());
                break;
            }
            case INTERVAL: {
                this.add(value.getInterval());
                break;
            }
            case BINARY: {
                this.add(value.getBinary());
                break;
            }
            case MAP: {
                this.add((Document)((Object)value));
                break;
            }
            case DECIMAL: {
                this.add(value.getDecimal());
                break;
            }
            case ARRAY: {
                this.putArray(null, value.getList());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown object type");
            }
        }
        return this;
    }

    @Override
    public JsonDocumentBuilder add(Document value) {
        this.addNewMap();
        Iterator<Map.Entry<String, Value>> it = value.iterator();
        return this.iterDocument(it);
    }

    @Override
    public JsonDocumentBuilder addNewArray() {
        try {
            this.prepareAdd();
            this.jsonGenerator.writeStartArray();
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
        this.currentContext = this.ctxStack.push(new ContainerContext(Value.Type.ARRAY));
        return this;
    }

    @Override
    public JsonDocumentBuilder addNewMap() {
        try {
            Preconditions.checkState((this.currentContext.getType() != Value.Type.MAP ? 1 : 0) != 0, (String)"Context mismatch : addNewMap() can not be called at %s", (Object[])new Object[]{this.currentContext.getType()});
            if (this.currentContext.getType() == Value.Type.ARRAY) {
                this.prepareAdd();
            }
            this.jsonGenerator.writeStartObject();
            this.currentContext = this.ctxStack.push(new ContainerContext(Value.Type.MAP));
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    private JsonDocumentBuilder addStringWithTag(String tagName, String value) {
        try {
            this.prepareAdd();
            if (this.jsonOptions.isWithTags()) {
                this.jsonGenerator.writeStartObject();
                this.jsonGenerator.writeStringField(tagName, value);
                this.jsonGenerator.writeEndObject();
            } else {
                this.jsonGenerator.writeString(value);
            }
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder add(OTime value) {
        return this.addStringWithTag("$time", value.toTimeStr());
    }

    @Override
    public JsonDocumentBuilder addTime(int millis) {
        return this.addStringWithTag("$time", OTime.fromMillisOfDay(millis).toTimeStr());
    }

    @Override
    public JsonDocumentBuilder add(ODate value) {
        return this.addStringWithTag("$dateDay", value.toDateStr());
    }

    @Override
    public JsonDocumentBuilder addDate(int days) {
        return this.addStringWithTag("$dateDay", ODate.fromDaysSinceEpoch(days).toDateStr());
    }

    @Override
    public JsonDocumentBuilder add(OTimestamp value) {
        return this.addStringWithTag("$date", value.toUTCString());
    }

    @Override
    public JsonDocumentBuilder addTimestamp(long timeMillis) {
        return this.addStringWithTag("$date", new OTimestamp(timeMillis).toUTCString());
    }

    @Override
    public JsonDocumentBuilder add(OInterval value) {
        return this.addLongWithTag("$interval", value.getTimeInMillis());
    }

    @Override
    public JsonDocumentBuilder addInterval(long durationInMs) {
        return this.addLongWithTag("$interval", durationInMs);
    }

    private JsonDocumentBuilder addLongWithTag(String tagName, long value) {
        try {
            this.prepareAdd();
            if (this.jsonOptions.isWithTags()) {
                this.jsonGenerator.writeStartObject();
                this.jsonGenerator.writeNumberField(tagName, value);
                this.jsonGenerator.writeEndObject();
            } else {
                this.jsonGenerator.writeNumber(value);
            }
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder endArray() {
        try {
            this.checkContext(Value.Type.ARRAY);
            this.jsonGenerator.writeEndArray();
            this.ctxStack.pop();
            this.currentContext = this.ctxStack.isEmpty() ? ContainerContext.NULL : this.ctxStack.peek();
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    @Override
    public JsonDocumentBuilder endMap() {
        if (this.jsonGenerator.isClosed()) {
            throw new IllegalStateException("The document has already been built.");
        }
        try {
            this.preparePut();
            this.jsonGenerator.writeEndObject();
            this.ctxStack.pop();
            if (!this.ctxStack.empty()) {
                this.currentContext = this.ctxStack.peek();
            } else {
                this.jsonGenerator.close();
            }
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    public String toString() {
        try {
            return this.b.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String asUTF8String() {
        if (!this.jsonGenerator.isClosed()) {
            try {
                this.jsonGenerator.close();
            }
            catch (IOException ie) {
                throw this.transformIOException(ie);
            }
        }
        if (this.cachedJson == null) {
            this.cachedJson = this.toString();
        }
        return this.cachedJson;
    }

    public byte[] getOutputStream() {
        return this.b.getByteArray();
    }

    private JsonDocumentBuilder putArray(String field, List<Object> values) {
        try {
            if (field != null) {
                this.checkContext(Value.Type.MAP);
                this.jsonGenerator.writeFieldName(field);
            } else {
                this.checkContext(Value.Type.ARRAY);
            }
            this.jsonGenerator.writeStartArray();
            this.currentContext = this.ctxStack.push(new ContainerContext(Value.Type.ARRAY));
            for (Object e : values) {
                this.add(JsonValueBuilder.initFromObject(e));
            }
            this.jsonGenerator.writeEndArray();
            this.ctxStack.pop();
            this.currentContext = this.ctxStack.peek();
            return this;
        }
        catch (IOException ie) {
            throw this.transformIOException(ie);
        }
    }

    private boolean isWholeNumberInLongRange(double value) {
        return value == Math.floor(value) && !Double.isInfinite(value) && value >= -9.223372036854776E18 && value <= 9.223372036854776E18;
    }

    @Override
    public Document getDocument() {
        byte[] barray;
        ByteArrayInputStream inputStream;
        DocumentStream documentStream;
        Iterator<Document> iter;
        Preconditions.checkState((boolean)this.jsonGenerator.isClosed(), (Object)"The document has not been built.");
        if (this.b != null && (iter = (documentStream = Json.newDocumentStream(inputStream = new ByteArrayInputStream(barray = this.b.getByteArray()))).iterator()).hasNext()) {
            Document r = iter.next();
            return r;
        }
        return null;
    }

    @API.Internal
    public JsonDocumentBuilder setCheckContext(boolean value) {
        this.checkContext = value;
        return this;
    }

    static {
        PRETTY_PRINTER.indentObjectsWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE.withLinefeed("\n"));
    }
}

