/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.Map;
import org.apache.drill.exec.metrics.DrillbitProcessLoad;
import org.apache.drill.exec.metrics.DrillbitUptime;
import org.apache.drill.exec.metrics.OperatingSystemLoad;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuGaugeSet
implements MetricSet {
    private static final Logger logger = LoggerFactory.getLogger(CpuGaugeSet.class);
    private final OperatingSystemMXBean osMXBean;
    private final RuntimeMXBean rtMXBean = ManagementFactory.getRuntimeMXBean();

    public CpuGaugeSet() {
        this.osMXBean = CpuGaugeSet.getOSMXBeanForCpuMetrics();
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> metric = new HashMap<String, Metric>(1);
        metric.put("os.load.avg", (Metric)new OperatingSystemLoad(this.osMXBean));
        metric.put("drillbit.load.avg", (Metric)new DrillbitProcessLoad(this.osMXBean));
        metric.put("drillbit.uptime", (Metric)new DrillbitUptime(this.rtMXBean));
        return metric;
    }

    private static OperatingSystemMXBean getOSMXBeanForCpuMetrics() {
        try {
            return (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        }
        catch (ClassCastException ex) {
            logger.warn("{}. Detected non-Supported JVM [{}]. CPU Metrics in the WebUI will not be available!", (Object)ex.getMessage(), (Object)System.getProperty("java.vm.name"));
            return null;
        }
    }
}

