/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.ddl;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlExecutableStatement;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.ddl.SqlDdlNodes;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;

public class SqlCreateSchema
extends SqlCreate
implements SqlExecutableStatement {
    private final SqlIdentifier name;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE SCHEMA", SqlKind.CREATE_SCHEMA);

    SqlCreateSchema(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = Objects.requireNonNull(name);
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.getReplace()) {
            writer.keyword("CREATE OR REPLACE");
        } else {
            writer.keyword("CREATE");
        }
        writer.keyword("SCHEMA");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }

    public void execute(CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.name);
        SchemaPlus subSchema0 = ((CalciteSchema)pair.left).plus().getSubSchema((String)pair.right);
        if (subSchema0 != null && !this.getReplace() && !this.ifNotExists) {
            throw SqlUtil.newContextException((SqlParserPos)this.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.schemaExists((String)pair.right));
        }
        AbstractSchema subSchema = new AbstractSchema();
        ((CalciteSchema)pair.left).add((String)pair.right, (Schema)subSchema);
    }
}

