/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.ddl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.materialize.MaterializationKey;
import org.apache.calcite.materialize.MaterializationService;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.schema.impl.ViewTableMacro;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlExecutableStatement;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.ddl.SqlCreateTable;
import org.apache.calcite.sql.ddl.SqlDdlNodes;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;

public class SqlCreateMaterializedView
extends SqlCreate
implements SqlExecutableStatement {
    private final SqlIdentifier name;
    private final SqlNodeList columnList;
    private final SqlNode query;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE MATERIALIZED VIEW", SqlKind.CREATE_MATERIALIZED_VIEW);

    SqlCreateMaterializedView(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, SqlNodeList columnList, SqlNode query) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = Objects.requireNonNull(name);
        this.columnList = columnList;
        this.query = Objects.requireNonNull(query);
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.columnList, (Object)this.query);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        writer.keyword("MATERIALIZED VIEW");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columnList != null) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode c : this.columnList) {
                writer.sep(",");
                c.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
        writer.keyword("AS");
        writer.newlineAndIndent();
        this.query.unparse(writer, 0, 0);
    }

    public void execute(CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.name);
        if (((CalciteSchema)pair.left).plus().getTable((String)pair.right) != null) {
            if (!this.ifNotExists) {
                throw SqlUtil.newContextException((SqlParserPos)this.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.tableExists((String)pair.right));
            }
            return;
        }
        SqlNode q = SqlDdlNodes.renameColumns(this.columnList, this.query);
        String sql = q.toSqlString(CalciteSqlDialect.DEFAULT).getSql();
        List schemaPath = ((CalciteSchema)pair.left).path(null);
        ViewTableMacro viewTableMacro = ViewTable.viewMacro((SchemaPlus)((CalciteSchema)pair.left).plus(), (String)sql, (List)schemaPath, (List)context.getObjectPath(), (Boolean)false);
        TranslatableTable x = viewTableMacro.apply((List)ImmutableList.of());
        RelDataType rowType = x.getRowType((RelDataTypeFactory)context.getTypeFactory());
        MaterializedViewTable table = new MaterializedViewTable((String)pair.right, RelDataTypeImpl.proto((RelDataType)rowType));
        ((CalciteSchema)pair.left).add((String)pair.right, (Table)table);
        SqlDdlNodes.populate(this.name, this.query, context);
        table.key = MaterializationService.instance().defineMaterialization((CalciteSchema)pair.left, null, sql, schemaPath, (String)pair.right, true, true);
    }

    private static class MaterializedViewTable
    extends SqlCreateTable.MutableArrayTable {
        MaterializationKey key;

        MaterializedViewTable(String name, RelProtoDataType protoRowType) {
            super(name, protoRowType, protoRowType, NullInitializerExpressionFactory.INSTANCE);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.MATERIALIZED_VIEW;
        }

        @Override
        public <C> C unwrap(Class<C> aClass) {
            if (MaterializationKey.class.isAssignableFrom(aClass) && aClass.isInstance(this.key)) {
                return aClass.cast(this.key);
            }
            return super.unwrap(aClass);
        }
    }
}

