/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.esri;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.ShapefileReader;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.scan.file.FileScanFramework;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedReader;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.PrimitiveColumnMetadata;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.vector.accessor.ScalarWriter;
import org.apache.drill.exec.vector.accessor.TupleWriter;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.jamel.dbf.DbfReader;
import org.jamel.dbf.structure.DbfField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShpBatchReader
implements ManagedReader<FileScanFramework.FileSchemaNegotiator> {
    private static final Logger logger = LoggerFactory.getLogger(ShpBatchReader.class);
    private static final String GID_FIELD_NAME = "gid";
    private static final String SRID_FIELD_NAME = "srid";
    private static final String SHAPE_TYPE_FIELD_NAME = "shapeType";
    private static final String GEOM_FIELD_NAME = "geom";
    private static final String SRID_PATTERN_TEXT = "AUTHORITY\\[\"\\w+\"\\s*,\\s*\"*(\\d+)\"*\\]\\]$";
    private FileSplit split;
    private ResultSetLoader loader;
    private Path hadoopShp;
    private Path hadoopDbf;
    private Path hadoopPrj;
    private InputStream fileReaderShp = null;
    private InputStream fileReaderDbf = null;
    private InputStream fileReaderPrj = null;
    private GeometryCursor geomCursor = null;
    private DbfReader dbfReader = null;
    private ScalarWriter gidWriter;
    private ScalarWriter sridWriter;
    private ScalarWriter shapeTypeWriter;
    private ScalarWriter geomWriter;
    private RowSetLoader rowWriter;
    private int srid;
    private SpatialReference spatialReference;
    private final int maxRecords;

    public ShpBatchReader(int maxRecords) {
        this.maxRecords = maxRecords;
    }

    public boolean open(FileScanFramework.FileSchemaNegotiator negotiator) {
        this.split = negotiator.split();
        this.hadoopShp = this.split.getPath();
        String filePath = this.split.getPath().toString();
        this.hadoopDbf = new Path(filePath.replace(".shp", ".dbf"));
        this.hadoopPrj = new Path(filePath.replace(".shp", ".prj"));
        this.openFile(negotiator);
        SchemaBuilder builder = new SchemaBuilder().addNullable(GID_FIELD_NAME, TypeProtos.MinorType.INT).addNullable(SRID_FIELD_NAME, TypeProtos.MinorType.INT).addNullable(SHAPE_TYPE_FIELD_NAME, TypeProtos.MinorType.VARCHAR).addNullable(GEOM_FIELD_NAME, TypeProtos.MinorType.VARBINARY);
        negotiator.tableSchema(builder.buildSchema(), false);
        this.loader = negotiator.build();
        this.rowWriter = this.loader.writer();
        this.gidWriter = this.rowWriter.scalar(GID_FIELD_NAME);
        this.sridWriter = this.rowWriter.scalar(SRID_FIELD_NAME);
        this.shapeTypeWriter = this.rowWriter.scalar(SHAPE_TYPE_FIELD_NAME);
        this.geomWriter = this.rowWriter.scalar(GEOM_FIELD_NAME);
        return true;
    }

    public boolean next() {
        Geometry geom = null;
        while (!this.rowWriter.isFull()) {
            Object[] dbfRow = this.dbfReader.nextRecord();
            geom = this.geomCursor.next();
            if (geom == null) {
                return false;
            }
            this.processShapefileSet(this.rowWriter, this.geomCursor.getGeometryID(), geom, dbfRow);
        }
        return true;
    }

    private void openFile(FileScanFramework.FileSchemaNegotiator negotiator) {
        try {
            this.fileReaderShp = negotiator.fileSystem().openPossiblyCompressedStream(this.split.getPath());
            byte[] shpBuf = new byte[this.fileReaderShp.available()];
            this.fileReaderShp.read(shpBuf);
            ByteBuffer byteBuffer = ByteBuffer.wrap(shpBuf);
            byteBuffer.position(byteBuffer.position() + 100);
            ShapefileReader shpReader = new ShapefileReader();
            this.geomCursor = shpReader.getGeometryCursor(byteBuffer);
            this.fileReaderDbf = negotiator.fileSystem().openPossiblyCompressedStream(this.hadoopDbf);
            this.dbfReader = new DbfReader(this.fileReaderDbf);
            this.fileReaderPrj = negotiator.fileSystem().openPossiblyCompressedStream(this.hadoopPrj);
            byte[] prjBuf = new byte[this.fileReaderPrj.available()];
            this.fileReaderPrj.read(prjBuf);
            this.fileReaderPrj.close();
            String wktReference = new String(prjBuf);
            Pattern pattern = Pattern.compile(SRID_PATTERN_TEXT);
            Matcher matcher = pattern.matcher(wktReference);
            if (matcher.find()) {
                this.srid = Integer.parseInt(matcher.group(1));
                this.spatialReference = SpatialReference.create((int)this.srid);
            }
            logger.debug("Processing Shape File: {}", (Object)this.hadoopShp);
        }
        catch (IOException e) {
            throw UserException.dataReadError((Throwable)e).message("Failed to open open input file: %s", new Object[]{this.split.getPath()}).addContext("User name", negotiator.userName()).build(logger);
        }
    }

    private void processShapefileSet(RowSetLoader rowWriter, int gid, Geometry geom, Object[] dbfRow) {
        if (rowWriter.limitReached(this.maxRecords)) {
            return;
        }
        rowWriter.start();
        this.gidWriter.setInt(gid);
        this.sridWriter.setInt(this.srid);
        this.shapeTypeWriter.setString(geom.getType().toString());
        ByteBuffer buf = OGCGeometry.createFromEsriGeometry((Geometry)geom, (SpatialReference)this.spatialReference).asBinary();
        byte[] bytes = buf.array();
        this.geomWriter.setBytes(bytes, bytes.length);
        this.writeDbfRow(dbfRow, rowWriter);
        rowWriter.save();
    }

    private void writeDbfRow(Object[] dbfRow, RowSetLoader rowWriter) {
        int dbfFieldCount = this.dbfReader.getHeader().getFieldsCount();
        block7: for (int i = 0; i < dbfFieldCount; ++i) {
            DbfField field = this.dbfReader.getHeader().getField(i);
            if (dbfRow[i] == null) continue;
            switch (field.getDataType()) {
                case CHAR: {
                    byte[] strType = (byte[])dbfRow[i];
                    String stringValue = new String(strType, Charset.forName("utf-8")).trim();
                    this.writeStringColumn((TupleWriter)rowWriter, field.getName(), stringValue);
                    continue block7;
                }
                case FLOAT: {
                    double floatVal = ((Float)dbfRow[i]).doubleValue();
                    this.writeDoubleColumn((TupleWriter)rowWriter, field.getName(), floatVal);
                    continue block7;
                }
                case DATE: {
                    long dataVal = ((Date)dbfRow[i]).getTime();
                    this.writeTimeColumn((TupleWriter)rowWriter, field.getName(), dataVal);
                    continue block7;
                }
                case LOGICAL: {
                    int logicalVal = (Boolean)dbfRow[i] != false ? 1 : 0;
                    this.writeBooleanColumn((TupleWriter)rowWriter, field.getName(), logicalVal);
                    continue block7;
                }
                case NUMERIC: {
                    double numericVal = ((Number)dbfRow[i]).doubleValue();
                    if (field.getDecimalCount() == 0) {
                        this.writeIntColumn((TupleWriter)rowWriter, field.getName(), (int)numericVal);
                        continue block7;
                    }
                    this.writeDoubleColumn((TupleWriter)rowWriter, field.getName(), numericVal);
                    continue block7;
                }
            }
        }
    }

    private void writeStringColumn(TupleWriter rowWriter, String name, String value) {
        int index = rowWriter.tupleSchema().index(name);
        if (index == -1) {
            PrimitiveColumnMetadata colSchema = MetadataUtils.newScalar((String)name, (TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
            index = rowWriter.addColumn((ColumnMetadata)colSchema);
        }
        ScalarWriter colWriter = rowWriter.scalar(index);
        colWriter.setString(value);
    }

    private void writeDoubleColumn(TupleWriter rowWriter, String name, double value) {
        int index = rowWriter.tupleSchema().index(name);
        if (index == -1) {
            PrimitiveColumnMetadata colSchema = MetadataUtils.newScalar((String)name, (TypeProtos.MinorType)TypeProtos.MinorType.FLOAT8, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
            index = rowWriter.addColumn((ColumnMetadata)colSchema);
        }
        ScalarWriter colWriter = rowWriter.scalar(index);
        colWriter.setDouble(value);
    }

    private void writeBooleanColumn(TupleWriter rowWriter, String name, int value) {
        int index = rowWriter.tupleSchema().index(name);
        if (index == -1) {
            PrimitiveColumnMetadata colSchema = MetadataUtils.newScalar((String)name, (TypeProtos.MinorType)TypeProtos.MinorType.INT, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
            index = rowWriter.addColumn((ColumnMetadata)colSchema);
        }
        boolean boolean_value = true;
        if (value == 0) {
            boolean_value = false;
        }
        ScalarWriter colWriter = rowWriter.scalar(index);
        colWriter.setBoolean(boolean_value);
    }

    private void writeIntColumn(TupleWriter rowWriter, String name, int value) {
        int index = rowWriter.tupleSchema().index(name);
        if (index == -1) {
            PrimitiveColumnMetadata colSchema = MetadataUtils.newScalar((String)name, (TypeProtos.MinorType)TypeProtos.MinorType.INT, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
            index = rowWriter.addColumn((ColumnMetadata)colSchema);
        }
        ScalarWriter colWriter = rowWriter.scalar(index);
        colWriter.setInt(value);
    }

    private void writeTimeColumn(TupleWriter rowWriter, String name, long value) {
        int index = rowWriter.tupleSchema().index(name);
        Instant instant = Instant.ofEpochMilli(value);
        if (index == -1) {
            PrimitiveColumnMetadata colSchema = MetadataUtils.newScalar((String)name, (TypeProtos.MinorType)TypeProtos.MinorType.INT, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
            index = rowWriter.addColumn((ColumnMetadata)colSchema);
        }
        ScalarWriter colWriter = rowWriter.scalar(index);
        colWriter.setTimestamp(instant);
    }

    public void close() {
        this.closeStream(this.fileReaderShp, "ESRI Shapefile");
        this.closeStream(this.fileReaderDbf, "DBF Shapefile");
        this.closeStream(this.fileReaderPrj, "PRJ Shapefile");
        try {
            if (this.dbfReader != null) {
                this.dbfReader.close();
            }
        }
        catch (Exception e) {
            logger.warn("Error when closing DBF Reader: {}", (Object)e.getMessage());
        }
        this.dbfReader = null;
    }

    private void closeStream(InputStream inputStream, String name) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            logger.warn("Error when closing {}: {}", (Object)name, (Object)e.getMessage());
        }
        inputStream = null;
    }
}

