/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.oracle.bmc.hdfs.BmcFilesystemImpl;
import com.oracle.bmc.hdfs.BmcProperties;
import com.oracle.bmc.hdfs.store.BmcDataStore;
import com.oracle.bmc.hdfs.store.BmcPropertyAccessor;
import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmcFilesystem
extends FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(BmcFilesystem.class);
    private volatile BmcFilesystemImpl delegate;
    private static volatile LoadingCache<FSKey, BmcFilesystemImpl> fsCache = null;

    private static synchronized void setupFilesystemCache(Configuration configuration) {
        if (fsCache != null) {
            return;
        }
        BmcPropertyAccessor propertyAccessor = new BmcPropertyAccessor(configuration, "");
        CacheLoader<FSKey, BmcFilesystemImpl> loader = new CacheLoader<FSKey, BmcFilesystemImpl>(){

            public BmcFilesystemImpl load(FSKey key) throws Exception {
                LOG.info("Creating new BmcFilesystemImpl delegate for " + key.uri);
                BmcFilesystemImpl impl = new BmcFilesystemImpl();
                impl.initialize(key.uri, key.configuration);
                return impl;
            }
        };
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().removalListener(rn -> {
            LOG.info("Physically closing delegate for " + ((FSKey)rn.getKey()).uri);
            try {
                ((BmcFilesystemImpl)((Object)((Object)rn.getValue()))).close();
            }
            catch (IOException ioe) {
                LOG.warn("IOException " + ioe + " while physically closing " + ((FSKey)rn.getKey()).uri);
            }
        });
        if (!propertyAccessor.asBoolean().get(BmcProperties.FILESYSTEM_CACHING_ENABLED).booleanValue()) {
            LOG.info("BmcFilesystem caching disabled");
            fsCache = cacheBuilder.maximumSize(0L).build((CacheLoader)loader);
            return;
        }
        propertyAccessor.asInteger().forNonNull(BmcProperties.FILESYSTEM_CACHING_MAXIMUM_SIZE, i -> cacheBuilder.maximumSize((long)i.intValue()));
        propertyAccessor.asInteger().forNonNull(BmcProperties.FILESYSTEM_CACHING_INITIAL_CAPACITY, i -> cacheBuilder.initialCapacity(i.intValue()));
        propertyAccessor.asInteger().forNonNull(BmcProperties.FILESYSTEM_CACHING_EXPIRE_AFTER_ACCESS_SECONDS, i -> cacheBuilder.expireAfterAccess((long)i.intValue(), TimeUnit.SECONDS));
        propertyAccessor.asInteger().forNonNull(BmcProperties.FILESYSTEM_CACHING_EXPIRE_AFTER_WRITE_SECONDS, i -> cacheBuilder.expireAfterWrite((long)i.intValue(), TimeUnit.SECONDS));
        fsCache = cacheBuilder.build((CacheLoader)loader);
        LOG.info("BmcFilesystem caching enabled, settings " + cacheBuilder);
    }

    public void initialize(URI uri, Configuration configuration) throws IOException {
        if (this.delegate != null) {
            return;
        }
        BmcFilesystem.setupFilesystemCache(configuration);
        this.delegate = (BmcFilesystemImpl)((Object)fsCache.getUnchecked((Object)new FSKey(uri, configuration)));
    }

    public String getScheme() {
        return "oci";
    }

    public FSDataOutputStream append(Path path, int bufferSize, Progressable progress) throws IOException {
        return this.delegate.append(path, bufferSize, progress);
    }

    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.delegate.create(path, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.delegate.createNonRecursive(f, permission, flags, bufferSize, replication, blockSize, progress);
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        return this.delegate.delete(path, recursive);
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        return this.delegate.getFileStatus(path);
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        return this.delegate.listStatus(path);
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        return this.delegate.mkdirs(path, permission);
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        return this.delegate.open(path, bufferSize);
    }

    public boolean rename(Path source, Path destination) throws IOException {
        return this.delegate.rename(source, destination);
    }

    public long getDefaultBlockSize() {
        return this.delegate.getDefaultBlockSize();
    }

    public int getDefaultPort() {
        return this.delegate.getDefaultPort();
    }

    public String getCanonicalServiceName() {
        return this.delegate.getCanonicalServiceName();
    }

    public void close() throws IOException {
    }

    public Path getWorkingDirectory() {
        return this.delegate.getWorkingDirectory();
    }

    public void setWorkingDirectory(Path workingDirectory) {
        this.delegate.setWorkingDirectory(workingDirectory);
    }

    public URI getUri() {
        return this.delegate.getUri();
    }

    public BmcDataStore getDataStore() {
        return this.delegate.getDataStore();
    }

    public Configuration getConf() {
        return this.delegate.getConf();
    }

    private static class FSKey {
        private final URI uri;
        private final Configuration configuration;

        public FSKey(URI uri, Configuration configuration) {
            this.uri = uri;
            this.configuration = configuration;
        }

        public int hashCode() {
            return Objects.hash(this.uri, this.configuration);
        }

        public boolean equals(Object o) {
            try {
                FSKey that = (FSKey)o;
                return this.uri.equals(that.uri) && this.configuration.equals(that.configuration);
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    @VisibleForTesting
    static class UriParser
    extends BmcFilesystemImpl.UriParser {
        UriParser(URI uri) {
            super(uri);
        }
    }
}

