/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.writers.primitive;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.drill.exec.store.hive.writers.primitive.AbstractSingleValueWriter;
import org.apache.drill.exec.vector.complex.writer.VarDecimalWriter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;

public class HiveDecimalWriter
extends AbstractSingleValueWriter<HiveDecimalObjectInspector, VarDecimalWriter> {
    private final int scale;

    public HiveDecimalWriter(HiveDecimalObjectInspector inspector, VarDecimalWriter writer, int scale) {
        super(inspector, writer);
        this.scale = scale;
    }

    @Override
    public void write(Object value) {
        BigDecimal decimalValue = ((HiveDecimalObjectInspector)this.inspector).getPrimitiveJavaObject(value).bigDecimalValue().setScale(this.scale, RoundingMode.HALF_UP);
        ((VarDecimalWriter)this.writer).writeVarDecimal(decimalValue);
    }
}

