/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.planner.types.HiveToRelDataTypeConverter;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveStoragePlugin;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;

public class DrillHiveTable
extends DrillTable {
    protected final HiveTableWithColumnCache hiveTable;

    public DrillHiveTable(String storageEngineName, HiveStoragePlugin plugin, String userName, HiveReadEntry readEntry) {
        super(storageEngineName, (StoragePlugin)plugin, userName, (DrillTableSelection)readEntry);
        this.hiveTable = new HiveTableWithColumnCache(readEntry.getTable());
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        HiveToRelDataTypeConverter dataTypeConverter = new HiveToRelDataTypeConverter(typeFactory);
        ArrayList fieldNames = new ArrayList();
        List fieldTypes = Stream.of(this.hiveTable.getColumnListsCache().getTableSchemaColumns(), this.hiveTable.getPartitionKeys()).flatMap(Collection::stream).peek(hiveField -> fieldNames.add(hiveField.getName())).map(dataTypeConverter::convertToNullableRelDataType).collect(Collectors.toList());
        return typeFactory.createStructType(fieldTypes, fieldNames);
    }
}

