/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.readers;

import com.google.common.util.concurrent.ListenableFuture;
import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.hive.HivePartition;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.drill.exec.store.hive.writers.HiveValueWriter;
import org.apache.drill.exec.store.hive.writers.HiveValueWriterFactory;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.impl.VectorContainerWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveDefaultRecordReader
extends AbstractRecordReader {
    protected static final Logger logger = LoggerFactory.getLogger(HiveDefaultRecordReader.class);
    public static final int TARGET_RECORD_COUNT = 4000;
    private static final boolean PARTITION_COLUMNS = true;
    protected VectorContainerWriter outputWriter;
    private final HiveTableWithColumnCache hiveTable;
    private final UserGroupInformation proxyUserGroupInfo;
    private final HiveConf hiveConf;
    private final HivePartition partition;
    private JobConf job;
    protected Deserializer partitionDeserializer;
    private StructObjectInspector partitionObjInspector;
    protected ObjectInspectorConverters.Converter partitionToTableSchemaConverter;
    private StructObjectInspector finalObjInspector;
    private HiveValueWriter[] columnValueWriters;
    protected boolean empty;
    private final DrillBuf drillBuf;
    private final FragmentContext fragmentContext;
    private ValueVector[] partitionVectors;
    private Object[] partitionValues;
    private final Iterator<InputSplit> inputSplitsIterator;
    protected RecordReader<Object, Object> mapredReader;
    private Object key;
    protected Object valueHolder;
    private StructField[] selectedStructFieldRefs;

    public HiveDefaultRecordReader(HiveTableWithColumnCache table, HivePartition partition, Collection<InputSplit> inputSplits, List<SchemaPath> projectedColumns, FragmentContext context, HiveConf hiveConf, UserGroupInformation proxyUgi) {
        this.hiveTable = table;
        this.partition = partition;
        this.hiveConf = hiveConf;
        this.proxyUserGroupInfo = proxyUgi;
        this.empty = inputSplits == null || inputSplits.isEmpty();
        this.inputSplitsIterator = this.empty ? Collections.emptyIterator() : inputSplits.iterator();
        this.drillBuf = context.getManagedBuffer();
        this.partitionVectors = new ValueVector[0];
        this.partitionValues = new Object[0];
        this.setColumns(projectedColumns);
        this.fragmentContext = context;
    }

    public void setup(OperatorContext context, OutputMutator output) throws ExecutionSetupException {
        ListenableFuture initTaskFuture = context.runCallableAs(this.proxyUserGroupInfo, this.getInitTask(output));
        try {
            initTaskFuture.get();
        }
        catch (InterruptedException e) {
            initTaskFuture.cancel(true);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw ExecutionSetupException.fromThrowable((String)e.getMessage(), (Throwable)e);
        }
    }

    private Callable<Void> getInitTask(OutputMutator output) {
        return () -> {
            List idsOfProjectedColumns;
            List selectedPartitionColumnNames;
            List<Object> selectedColumnNames;
            this.job = new JobConf((Configuration)this.hiveConf);
            Properties hiveTableProperties = HiveUtilities.getTableMetadata(this.hiveTable);
            Deserializer tableDeserializer = HiveDefaultRecordReader.createDeserializer(this.job, this.hiveTable.getSd(), hiveTableProperties);
            StructObjectInspector tableObjInspector = HiveDefaultRecordReader.getStructOI(tableDeserializer);
            if (this.partition == null) {
                this.partitionDeserializer = tableDeserializer;
                this.partitionObjInspector = tableObjInspector;
                this.partitionToTableSchemaConverter = obj -> obj;
                this.finalObjInspector = tableObjInspector;
                HiveUtilities.addConfToJob(this.job, hiveTableProperties);
                this.job.setInputFormat(HiveUtilities.getInputFormatClass(this.job, this.hiveTable.getSd(), this.hiveTable));
                HiveUtilities.verifyAndAddTransactionalProperties(this.job, this.hiveTable.getSd());
            } else {
                Properties partitionProperties = HiveUtilities.getPartitionMetadata(this.partition, this.hiveTable);
                HiveUtilities.addConfToJob(this.job, partitionProperties);
                this.partitionDeserializer = HiveDefaultRecordReader.createDeserializer(this.job, this.partition.getSd(), partitionProperties);
                this.partitionObjInspector = HiveDefaultRecordReader.getStructOI(this.partitionDeserializer);
                this.finalObjInspector = (StructObjectInspector)ObjectInspectorConverters.getConvertedOI((ObjectInspector)this.partitionObjInspector, (ObjectInspector)tableObjInspector);
                this.partitionToTableSchemaConverter = ObjectInspectorConverters.getConverter((ObjectInspector)this.partitionObjInspector, (ObjectInspector)this.finalObjInspector);
                this.job.setInputFormat(HiveUtilities.getInputFormatClass(this.job, this.partition.getSd(), this.hiveTable));
                HiveUtilities.verifyAndAddTransactionalProperties(this.job, this.partition.getSd());
            }
            List partitionKeyFields = this.hiveTable.getPartitionKeys();
            List partitionColumnNames = partitionKeyFields.stream().map(FieldSchema::getName).collect(Collectors.toList());
            ArrayList allTableColumnNames = ((StructTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.finalObjInspector)).getAllStructFieldNames();
            if (this.isStarQuery()) {
                selectedColumnNames = allTableColumnNames;
                selectedPartitionColumnNames = partitionColumnNames;
                idsOfProjectedColumns = IntStream.range(0, selectedColumnNames.size()).boxed().collect(Collectors.toList());
            } else {
                Map<Boolean, List<String>> groupOfSelectedColumns = this.getColumns().stream().map(SchemaPath::getRootSegment).map(PathSegment.NameSegment::getPath).distinct().collect(Collectors.groupingBy(partitionColumnNames::contains));
                selectedColumnNames = groupOfSelectedColumns.getOrDefault(false, Collections.emptyList());
                selectedPartitionColumnNames = groupOfSelectedColumns.getOrDefault(true, Collections.emptyList());
                idsOfProjectedColumns = selectedColumnNames.stream().map(allTableColumnNames::indexOf).collect(Collectors.toList());
            }
            List nestedColumnPaths = this.getColumns().stream().map(SchemaPath::getRootSegmentPath).collect(Collectors.toList());
            ColumnProjectionUtils.appendReadColumns((Configuration)this.job, idsOfProjectedColumns, (List)selectedColumnNames, nestedColumnPaths);
            this.selectedStructFieldRefs = new StructField[selectedColumnNames.size()];
            this.columnValueWriters = new HiveValueWriter[selectedColumnNames.size()];
            this.outputWriter = new VectorContainerWriter(output, false);
            HiveValueWriterFactory hiveColumnValueWriterFactory = new HiveValueWriterFactory(this.fragmentContext.getManagedBufferManager(), this.outputWriter.getWriter());
            for (int refIdx = 0; refIdx < this.selectedStructFieldRefs.length; ++refIdx) {
                StructField fieldRef;
                String columnName = (String)selectedColumnNames.get(refIdx);
                this.selectedStructFieldRefs[refIdx] = fieldRef = this.finalObjInspector.getStructFieldRef(columnName);
                this.columnValueWriters[refIdx] = hiveColumnValueWriterFactory.createHiveColumnValueWriter(columnName, fieldRef);
            }
            if (this.partition != null && selectedPartitionColumnNames.size() > 0) {
                ArrayList<ValueVector> partitionVectorList = new ArrayList<ValueVector>(selectedPartitionColumnNames.size());
                ArrayList<Object> partitionValueList = new ArrayList<Object>(selectedPartitionColumnNames.size());
                String defaultPartitionValue = this.hiveConf.get(HiveConf.ConfVars.DEFAULTPARTITIONNAME.varname);
                OptionManager options = this.fragmentContext.getOptions();
                for (int i = 0; i < partitionKeyFields.size(); ++i) {
                    FieldSchema field = (FieldSchema)partitionKeyFields.get(i);
                    String partitionColumnName = field.getName();
                    if (!selectedPartitionColumnNames.contains(partitionColumnName)) continue;
                    TypeInfo partitionColumnTypeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)field.getType());
                    TypeProtos.MajorType majorType = HiveUtilities.getMajorTypeFromHiveTypeInfo(partitionColumnTypeInfo, (OptionSet)options);
                    MaterializedField materializedField = MaterializedField.create((String)partitionColumnName, (TypeProtos.MajorType)majorType);
                    Class partitionVectorClass = TypeHelper.getValueVectorClass((TypeProtos.MinorType)materializedField.getType().getMinorType(), (TypeProtos.DataMode)materializedField.getDataMode());
                    ValueVector partitionVector = output.addField(materializedField, partitionVectorClass);
                    partitionVectorList.add(partitionVector);
                    Object partitionValue = HiveUtilities.convertPartitionType(partitionColumnTypeInfo, (String)this.partition.getValues().get(i), defaultPartitionValue);
                    partitionValueList.add(partitionValue);
                }
                this.partitionVectors = partitionVectorList.toArray(new ValueVector[0]);
                this.partitionValues = partitionValueList.toArray();
            }
            if (!this.empty && this.initNextReader(this.job)) {
                this.key = this.mapredReader.createKey();
                this.valueHolder = this.mapredReader.createValue();
                this.internalInit(hiveTableProperties);
            }
            return null;
        };
    }

    protected void internalInit(Properties hiveTableProperties) {
    }

    public int next() {
        this.outputWriter.allocate();
        this.outputWriter.reset();
        if (this.empty) {
            this.outputWriter.setValueCount(0);
            this.populatePartitionVectors(0);
            return 0;
        }
        try {
            int recordCount;
            for (recordCount = 0; recordCount < 4000 && this.hasNextValue(this.valueHolder); ++recordCount) {
                Object deserializedHiveRecord = this.partitionToTableSchemaConverter.convert(this.partitionDeserializer.deserialize((Writable)this.valueHolder));
                this.outputWriter.setPosition(recordCount);
                this.readHiveRecordAndInsertIntoRecordBatch(deserializedHiveRecord);
            }
            this.outputWriter.setValueCount(recordCount);
            this.populatePartitionVectors(recordCount);
            return recordCount;
        }
        catch (IOException | ExecutionSetupException | SerDeException e) {
            throw new DrillRuntimeException(e.getMessage(), e);
        }
    }

    protected void readHiveRecordAndInsertIntoRecordBatch(Object rowValue) {
        for (int columnRefIdx = 0; columnRefIdx < this.selectedStructFieldRefs.length; ++columnRefIdx) {
            Object columnValue = this.finalObjInspector.getStructFieldData(rowValue, this.selectedStructFieldRefs[columnRefIdx]);
            if (columnValue == null) continue;
            this.columnValueWriters[columnRefIdx].write(columnValue);
        }
    }

    protected boolean hasNextValue(Object valueHolder) throws IOException, ExecutionSetupException {
        do {
            if (!this.mapredReader.next(this.key, valueHolder)) continue;
            return true;
        } while (this.initNextReader(this.job));
        return false;
    }

    public void close() {
        this.closeMapredReader();
    }

    private static Deserializer createDeserializer(JobConf job, StorageDescriptor sd, Properties properties) throws Exception {
        Class<Deserializer> c = Class.forName(sd.getSerdeInfo().getSerializationLib()).asSubclass(Deserializer.class);
        Deserializer deserializer = c.getConstructor(new Class[0]).newInstance(new Object[0]);
        deserializer.initialize((Configuration)job, properties);
        return deserializer;
    }

    private static StructObjectInspector getStructOI(Deserializer deserializer) throws SerDeException {
        ObjectInspector oi = deserializer.getObjectInspector();
        if (oi.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new UnsupportedOperationException(String.format("%s category not supported", oi.getCategory()));
        }
        return (StructObjectInspector)oi;
    }

    private void populatePartitionVectors(int recordCount) {
        if (this.partition == null) {
            return;
        }
        for (int i = 0; i < this.partitionVectors.length; ++i) {
            ValueVector vector = this.partitionVectors[i];
            AllocationHelper.allocateNew((ValueVector)vector, (int)recordCount);
            if (this.partitionValues[i] != null) {
                HiveUtilities.populateVector(vector, this.drillBuf, this.partitionValues[i], 0, recordCount);
            }
            vector.getMutator().setValueCount(recordCount);
        }
    }

    private boolean initNextReader(JobConf job) throws ExecutionSetupException {
        if (this.inputSplitsIterator.hasNext()) {
            this.closeMapredReader();
            InputSplit inputSplit = this.inputSplitsIterator.next();
            try {
                this.mapredReader = job.getInputFormat().getRecordReader(inputSplit, job, Reporter.NULL);
                logger.trace("hive mapredReader created: {} for inputSplit {}", (Object)this.mapredReader.getClass().getName(), (Object)inputSplit.toString());
                return true;
            }
            catch (Exception e) {
                throw new ExecutionSetupException("Failed to get o.a.hadoop.mapred.RecordReader from Hive InputFormat", (Throwable)e);
            }
        }
        return false;
    }

    private void closeMapredReader() {
        if (this.mapredReader != null) {
            try {
                this.mapredReader.close();
            }
            catch (Exception e) {
                logger.warn("Failure while closing Hive Record mapredReader.", (Throwable)e);
            }
            finally {
                this.mapredReader = null;
            }
        }
    }
}

