/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.client;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.schema.Schema;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.client.DrillHiveMetaStoreClient;
import org.apache.drill.exec.store.hive.client.HiveAuthorizationHelper;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DrillHiveMetaStoreClientWithAuthorization
extends DrillHiveMetaStoreClient {
    private static final Logger logger = LoggerFactory.getLogger(DrillHiveMetaStoreClientWithAuthorization.class);
    static final String DRILL2HMS_TOKEN = "DrillDelegationTokenForHiveMetaStoreServer";
    private final UserGroupInformation ugiForRpc;
    private final HiveAuthorizationHelper authorizer;

    DrillHiveMetaStoreClientWithAuthorization(HiveConf hiveConf, UserGroupInformation ugiForRpc, String userName) throws TException {
        super(hiveConf);
        this.ugiForRpc = ugiForRpc;
        this.authorizer = new HiveAuthorizationHelper((IMetaStoreClient)this, hiveConf, userName);
    }

    @Override
    public List<String> getDatabases(boolean ignoreAuthzErrors) throws TException {
        try {
            this.authorizer.authorizeShowDatabases();
        }
        catch (HiveAccessControlException e) {
            if (ignoreAuthzErrors) {
                return Collections.emptyList();
            }
            throw UserException.permissionError((Throwable)e).build(logger);
        }
        return super.getDatabases(ignoreAuthzErrors);
    }

    @Override
    public HiveReadEntry getHiveReadEntry(String dbName, String tableName, boolean ignoreAuthzErrors) throws TException {
        block2: {
            try {
                this.authorizer.authorizeReadTable(dbName, tableName);
            }
            catch (HiveAccessControlException e) {
                if (ignoreAuthzErrors) break block2;
                throw UserException.permissionError((Throwable)e).build(logger);
            }
        }
        return super.getHiveReadEntry(dbName, tableName, ignoreAuthzErrors);
    }

    @Override
    public Map<String, Schema.TableType> getTableNamesAndTypes(String dbName, boolean ignoreAuthzErrors) throws TException {
        try {
            this.authorizer.authorizeShowTables(dbName);
        }
        catch (HiveAccessControlException e) {
            if (ignoreAuthzErrors) {
                return Collections.emptyMap();
            }
            throw UserException.permissionError((Throwable)e).build(logger);
        }
        return super.getTableNamesAndTypes(dbName, ignoreAuthzErrors);
    }

    public void reconnect() throws MetaException {
        try {
            this.ugiForRpc.doAs(() -> {
                super.reconnect();
                return null;
            });
        }
        catch (IOException | InterruptedException e) {
            throw new DrillRuntimeException("Failed to reconnect to HiveMetaStore: " + e.getMessage(), (Throwable)e);
        }
    }
}

