/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.planner.sql.logical.ConvertHiveParquetScanToDrillParquetScan;
import org.apache.drill.exec.planner.sql.logical.HivePushPartitionFilterIntoScan;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.SessionOptionManager;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.dfs.FormatPlugin;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveScan;
import org.apache.drill.exec.store.hive.HiveStoragePluginConfig;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.drill.exec.store.hive.schema.HiveSchemaFactory;
import org.apache.drill.exec.store.mapr.db.MapRDBPushFilterIntoScan;
import org.apache.drill.exec.store.mapr.db.MapRDBPushLimitIntoScan;
import org.apache.drill.exec.store.mapr.db.MapRDBPushProjectIntoScan;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveStoragePlugin
extends AbstractStoragePlugin {
    private static final Logger logger = LoggerFactory.getLogger(HiveStoragePlugin.class);
    public static final String HIVE_MAPRDB_FORMAT_PLUGIN_NAME = "hive-maprdb";
    private final HiveStoragePluginConfig config;
    private HiveSchemaFactory schemaFactory;
    private final HiveConf hiveConf;

    public HiveStoragePlugin(HiveStoragePluginConfig config, DrillbitContext context, String name) throws ExecutionSetupException {
        super(context, name);
        this.config = config;
        this.hiveConf = HiveUtilities.generateHiveConf(config.getConfigProps());
        this.schemaFactory = new HiveSchemaFactory(this, name, this.hiveConf);
    }

    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    public HiveStoragePluginConfig getConfig() {
        return this.config;
    }

    public HiveScan getPhysicalScan(String userName, JSONOptions selection, SessionOptionManager options) throws IOException {
        return this.getPhysicalScan(userName, selection, AbstractGroupScan.ALL_COLUMNS, options);
    }

    public HiveScan getPhysicalScan(String userName, JSONOptions selection, List<SchemaPath> columns) throws IOException {
        return this.getPhysicalScan(userName, selection, (List)columns, (SessionOptionManager)null);
    }

    public HiveScan getPhysicalScan(String userName, JSONOptions selection, List<SchemaPath> columns, SessionOptionManager options) throws IOException {
        HiveReadEntry hiveReadEntry = (HiveReadEntry)selection.getListWith(new ObjectMapper(), (TypeReference)new TypeReference<HiveReadEntry>(){});
        try {
            Map<String, String> confProperties = new HashMap<String, String>();
            if (options != null) {
                String value = StringEscapeUtils.unescapeJava((String)options.getString("store.hive.conf.properties"));
                logger.trace("[{}] is set to {}.", (Object)"store.hive.conf.properties", (Object)value);
                try {
                    Properties properties = new Properties();
                    properties.load(new StringReader(value));
                    confProperties = properties.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), properties::getProperty, (o, n) -> n));
                }
                catch (IOException e) {
                    logger.warn("Unable to parse Hive conf properties {}, ignoring them.", (Object)value);
                }
            }
            return new HiveScan(userName, hiveReadEntry, this, columns, null, confProperties);
        }
        catch (ExecutionSetupException e) {
            throw new IOException(e);
        }
    }

    public synchronized void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) throws IOException {
        try {
            this.schemaFactory.registerSchemas(schemaConfig, parent);
            return;
        }
        catch (Throwable e) {
            Throwable ex = e;
            while (!(ex instanceof MetaException) && !(ex instanceof TTransportException)) {
                if (ex.getCause() == null || ex.getCause() == ex) {
                    logger.error("Hive metastore register schemas failed", e);
                    throw new DrillRuntimeException("Unknown Hive error", e);
                }
                ex = ex.getCause();
            }
            try {
                this.schemaFactory.close();
            }
            catch (Throwable t) {
                logger.warn("Schema factory forced close failed, error ignored", t);
            }
            try {
                this.schemaFactory = new HiveSchemaFactory(this, this.getName(), this.hiveConf);
            }
            catch (ExecutionSetupException e2) {
                throw new DrillRuntimeException((Throwable)e2);
            }
            this.schemaFactory.registerSchemas(schemaConfig, parent);
            logger.debug("Successfully recovered from a Hive metastore connection failure.");
            return;
        }
    }

    public Set<StoragePluginOptimizerRule> getLogicalOptimizerRules(OptimizerRulesContext optimizerContext) {
        String defaultPartitionValue = this.hiveConf.get(HiveConf.ConfVars.DEFAULTPARTITIONNAME.varname);
        ImmutableSet.Builder ruleBuilder = ImmutableSet.builder();
        ruleBuilder.add((Object)HivePushPartitionFilterIntoScan.getFilterOnProject(optimizerContext, defaultPartitionValue));
        ruleBuilder.add((Object)HivePushPartitionFilterIntoScan.getFilterOnScan(optimizerContext, defaultPartitionValue));
        return ruleBuilder.build();
    }

    public Set<StoragePluginOptimizerRule> getPhysicalOptimizerRules(OptimizerRulesContext optimizerRulesContext) {
        ImmutableSet.Builder ruleBuilder = ImmutableSet.builder();
        OptionManager options = optimizerRulesContext.getPlannerSettings().getOptions();
        if (options.getBoolean("store.hive.optimize_scan_with_native_readers") || options.getBoolean("store.hive.parquet.optimize_scan_with_native_reader")) {
            ruleBuilder.add((Object)ConvertHiveParquetScanToDrillParquetScan.INSTANCE);
        }
        if (options.getBoolean("store.hive.maprdb_json.optimize_scan_with_native_reader")) {
            try {
                Class<?> hiveToDrillMapRDBJsonRuleClass = Class.forName("org.apache.drill.exec.planner.sql.logical.ConvertHiveMapRDBJsonScanToDrillMapRDBJsonScan");
                ruleBuilder.add((Object)((StoragePluginOptimizerRule)hiveToDrillMapRDBJsonRuleClass.getField("INSTANCE").get(null)));
                this.addMaprDBOptimizerRules((ImmutableSet.Builder<StoragePluginOptimizerRule>)ruleBuilder);
            }
            catch (ReflectiveOperationException e) {
                logger.warn("Current Drill build is not designed for working with Hive MapR-DB tables. Please disable {} option", (Object)"store.hive.maprdb_json.optimize_scan_with_native_reader");
            }
        }
        return ruleBuilder.build();
    }

    private void addMaprDBOptimizerRules(ImmutableSet.Builder<StoragePluginOptimizerRule> ruleBuilder) {
        ruleBuilder.add((Object[])new StoragePluginOptimizerRule[]{MapRDBPushFilterIntoScan.FILTER_ON_SCAN, MapRDBPushFilterIntoScan.FILTER_ON_PROJECT, MapRDBPushProjectIntoScan.PROJECT_ON_SCAN, MapRDBPushLimitIntoScan.LIMIT_ON_PROJECT, MapRDBPushLimitIntoScan.LIMIT_ON_SCAN, MapRDBPushLimitIntoScan.LIMIT_ON_RKJOIN});
    }

    public Configuration getConf() {
        return this.hiveConf;
    }

    public FormatPlugin getFormatPlugin(FormatPluginConfig formatConfig) {
        try {
            Class<?> mapRDBFormatPluginConfigClass = Class.forName("org.apache.drill.exec.store.mapr.db.MapRDBFormatPluginConfig");
            Class<?> mapRDBFormatPluginClass = Class.forName("org.apache.drill.exec.store.mapr.db.MapRDBFormatPlugin");
            if (mapRDBFormatPluginConfigClass.isInstance(formatConfig)) {
                return (FormatPlugin)mapRDBFormatPluginClass.getConstructor(String.class, DrillbitContext.class, Configuration.class, StoragePluginConfig.class, mapRDBFormatPluginConfigClass).newInstance(new Object[]{HIVE_MAPRDB_FORMAT_PLUGIN_NAME, this.context, this.hiveConf, this.config, formatConfig});
            }
        }
        catch (ReflectiveOperationException e) {
            throw new DrillRuntimeException("The error is occurred while connecting to MapR-DB or instantiating mapRDBFormatPlugin", (Throwable)e);
        }
        throw new DrillRuntimeException(String.format("Hive storage plugin doesn't support usage of %s format plugin", formatConfig.getClass().getName()));
    }
}

