/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.logical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.sql.DrillSqlOperator;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.hive.HiveDrillNativeParquetScan;
import org.apache.drill.exec.store.hive.HiveMetadataProvider;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveScan;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertHiveParquetScanToDrillParquetScan
extends StoragePluginOptimizerRule {
    private static final Logger logger = LoggerFactory.getLogger(ConvertHiveParquetScanToDrillParquetScan.class);
    public static final ConvertHiveParquetScanToDrillParquetScan INSTANCE = new ConvertHiveParquetScanToDrillParquetScan();
    private static final DrillSqlOperator INT96_TO_TIMESTAMP = new DrillSqlOperator("convert_fromTIMESTAMP_IMPALA", 1, true, false);
    private static final DrillSqlOperator RTRIM = new DrillSqlOperator("RTRIM", 1, true, false);

    private ConvertHiveParquetScanToDrillParquetScan() {
        super(RelOptHelper.any(DrillScanRel.class), "ConvertHiveScanToHiveDrillNativeScan:Parquet");
    }

    public boolean matches(RelOptRuleCall call) {
        return HiveUtilities.nativeReadersRuleMatches(call, MapredParquetInputFormat.class);
    }

    public void onMatch(RelOptRuleCall call) {
        try {
            DrillScanRel hiveScanRel = (DrillScanRel)call.rel(0);
            HiveScan hiveScan = (HiveScan)hiveScanRel.getGroupScan();
            PlannerSettings settings = PrelUtil.getPlannerSettings((RelOptPlanner)call.getPlanner());
            String partitionColumnLabel = settings.getFsPartitionColumnLabel();
            HiveTableWithColumnCache hiveTable = hiveScan.getHiveReadEntry().getTable();
            HiveReadEntry hiveReadEntry = hiveScan.getHiveReadEntry();
            HiveMetadataProvider hiveMetadataProvider = new HiveMetadataProvider(hiveScan.getUserName(), hiveReadEntry, hiveScan.getHiveConf());
            List<HiveMetadataProvider.LogicalInputSplit> logicalInputSplits = hiveMetadataProvider.getInputSplits(hiveReadEntry);
            if (logicalInputSplits.isEmpty()) {
                return;
            }
            Map<String, String> partitionColMapping = this.getPartitionColMapping(hiveTable, partitionColumnLabel);
            DrillScanRel nativeScanRel = this.createNativeScanRel(partitionColMapping, hiveScanRel, logicalInputSplits, settings.getOptions());
            if (hiveScanRel.getRowType().getFieldCount() == 0) {
                call.transformTo((RelNode)nativeScanRel);
            } else {
                DrillProjectRel projectRel = this.createProjectRel(hiveScanRel, partitionColMapping, nativeScanRel);
                call.transformTo((RelNode)projectRel);
            }
            call.getPlanner().setImportance((RelNode)hiveScanRel, 0.0);
        }
        catch (Exception e) {
            logger.warn("Failed to convert HiveScan to HiveDrillNativeParquetScan", (Throwable)e);
        }
    }

    private Map<String, String> getPartitionColMapping(Table hiveTable, String partitionColumnLabel) {
        HashMap<String, String> partitionColMapping = new HashMap<String, String>();
        int i = 0;
        for (FieldSchema col : hiveTable.getPartitionKeys()) {
            partitionColMapping.put(col.getName(), partitionColumnLabel + i);
            ++i;
        }
        return partitionColMapping;
    }

    private DrillScanRel createNativeScanRel(Map<String, String> partitionColMapping, DrillScanRel hiveScanRel, List<HiveMetadataProvider.LogicalInputSplit> logicalInputSplits, OptionManager options) throws IOException {
        RelDataTypeFactory typeFactory = hiveScanRel.getCluster().getTypeFactory();
        RelDataType varCharType = typeFactory.createSqlType(SqlTypeName.VARCHAR);
        ArrayList<Object> nativeScanColNames = new ArrayList<Object>();
        ArrayList<RelDataType> nativeScanColTypes = new ArrayList<RelDataType>();
        for (RelDataTypeField field : hiveScanRel.getRowType().getFieldList()) {
            String dirColName = partitionColMapping.get(field.getName());
            if (dirColName != null) {
                nativeScanColNames.add(dirColName);
                nativeScanColTypes.add(varCharType);
                continue;
            }
            nativeScanColNames.add(field.getName());
            nativeScanColTypes.add(field.getType());
        }
        RelDataType nativeScanRowType = typeFactory.createStructType(nativeScanColTypes, nativeScanColNames);
        ArrayList<SchemaPath> nativeScanCols = new ArrayList<SchemaPath>();
        for (SchemaPath colName : hiveScanRel.getColumns()) {
            String partitionCol = partitionColMapping.get(colName.getRootSegmentPath());
            if (partitionCol != null) {
                nativeScanCols.add(SchemaPath.getSimplePath((String)partitionCol));
                continue;
            }
            nativeScanCols.add(colName);
        }
        HiveScan hiveScan = (HiveScan)hiveScanRel.getGroupScan();
        HiveDrillNativeParquetScan nativeHiveScan = new HiveDrillNativeParquetScan(hiveScan.getUserName(), nativeScanCols, hiveScan.getStoragePlugin(), logicalInputSplits, hiveScan.getConfProperties(), ParquetReaderConfig.builder().withOptions(options).build());
        return new DrillScanRel(hiveScanRel.getCluster(), hiveScanRel.getTraitSet(), hiveScanRel.getTable(), (GroupScan)nativeHiveScan, nativeScanRowType, nativeScanCols);
    }

    private DrillProjectRel createProjectRel(DrillScanRel hiveScanRel, Map<String, String> partitionColMapping, DrillScanRel nativeScanRel) {
        ArrayList<RexNode> rexNodes = new ArrayList<RexNode>();
        RexBuilder rb = hiveScanRel.getCluster().getRexBuilder();
        RelDataType hiveScanRowType = hiveScanRel.getRowType();
        for (String colName : hiveScanRowType.getFieldNames()) {
            String dirColName = partitionColMapping.get(colName);
            if (dirColName != null) {
                rexNodes.add(this.createPartitionColumnCast(hiveScanRel, nativeScanRel, colName, dirColName, rb));
                continue;
            }
            rexNodes.add(this.createColumnFormatConversion(hiveScanRel, nativeScanRel, colName, rb));
        }
        return DrillProjectRel.create((RelOptCluster)hiveScanRel.getCluster(), (RelTraitSet)hiveScanRel.getTraitSet(), (RelNode)nativeScanRel, rexNodes, (RelDataType)hiveScanRowType);
    }

    private RexNode createColumnFormatConversion(DrillScanRel hiveScanRel, DrillScanRel nativeScanRel, String colName, RexBuilder rb) {
        RelDataType outputType = hiveScanRel.getRowType().getField(colName, false, false).getType();
        RelDataTypeField inputField = nativeScanRel.getRowType().getField(colName, false, false);
        RexInputRef inputRef = rb.makeInputRef(inputField.getType(), inputField.getIndex());
        PlannerSettings settings = PrelUtil.getPlannerSettings((RelOptPlanner)hiveScanRel.getCluster().getPlanner());
        boolean conversionToTimestampEnabled = settings.getOptions().getBoolean("store.parquet.reader.int96_as_timestamp");
        if (outputType.getSqlTypeName() == SqlTypeName.TIMESTAMP && !conversionToTimestampEnabled) {
            return rb.makeCall((SqlOperator)INT96_TO_TIMESTAMP, new RexNode[]{inputRef});
        }
        return inputRef;
    }

    private RexNode createPartitionColumnCast(DrillScanRel hiveScanRel, DrillScanRel nativeScanRel, String outputColName, String dirColName, RexBuilder rb) {
        RelDataType outputType = hiveScanRel.getRowType().getField(outputColName, false, false).getType();
        RelDataTypeField inputField = nativeScanRel.getRowType().getField(dirColName, false, false);
        RexInputRef inputRef = rb.makeInputRef(rb.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), inputField.getIndex());
        if (outputType.getSqlTypeName() == SqlTypeName.CHAR) {
            return rb.makeCall((SqlOperator)RTRIM, new RexNode[]{inputRef});
        }
        return rb.makeCast(outputType, (RexNode)inputRef);
    }
}

