/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.UpdateSummaryEnum;
import liquibase.UpdateSummaryOutputEnum;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.ChangeSetStatus;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.ShouldRunChangeSetFilter;
import liquibase.changelog.visitor.StatusVisitor;
import liquibase.exception.LiquibaseException;
import liquibase.logging.mdc.MdcObject;
import liquibase.logging.mdc.customobjects.UpdateSummary;
import liquibase.report.ShowSummaryGenerator;
import liquibase.report.ShowSummaryGeneratorFactory;
import liquibase.util.StringUtil;
import liquibase.util.TableOutput;

public class ShowSummaryUtil {
    @Deprecated
    public static void showUpdateSummary(DatabaseChangeLog changeLog, UpdateSummaryEnum showSummary, UpdateSummaryOutputEnum showSummaryOutput, StatusVisitor statusVisitor, OutputStream outputStream) throws LiquibaseException, IOException {
        ShowSummaryUtil.showUpdateSummary(changeLog, showSummary, showSummaryOutput, statusVisitor, outputStream, null);
    }

    public static void showUpdateSummary(DatabaseChangeLog changeLog, UpdateSummaryEnum showSummary, UpdateSummaryOutputEnum showSummaryOutput, StatusVisitor statusVisitor, OutputStream outputStream, ChangeLogIterator runChangeLogIterator) throws LiquibaseException, IOException {
        if (showSummary == null || showSummary == UpdateSummaryEnum.OFF) {
            return;
        }
        List<ChangeSetStatus> denied = statusVisitor.getChangeSetsToSkip();
        List<ChangeSet> skippedChangeSets = changeLog.getSkippedChangeSets();
        List<ChangeSetStatus> filterDenied = denied.stream().filter(status -> status.getFilterResults().stream().anyMatch(result -> result.getFilter() != ShouldRunChangeSetFilter.class)).collect(Collectors.toList());
        ShowSummaryGeneratorFactory showSummaryGeneratorFactory = Scope.getCurrentScope().getSingleton(ShowSummaryGeneratorFactory.class);
        ShowSummaryGenerator showSummaryGenerator = showSummaryGeneratorFactory.getShowSummaryGenerator();
        List<ChangeSetStatus> additionalChangeSetStatus = showSummaryGenerator.getAllAdditionalChangeSetStatus(runChangeLogIterator);
        UpdateSummary updateSummaryMdc = ShowSummaryUtil.showSummary(changeLog, statusVisitor, skippedChangeSets, filterDenied, outputStream, showSummaryOutput, runChangeLogIterator);
        updateSummaryMdc.setValue(showSummary.toString());
        boolean shouldPrintDetailTable = showSummary != UpdateSummaryEnum.SUMMARY && (!skippedChangeSets.isEmpty() || !denied.isEmpty() || !additionalChangeSetStatus.isEmpty());
        SortedMap<String, Integer> skippedMdc = ShowSummaryUtil.showDetailTable(skippedChangeSets, filterDenied, outputStream, shouldPrintDetailTable, showSummaryOutput, additionalChangeSetStatus, runChangeLogIterator);
        updateSummaryMdc.setSkipped(skippedMdc);
        try (MdcObject updateSummaryMdcObject = Scope.getCurrentScope().addMdcValue("updateSummary", updateSummaryMdc);){
            Scope.getCurrentScope().getLog(ShowSummaryUtil.class).info("Update summary generated");
        }
    }

    private static SortedMap<String, Integer> showDetailTable(List<ChangeSet> skippedChangeSets, List<ChangeSetStatus> filterDenied, OutputStream outputStream, boolean shouldPrintDetailTable, UpdateSummaryOutputEnum showSummaryOutput, List<ChangeSetStatus> additionalChangesets, ChangeLogIterator runChangeLogIterator) throws IOException, LiquibaseException {
        String totalSkippedMdcKey = "totalSkipped";
        if (filterDenied.isEmpty() && skippedChangeSets.isEmpty() && additionalChangesets.isEmpty()) {
            return new TreeMap<String, Integer>(Collections.singletonMap(totalSkippedMdcKey, 0));
        }
        ArrayList<String> columnHeaders = new ArrayList<String>();
        columnHeaders.add("Changeset Info");
        columnHeaders.add("Reason Skipped");
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        table.add(columnHeaders);
        TreeMap<String, Integer> mdcSkipCounts = new TreeMap<String, Integer>();
        mdcSkipCounts.put(totalSkippedMdcKey, skippedChangeSets.size() + filterDenied.size());
        List<ChangeSetStatus> finalList = ShowSummaryUtil.createFinalStatusList(skippedChangeSets, filterDenied, mdcSkipCounts);
        ShowSummaryGeneratorFactory showSummaryGeneratorFactory = Scope.getCurrentScope().getSingleton(ShowSummaryGeneratorFactory.class);
        ShowSummaryGenerator showSummaryGenerator = showSummaryGeneratorFactory.getShowSummaryGenerator();
        finalList.addAll(showSummaryGenerator.getAllAdditionalChangeSetStatus(runChangeLogIterator));
        finalList.sort(new Comparator<ChangeSetStatus>(){

            @Override
            public int compare(ChangeSetStatus o1, ChangeSetStatus o2) {
                ChangeSet c1 = o1.getChangeSet();
                ChangeSet c2 = o2.getChangeSet();
                int order1 = ShowSummaryUtil.determineOrderInChangelog(c1);
                int order2 = ShowSummaryUtil.determineOrderInChangelog(c2);
                return Integer.compare(order1, order2);
            }
        });
        ArrayList skippedMessages = new ArrayList();
        for (ChangeSetStatus st : finalList) {
            AtomicBoolean flag = new AtomicBoolean(true);
            StringBuilder builder = new StringBuilder();
            st.getFilterResults().forEach(consumer -> {
                if (consumer.getFilter() != null && !consumer.getFilter().isAssignableFrom(ShouldNotCountAsSkipChangesetFilter.class)) {
                    String displayName = consumer.getMdcName();
                    mdcSkipCounts.merge(displayName, 1, Integer::sum);
                }
                String skippedMessage = String.format("   '%s' : %s", st.getChangeSet().toString(), consumer.getMessage());
                skippedMessages.add(skippedMessage);
                if (!flag.get()) {
                    builder.append(System.lineSeparator());
                }
                builder.append(consumer.getMessage());
                flag.set(false);
            });
            ArrayList<String> outputRow = new ArrayList<String>();
            outputRow.add(st.getChangeSet().toString());
            outputRow.add(builder.toString());
            table.add(outputRow);
        }
        if (shouldPrintDetailTable) {
            switch (showSummaryOutput) {
                case CONSOLE: {
                    ShowSummaryUtil.printDetailTable(table, outputStream);
                    break;
                }
                case LOG: {
                    skippedMessages.forEach(ShowSummaryUtil::writeToLog);
                    break;
                }
                default: {
                    ShowSummaryUtil.printDetailTable(table, outputStream);
                    skippedMessages.forEach(ShowSummaryUtil::writeToLog);
                }
            }
        }
        return mdcSkipCounts;
    }

    private static void printDetailTable(List<List<String>> table, OutputStream outputStream) throws IOException, LiquibaseException {
        ArrayList<Integer> widths = new ArrayList<Integer>();
        widths.add(60);
        widths.add(40);
        Writer writer = ShowSummaryUtil.createOutputWriter(outputStream);
        TableOutput.formatOutput(table, widths, true, writer);
    }

    private static List<ChangeSetStatus> createFinalStatusList(List<ChangeSet> skippedChangeSets, List<ChangeSetStatus> filterDenied, SortedMap<String, Integer> mdcSkipCounts) {
        ArrayList<ChangeSetStatus> finalList = new ArrayList<ChangeSetStatus>(filterDenied);
        skippedChangeSets.forEach(skippedChangeSet -> {
            String dbmsList = String.format("'%s'", StringUtil.join(skippedChangeSet.getDbmsSet(), ", "));
            String mismatchMessage = String.format("mismatched DBMS value of %s", dbmsList);
            ChangeSetStatus changeSetStatus = new ChangeSetStatus((ChangeSet)skippedChangeSet);
            ChangeSetFilterResult filterResult = new ChangeSetFilterResult(false, mismatchMessage, DbmsChangeSetFilter.class, "dbmsMismatch", "DBMS mismatch");
            changeSetStatus.setFilterResults(Collections.singleton(filterResult));
            finalList.add(changeSetStatus);
        });
        return finalList;
    }

    private static int determineOrderInChangelog(ChangeSet changeSetToMatch) {
        DatabaseChangeLog changeLog = changeSetToMatch.getChangeLog();
        int order = 0;
        for (ChangeSet changeSet : changeLog.getChangeSets()) {
            if (changeSet == changeSetToMatch) {
                return order;
            }
            ++order;
        }
        return -1;
    }

    private static UpdateSummary showSummary(DatabaseChangeLog changeLog, StatusVisitor statusVisitor, List<ChangeSet> skippedChangeSets, List<ChangeSetStatus> filterDenied, OutputStream outputStream, UpdateSummaryOutputEnum showSummaryOutput, ChangeLogIterator runChangeLogIterator) throws LiquibaseException {
        StringBuilder builder = new StringBuilder();
        builder.append(System.lineSeparator());
        int totalInChangelog = changeLog.getChangeSets().size() + skippedChangeSets.size();
        int skipped = skippedChangeSets.size();
        int filtered = filterDenied.size();
        ShowSummaryGeneratorFactory showSummaryGeneratorFactory = Scope.getCurrentScope().getSingleton(ShowSummaryGeneratorFactory.class);
        ShowSummaryGenerator showSummaryGenerator = showSummaryGeneratorFactory.getShowSummaryGenerator();
        int additional = showSummaryGenerator.getAllAdditionalChangeSetStatus(runChangeLogIterator).size();
        int totalAccepted = statusVisitor.getChangeSetsToRun().size() - additional;
        int totalPreviouslyRun = totalInChangelog - filtered - skipped - totalAccepted - additional;
        UpdateSummary updateSummaryMdc = new UpdateSummary(null, totalAccepted, totalPreviouslyRun, null, totalInChangelog);
        String message = "UPDATE SUMMARY";
        builder.append(message);
        builder.append(System.lineSeparator());
        message = String.format("Run:                     %6d", totalAccepted);
        builder.append(message);
        builder.append(System.lineSeparator());
        message = String.format("Previously run:          %6d", totalPreviouslyRun);
        builder.append(message);
        builder.append(System.lineSeparator());
        message = String.format("Filtered out:            %6d", filtered + skipped);
        builder.append(message);
        builder.append(System.lineSeparator());
        showSummaryGenerator.appendAdditionalSummaryMessages(builder, runChangeLogIterator);
        message = "-------------------------------";
        builder.append(message);
        builder.append(System.lineSeparator());
        message = String.format("Total change sets:       %6d", totalInChangelog);
        builder.append(message);
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        LinkedHashMap<String, Integer> filterSummaryMap = new LinkedHashMap<String, Integer>();
        List<ChangeSetStatus> finalList = ShowSummaryUtil.createFinalStatusList(skippedChangeSets, filterDenied, null);
        finalList.forEach(status -> status.getFilterResults().forEach(result -> {
            if (!result.isAccepted()) {
                String displayName = result.getDisplayName();
                filterSummaryMap.merge(displayName, 1, Integer::sum);
            }
        }));
        if (!filterSummaryMap.isEmpty()) {
            message = "FILTERED CHANGE SETS SUMMARY";
            builder.append(System.lineSeparator());
            builder.append(message);
            builder.append(System.lineSeparator());
            filterSummaryMap.forEach((filterDisplayName, count) -> {
                String filterSummaryDetailMessage = String.format("%-18s       %6d", filterDisplayName + ":", count);
                builder.append(filterSummaryDetailMessage);
                builder.append(System.lineSeparator());
            });
            builder.append(System.lineSeparator());
        }
        ShowSummaryUtil.writeMessage(builder.toString(), showSummaryOutput, outputStream);
        return updateSummaryMdc;
    }

    private static Writer createOutputWriter(OutputStream outputStream) throws IOException {
        String charsetName = GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
        return new OutputStreamWriter(outputStream, charsetName);
    }

    private static void writeMessage(String message, UpdateSummaryOutputEnum showSummaryOutput, OutputStream outputStream) throws LiquibaseException {
        switch (showSummaryOutput) {
            case CONSOLE: {
                ShowSummaryUtil.writeToOutput(outputStream, message);
                break;
            }
            case LOG: {
                ShowSummaryUtil.writeToLog(message);
                break;
            }
            default: {
                ShowSummaryUtil.writeToOutput(outputStream, message);
                ShowSummaryUtil.writeToLog(message);
            }
        }
    }

    private static void writeToOutput(OutputStream outputStream, String message) throws LiquibaseException {
        try {
            Writer writer = ShowSummaryUtil.createOutputWriter(outputStream);
            writer.append(message);
            writer.flush();
        }
        catch (IOException ioe) {
            throw new LiquibaseException(ioe);
        }
    }

    private static void writeToLog(String message) {
        Stream.of(message.split(System.lineSeparator())).filter(s -> !StringUtil.isWhitespace(s)).forEach(Scope.getCurrentScope().getLog(ShowSummaryUtil.class)::info);
    }

    public static interface ShouldNotCountAsSkipChangesetFilter
    extends ChangeSetFilter {
    }
}

