/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.Comparator;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.QueryPartInternal;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;
import org.jooq.impl.RowCondition;

final class RowIsDistinctFrom<T>
extends AbstractCondition {
    private static final long serialVersionUID = 4568269684824736461L;
    private static final Set<SQLDialect> EMULATE_DISTINCT_PREDICATE = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY);
    private static final Set<SQLDialect> SUPPORT_DISTINCT_WITH_ARROW = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private final Row lhs;
    private final Row rhs;
    private final Comparator comparator;
    private transient QueryPartInternal mySQLCondition;
    private transient QueryPartInternal sqliteCondition;
    private transient QueryPartInternal compareCondition;

    RowIsDistinctFrom(Row lhs, Row rhs, Comparator comparator) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.comparator = comparator;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.delegate(ctx.configuration()));
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    private final QueryPartInternal delegate(Configuration configuration) {
        if (EMULATE_DISTINCT_PREDICATE.contains((Object)configuration.family())) {
            return this.comparator == Comparator.IS_DISTINCT_FROM ? (QueryPartInternal)((Object)DSL.notExists(DSL.select(this.lhs.fields()).intersect(DSL.select(this.rhs.fields())))) : (QueryPartInternal)((Object)DSL.exists(DSL.select(this.lhs.fields()).intersect(DSL.select(this.rhs.fields()))));
        }
        if (SUPPORT_DISTINCT_WITH_ARROW.contains((Object)configuration.family())) {
            if (this.mySQLCondition == null) {
                this.mySQLCondition = (QueryPartInternal)((Object)(this.comparator == Comparator.IS_DISTINCT_FROM ? DSL.condition("{not}({0} <=> {1})", this.lhs, this.rhs) : DSL.condition("{0} <=> {1}", this.lhs, this.rhs)));
            }
            return this.mySQLCondition;
        }
        if (SQLDialect.SQLITE == configuration.family()) {
            if (this.sqliteCondition == null) {
                this.sqliteCondition = (QueryPartInternal)((Object)(this.comparator == Comparator.IS_DISTINCT_FROM ? DSL.condition("{0} {is not} {1}", this.lhs, this.rhs) : DSL.condition("{0} {is} {1}", this.lhs, this.rhs)));
            }
            return this.sqliteCondition;
        }
        if (this.compareCondition == null) {
            this.compareCondition = new RowCondition(this.lhs, this.rhs, this.comparator);
        }
        return this.compareCondition;
    }
}

