/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.Collection;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.RecordType;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.Tools;
import org.jooq.tools.JooqLogger;

final class Fields<R extends Record>
extends AbstractQueryPart
implements RecordType<R> {
    private static final long serialVersionUID = -6911012275707591576L;
    private static final JooqLogger log = JooqLogger.getLogger(Fields.class);
    Field<?>[] fields;
    private static final FieldOrIndex<Field<?>> RETURN_FIELD = new FieldOrIndex<Field<?>>(){

        @Override
        public Field<?> result(Field<?> field, int index) {
            return field;
        }

        @Override
        public Field<?> resultNull() {
            return null;
        }
    };
    private static final FieldOrIndex<Integer> RETURN_INDEX = new FieldOrIndex<Integer>(){

        @Override
        public Integer result(Field<?> field, int index) {
            return index;
        }

        @Override
        public Integer resultNull() {
            return -1;
        }
    };

    Fields(Field<?> ... fields) {
        this.fields = fields;
    }

    Fields(Collection<? extends Field<?>> fields) {
        this.fields = fields.toArray(Tools.EMPTY_FIELD);
    }

    @Override
    public final int size() {
        return this.fields.length;
    }

    @Override
    public final <T> Field<T> field(Field<T> field) {
        return this.field0(field, RETURN_FIELD);
    }

    private final <U> U field0(Field<?> field, FieldOrIndex<U> result) {
        Field<?> f;
        int i;
        if (field == null) {
            return result.resultNull();
        }
        for (i = 0; i < this.fields.length; ++i) {
            f = this.fields[i];
            if (f != field) continue;
            return result.result(f, i);
        }
        for (i = 0; i < this.fields.length; ++i) {
            f = this.fields[i];
            if (!f.equals(field)) continue;
            return result.result(f, i);
        }
        Field<?> columnMatch = null;
        Field<?> columnMatch2 = null;
        int indexMatch = -1;
        String tableName = this.tableName(field);
        String fieldName = field.getName();
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            String tName;
            Field<?> f2 = this.fields[i2];
            String fName = f2.getName();
            if (tableName != null && (tName = this.tableName(f2)) != null && tableName.equals(tName) && fName.equals(fieldName)) {
                return result.result(f2, i2);
            }
            if (!fName.equals(fieldName)) continue;
            if (columnMatch == null) {
                columnMatch = f2;
                indexMatch = i2;
                continue;
            }
            columnMatch2 = f2;
        }
        if (columnMatch2 != null && log.isInfoEnabled()) {
            log.info((Object)("Ambiguous match found for " + fieldName + ". Both " + columnMatch + " and " + columnMatch2 + " match."), new SQLWarning());
        }
        return result.result(columnMatch, indexMatch);
    }

    private final String tableName(Field<?> field) {
        Table table;
        if (field instanceof TableField && (table = ((TableField)field).getTable()) != null) {
            return table.getName();
        }
        return null;
    }

    @Override
    public final Field<?> field(String fieldName) {
        return this.field0(fieldName, RETURN_FIELD);
    }

    private final <U> U field0(String fieldName, FieldOrIndex<U> result) {
        if (fieldName == null) {
            return result.resultNull();
        }
        Field<?> columnMatch = null;
        int indexMatch = -1;
        for (int i = 0; i < this.fields.length; ++i) {
            Field<?> f = this.fields[i];
            if (!f.getName().equals(fieldName)) continue;
            if (columnMatch == null) {
                columnMatch = f;
                indexMatch = i;
                continue;
            }
            log.info((Object)("Ambiguous match found for " + fieldName + ". Both " + columnMatch + " and " + f + " match."), new SQLWarning());
        }
        return result.result(columnMatch, indexMatch);
    }

    @Override
    public final <T> Field<T> field(String fieldName, Class<T> type) {
        Field<?> result = this.field(fieldName);
        return result == null ? null : result.coerce(type);
    }

    @Override
    public final <T> Field<T> field(String fieldName, DataType<T> dataType) {
        Field<?> result = this.field(fieldName);
        return result == null ? null : result.coerce(dataType);
    }

    @Override
    public final Field<?> field(Name name) {
        return this.field0(name, RETURN_FIELD);
    }

    private final <U> U field0(Name name, FieldOrIndex<U> result) {
        if (name == null) {
            return result.resultNull();
        }
        return this.field0(DSL.field(name), result);
    }

    @Override
    public final <T> Field<T> field(Name fieldName, Class<T> type) {
        Field<?> result = this.field(fieldName);
        return result == null ? null : result.coerce(type);
    }

    @Override
    public final <T> Field<T> field(Name fieldName, DataType<T> dataType) {
        Field<?> result = this.field(fieldName);
        return result == null ? null : result.coerce(dataType);
    }

    @Override
    public final Field<?> field(int index) {
        if (index >= 0 && index < this.fields.length) {
            return this.fields[index];
        }
        return null;
    }

    @Override
    public final <T> Field<T> field(int fieldIndex, Class<T> type) {
        Field<?> result = this.field(fieldIndex);
        return result == null ? null : result.coerce(type);
    }

    @Override
    public final <T> Field<T> field(int fieldIndex, DataType<T> dataType) {
        Field<?> result = this.field(fieldIndex);
        return result == null ? null : result.coerce(dataType);
    }

    @Override
    public final Field<?>[] fields() {
        return this.fields;
    }

    @Override
    public final Field<?>[] fields(Field<?> ... f) {
        Field[] result = new Field[f.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.field(f[i]);
        }
        return result;
    }

    @Override
    public final Field<?>[] fields(String ... f) {
        Field[] result = new Field[f.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.field(f[i]);
        }
        return result;
    }

    @Override
    public final Field<?>[] fields(Name ... f) {
        Field[] result = new Field[f.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.field(f[i]);
        }
        return result;
    }

    @Override
    public final Field<?>[] fields(int ... f) {
        Field[] result = new Field[f.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.field(f[i]);
        }
        return result;
    }

    @Override
    public final int indexOf(Field<?> field) {
        return this.field0(field, RETURN_INDEX);
    }

    @Override
    public final int indexOf(String fieldName) {
        return this.field0(fieldName, RETURN_INDEX);
    }

    @Override
    public final int indexOf(Name fieldName) {
        return this.field0(fieldName, RETURN_INDEX);
    }

    @Override
    public final Class<?>[] types() {
        int size = this.fields.length;
        Class[] result = new Class[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.field(i).getType();
        }
        return result;
    }

    @Override
    public final Class<?> type(int fieldIndex) {
        return fieldIndex >= 0 && fieldIndex < this.size() ? this.field(fieldIndex).getType() : null;
    }

    @Override
    public final Class<?> type(String fieldName) {
        return this.type(Tools.indexOrFail(this, fieldName));
    }

    @Override
    public final Class<?> type(Name fieldName) {
        return this.type(Tools.indexOrFail(this, fieldName));
    }

    @Override
    public final DataType<?>[] dataTypes() {
        int size = this.fields.length;
        DataType[] result = new DataType[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.field(i).getDataType();
        }
        return result;
    }

    @Override
    public final DataType<?> dataType(int fieldIndex) {
        return fieldIndex >= 0 && fieldIndex < this.size() ? this.field(fieldIndex).getDataType() : null;
    }

    @Override
    public final DataType<?> dataType(String fieldName) {
        return this.dataType(Tools.indexOrFail(this, fieldName));
    }

    @Override
    public final DataType<?> dataType(Name fieldName) {
        return this.dataType(Tools.indexOrFail(this, fieldName));
    }

    final int[] indexesOf(Field<?> ... f) {
        int[] result = new int[f.length];
        for (int i = 0; i < f.length; ++i) {
            result[i] = Tools.indexOrFail(this, f[i]);
        }
        return result;
    }

    final int[] indexesOf(String ... fieldNames) {
        int[] result = new int[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            result[i] = Tools.indexOrFail(this, fieldNames[i]);
        }
        return result;
    }

    final int[] indexesOf(Name ... fieldNames) {
        int[] result = new int[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            result[i] = Tools.indexOrFail(this, fieldNames[i]);
        }
        return result;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(new QueryPartList((QueryPart[])this.fields));
    }

    final void add(Field<?> f) {
        Field[] result = new Field[this.fields.length + 1];
        System.arraycopy(this.fields, 0, result, 0, this.fields.length);
        result[this.fields.length] = f;
        this.fields = result;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof Fields) {
            return Arrays.equals(this.fields, ((Fields)that).fields);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.fields);
    }

    private static interface FieldOrIndex<U> {
        public U result(Field<?> var1, int var2);

        public U resultNull();
    }
}

