/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BooleanSupplier;
import nl.basjes.parse.useragent.Analyzer;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.utils.StringTable;

public class TestCase
implements Serializable {
    private final Map<String, String> headers;
    private final String testName;
    private final List<String> options;
    private final Map<String, String> metadata;
    private final Map<String, String> expected;

    private TestCase() {
        this.headers = Collections.emptyMap();
        this.testName = "<<Should never appear after deserialization>>";
        this.options = Collections.emptyList();
        this.metadata = Collections.emptyMap();
        this.expected = Collections.emptyMap();
    }

    public TestCase(Map<String, String> headers, String testName) {
        this.headers = headers;
        this.testName = testName;
        this.options = new ArrayList<String>();
        this.metadata = new LinkedHashMap<String, String>();
        this.expected = new LinkedHashMap<String, String>();
    }

    public TestCase(String userAgent, String testName) {
        this.headers = new TreeMap<String, String>();
        this.headers.put("User-Agent", userAgent);
        this.testName = testName;
        this.options = new ArrayList<String>();
        this.metadata = new LinkedHashMap<String, String>();
        this.expected = new LinkedHashMap<String, String>();
    }

    public String getUserAgent() {
        return this.headers.get("User-Agent");
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public String getTestName() {
        return this.testName;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void addOption(String option) {
        this.options.add(option);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void addMetadata(String key, String value) {
        this.metadata.put(key, value);
    }

    public Map<String, String> getExpected() {
        return this.expected;
    }

    public void expect(String key, String value) {
        this.expected.put(key, value);
    }

    public TestResult verify(Analyzer analyzer) {
        return this.verify(analyzer, true);
    }

    public TestResult verify(Analyzer analyzer, boolean failOnUnexpected) {
        long startTime = System.nanoTime();
        UserAgent.ImmutableUserAgent result = analyzer.parse(this.getHeaders());
        long endTime = System.nanoTime();
        TestResult testResult = new TestResult();
        testResult.testCase = this;
        testResult.parseDurationNS = endTime - startTime;
        TreeSet<String> combinedKeys = new TreeSet<String>();
        combinedKeys.addAll(this.expected.keySet());
        combinedKeys.addAll(result.toMap().keySet());
        combinedKeys.remove("Useragent");
        combinedKeys.remove("__SyntaxError__");
        boolean passed = true;
        StringBuilder sb = new StringBuilder("\n");
        sb.append(">>>>>>>>>>>>>> ").append(this.testName).append(" <<<<<<<<<<<<<<\n");
        StringTable inputTable = new StringTable().withHeaders("Header", "Value");
        this.getHeaders().forEach((xva$0, xva$1) -> inputTable.addRow((String)xva$0, (String)xva$1));
        sb.append(inputTable).append('\n');
        StringTable resultTable = new StringTable().withHeaders("Field", "Expected", "Actual");
        for (String key : combinedKeys) {
            String expectedValue = this.expected.get(key);
            String actualValue = result.getValue(key);
            if (expectedValue == null && result.get(key).isDefaultValue()) continue;
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(key);
            fields.add(expectedValue);
            fields.add(actualValue);
            if (expectedValue == null) {
                if (!result.get(key).isDefaultValue()) {
                    if (failOnUnexpected) {
                        passed = false;
                    }
                    fields.add(" --> UNEXPECTED");
                }
            } else if (!expectedValue.equals(actualValue)) {
                passed = false;
                fields.add(" --> !!! FAIL !!!");
            }
            resultTable.addRow(fields);
        }
        sb.append(resultTable);
        testResult.pass = passed;
        testResult.errorReport = sb.toString();
        return testResult;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("====================================================================================\n");
        sb.append("TestCase: >>>>>>>>>>>>>> ").append(this.testName).append(" <<<<<<<<<<<<<<\n");
        if (this.options != null && !this.options.isEmpty()) {
            StringTable optionsTable = new StringTable().withHeaders("Option");
            this.options.forEach(xva$0 -> optionsTable.addRow((String)xva$0));
            sb.append(optionsTable).append('\n');
        }
        if (this.metadata != null && !this.metadata.isEmpty()) {
            StringTable metadataTable = new StringTable().withHeaders("Metadata", "Value");
            this.metadata.forEach((xva$0, xva$1) -> metadataTable.addRow((String)xva$0, (String)xva$1));
            sb.append(metadataTable).append('\n');
        }
        StringTable inputTable = new StringTable().withHeaders("Header", "Value");
        this.getHeaders().forEach((xva$0, xva$1) -> inputTable.addRow((String)xva$0, (String)xva$1));
        sb.append(inputTable).append('\n');
        StringTable expectedTable = new StringTable().withHeaders("Field", "Expected Value");
        this.expected.forEach((xva$0, xva$1) -> expectedTable.addRow((String)xva$0, (String)xva$1));
        sb.append(expectedTable).append('\n');
        sb.append("====================================================================================\n");
        return sb.toString();
    }

    public static class TestResult
    implements BooleanSupplier {
        private TestCase testCase;
        private boolean pass;
        private long parseDurationNS;
        private String errorReport;

        public TestCase getTestCase() {
            return this.testCase;
        }

        public boolean testPassed() {
            return this.pass;
        }

        public boolean testFailed() {
            return !this.pass;
        }

        public long getParseDurationNS() {
            return this.parseDurationNS;
        }

        public String getErrorReport() {
            return this.errorReport;
        }

        public String toString() {
            return this.testCase + this.errorReport;
        }

        @Override
        public boolean getAsBoolean() {
            return this.pass;
        }
    }
}

