/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.clienthints.parsers;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import nl.basjes.parse.useragent.AbstractUserAgentAnalyzerDirect;
import nl.basjes.parse.useragent.clienthints.ClientHints;
import nl.basjes.parse.useragent.clienthints.parsers.BrandListParser;
import nl.basjes.parse.useragent.clienthints.parsers.CHParser;

public class ParseSecChUaFullVersionList
implements CHParser {
    public static final String HEADER_FIELD = "Sec-CH-UA-Full-Version-List";
    public static final String HEADER_SPEC_URL = "https://wicg.github.io/ua-client-hints/#sec-ch-ua-full-version-list";
    public static final String HEADER_SPEC = "The Sec-CH-UA-Full-Version-List request header field gives a server information about the full version for each brand in its brands list.";
    public static final String FIELD_NAME = "secChUaFullVersionList";

    @Override
    @Nonnull
    public ClientHints parse(@Nonnull Map<String, String> clientHintsHeaders, @Nonnull ClientHints clientHints, @Nonnull String headerName) {
        String input = clientHintsHeaders.get(headerName);
        if (input == null) {
            return clientHints;
        }
        ArrayList<ClientHints.Brand> brands = BrandListParser.parse(input);
        if (!brands.isEmpty()) {
            clientHints.setFullVersionList(brands);
        }
        return clientHints;
    }

    @Override
    @Nonnull
    public String inputField() {
        return HEADER_FIELD;
    }

    public static AbstractUserAgentAnalyzerDirect.HeaderSpecification getHeaderSpecification() {
        return new AbstractUserAgentAnalyzerDirect.HeaderSpecification(HEADER_FIELD, HEADER_SPEC_URL, HEADER_SPEC, FIELD_NAME);
    }
}

