/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker.steps;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nl.basjes.parse.useragent.analyze.treewalker.steps.WalkList;
import nl.basjes.parse.useragent.parser.UserAgentParser;
import nl.basjes.parse.useragent.utils.AntlrUtils;
import nl.basjes.shaded.org.antlr.v4.runtime.ParserRuleContext;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Step
implements Serializable {
    protected static final Logger LOG = LogManager.getLogger(Step.class);
    private int stepNr;
    protected String logprefix = "";
    private Step nextStep;
    protected boolean verbose = false;

    public void setVerbose(boolean newVerbose) {
        this.verbose = newVerbose;
    }

    public void destroy() {
        this.nextStep = null;
    }

    public final void setNextStep(int newStepNr, Step newNextStep) {
        this.stepNr = newStepNr;
        this.nextStep = newNextStep;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < newStepNr + 1; ++i) {
            sb.append("-->");
        }
        this.logprefix = sb.toString();
    }

    protected final WalkList.WalkResult walkNextStep(@Nonnull ParseTree tree, @Nullable String value) {
        if (this.nextStep == null) {
            String result = value;
            if (value == null) {
                result = AntlrUtils.getSourceText((ParserRuleContext)tree);
            }
            if (this.verbose) {
                LOG.info("{} Final (implicit) step: {}", (Object)this.logprefix, (Object)result);
            }
            return new WalkList.WalkResult(tree, result);
        }
        if (this.verbose) {
            LOG.info("{} Tree: >>>{}<<<", (Object)this.logprefix, (Object)AntlrUtils.getSourceText((ParserRuleContext)tree));
            LOG.info("{} Enter step({}): {}", (Object)this.logprefix, (Object)this.stepNr, (Object)this.nextStep);
        }
        WalkList.WalkResult result = this.nextStep.walk(tree, value);
        if (this.verbose) {
            LOG.info("{} Result: >>>{}<<<", (Object)this.logprefix, (Object)result);
            LOG.info("{} Leave step({}): {}", (Object)this.logprefix, (Object)(result == null ? "-" : "+"), (Object)this.nextStep);
        }
        return result;
    }

    protected final ParseTree up(@Nonnull ParseTree tree) {
        ParseTree parent = tree.getParent();
        if (parent instanceof UserAgentParser.ProductNameContext || parent instanceof UserAgentParser.ProductVersionContext || parent instanceof UserAgentParser.ProductVersionWithCommasContext) {
            return this.up(parent);
        }
        return parent;
    }

    public static boolean treeIsSeparator(ParseTree tree) {
        return tree instanceof UserAgentParser.CommentSeparatorContext || tree instanceof TerminalNode;
    }

    protected String getActualValue(@Nonnull ParseTree tree, @Nullable String value) {
        if (value == null) {
            return AntlrUtils.getSourceText((ParserRuleContext)tree);
        }
        return value;
    }

    public abstract WalkList.WalkResult walk(@Nonnull ParseTree var1, @Nullable String var2);

    public boolean canFail() {
        return true;
    }

    public boolean mustHaveInput() {
        return true;
    }

    public Step getNextStep() {
        return this.nextStep;
    }
}

