/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.openTSDB.schema;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.AbstractSchemaFactory;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.openTSDB.DrillOpenTSDBTable;
import org.apache.drill.exec.store.openTSDB.OpenTSDBScanSpec;
import org.apache.drill.exec.store.openTSDB.OpenTSDBStoragePlugin;
import org.apache.drill.exec.store.openTSDB.client.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTSDBSchemaFactory
extends AbstractSchemaFactory {
    private static final Logger logger = LoggerFactory.getLogger(OpenTSDBSchemaFactory.class);
    private final OpenTSDBStoragePlugin plugin;

    public OpenTSDBSchemaFactory(OpenTSDBStoragePlugin plugin, String schemaName) {
        super(schemaName);
        this.plugin = plugin;
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) throws IOException {
        OpenTSDBSchema schema = new OpenTSDBSchema(this.getName());
        parent.add(this.getName(), (org.apache.calcite.schema.Schema)schema);
    }

    class OpenTSDBSchema
    extends AbstractSchema {
        OpenTSDBSchema(String name) {
            super(Collections.emptyList(), name);
        }

        public Table getTable(String name) {
            OpenTSDBScanSpec scanSpec = new OpenTSDBScanSpec(name);
            try {
                return new DrillOpenTSDBTable(this.getName(), OpenTSDBSchemaFactory.this.plugin, new Schema(OpenTSDBSchemaFactory.this.plugin.getClient(), name), scanSpec);
            }
            catch (Exception e) {
                logger.warn("Failure while loading table '{}' for database '{}'.", new Object[]{name, this.getName(), e.getCause()});
                return null;
            }
        }

        public Set<String> getTableNames() {
            return OpenTSDBSchemaFactory.this.plugin.getClient().getAllMetricNames();
        }

        public String getTypeName() {
            return "openTSDB";
        }
    }
}

