/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.openTSDB.client.query;

import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.exceptions.UserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query {
    private static final Logger log = LoggerFactory.getLogger(Query.class);
    private String aggregator;
    private String metric;
    private String rate;
    private String downsample;
    private Map<String, String> tags;

    private Query(Builder builder) {
        this.aggregator = builder.aggregator;
        this.metric = builder.metric;
        this.rate = builder.rate;
        this.downsample = builder.downsample;
        this.tags = builder.tags;
    }

    public String getAggregator() {
        return this.aggregator;
    }

    public String getMetric() {
        return this.metric;
    }

    public String getRate() {
        return this.rate;
    }

    public String getDownsample() {
        return this.downsample;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query subQuery = (Query)o;
        if (this.aggregator != null ? !this.aggregator.equals(subQuery.aggregator) : subQuery.aggregator != null) {
            return false;
        }
        if (this.metric != null ? !this.metric.equals(subQuery.metric) : subQuery.metric != null) {
            return false;
        }
        if (this.rate != null ? !this.rate.equals(subQuery.rate) : subQuery.rate != null) {
            return false;
        }
        if (this.downsample != null ? !this.downsample.equals(subQuery.downsample) : subQuery.downsample != null) {
            return false;
        }
        return this.tags != null ? this.tags.equals(subQuery.tags) : subQuery.tags == null;
    }

    public int hashCode() {
        int result = this.aggregator != null ? this.aggregator.hashCode() : 0;
        result = 31 * result + (this.metric != null ? this.metric.hashCode() : 0);
        result = 31 * result + (this.rate != null ? this.rate.hashCode() : 0);
        result = 31 * result + (this.downsample != null ? this.downsample.hashCode() : 0);
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SubQuery{aggregator='" + this.aggregator + '\'' + ", metric='" + this.metric + '\'' + ", rate='" + this.rate + '\'' + ", downsample='" + this.downsample + '\'' + ", tags=" + this.tags + '}';
    }

    public static class Builder {
        private String aggregator;
        private String metric;
        private String rate;
        private String downsample;
        private Map<String, String> tags = new HashMap<String, String>();

        public Builder(String metric) {
            this.metric = metric;
        }

        public Builder setAggregator(String aggregator) {
            if (aggregator == null) {
                throw UserException.validationError().message("aggregator param must be specified", new Object[0]).build(log);
            }
            this.aggregator = aggregator;
            return this;
        }

        public Builder setMetric(String metric) {
            if (metric == null) {
                throw UserException.validationError().message("metric param must be specified", new Object[0]).build(log);
            }
            this.metric = metric;
            return this;
        }

        public Builder setRate(String rate) {
            this.rate = rate;
            return this;
        }

        public Builder setDownsample(String downsample) {
            this.downsample = downsample;
            return this;
        }

        public Builder setTags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public Query build() {
            return new Query(this);
        }
    }
}

