/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.openTSDB;

import com.google.common.collect.MapMaker;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.management.MBeanServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SizeEstimator {
    private static final Logger logger = LoggerFactory.getLogger(SizeEstimator.class);
    private static final int ARRAY_SIZE_FOR_SAMPLING = 400;
    private static final int ARRAY_SAMPLE_SIZE = 100;
    private static final int BYTE_SIZE = 1;
    private static final int BOOLEAN_SIZE = 1;
    private static final int CHAR_SIZE = 2;
    private static final int SHORT_SIZE = 2;
    private static final int INT_SIZE = 4;
    private static final int LONG_SIZE = 8;
    private static final int FLOAT_SIZE = 4;
    private static final int DOUBLE_SIZE = 8;
    private static final int MAX_FIELD_SIZE = 8;
    private static final List<Integer> fieldSizes = new ArrayList<Integer>();
    private static final int ALIGN_SIZE = 8;
    private static final Map<Class<?>, ClassInfo> classInfos = new MapMaker().weakKeys().makeMap();
    private static final boolean is64bit;
    private static int pointerSize;
    private static int objectSize;

    SizeEstimator() {
    }

    private static boolean getIsCompressedOops() {
        if (System.getProperty("spark.test.useCompressedOops") != null) {
            return Boolean.getBoolean("spark.test.useCompressedOops");
        }
        String javaVendor = System.getProperty("java.vendor");
        if (javaVendor.contains("IBM") || javaVendor.contains("OpenJ9")) {
            return System.getProperty("java.vm.info").contains("Compressed Ref");
        }
        try {
            String hotSpotMBeanName = "com.sun.management:type=HotSpotDiagnostic";
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            Class<?> hotSpotMBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            Method getVMMethod = hotSpotMBeanClass.getDeclaredMethod("getVMOption", Class.forName("java.lang.String"));
            Object bean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", hotSpotMBeanClass);
            return getVMMethod.invoke(bean, "UseCompressedOops").toString().contains("true");
        }
        catch (Exception e) {
            boolean guess = Runtime.getRuntime().maxMemory() < 0x800000000L;
            logger.warn("Failed to check whether UseCompressedOops is set; assuming {}", (Object)guess);
            return guess;
        }
    }

    public static long estimate(Object obj) {
        return SizeEstimator.estimate(obj, new IdentityHashMap<Object, Object>());
    }

    private static long estimate(Object obj, IdentityHashMap<Object, Object> visited) {
        SearchState state = new SearchState(visited);
        state.enqueue(obj);
        while (!state.isFinished()) {
            SizeEstimator.visitSingleObject(state.dequeue(), state);
        }
        return state.size;
    }

    private static void visitSingleObject(Object obj, SearchState state) {
        Class<?> cls = obj.getClass();
        if (cls.isArray()) {
            SizeEstimator.visitArray(obj, cls, state);
        } else if (!(cls.getName().startsWith("scala.reflect") || obj instanceof ClassLoader || obj instanceof Class)) {
            Long calculatedSize = SizeEstimator.knownSize(obj);
            if (calculatedSize != null) {
                state.size += calculatedSize.longValue();
            } else {
                ClassInfo classInfo = SizeEstimator.getClassInfo(cls);
                state.size += SizeEstimator.alignSize(classInfo.shellSize);
                for (Field field : classInfo.pointerFields) {
                    try {
                        state.enqueue(field.get(obj));
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static void visitArray(Object array, Class<?> arrayClass, SearchState state) {
        long length = SizeEstimator.arrayLength(array);
        Class<?> elementClass = arrayClass.getComponentType();
        long arrSize = SizeEstimator.alignSize(objectSize + 4);
        if (elementClass.isPrimitive()) {
            state.size += (arrSize += SizeEstimator.alignSize(length * (long)SizeEstimator.primitiveSize(elementClass)));
        } else {
            state.size += (arrSize += SizeEstimator.alignSize(length * (long)pointerSize));
            if (length <= 400L) {
                int arrayIndex = 0;
                while ((long)arrayIndex < length) {
                    state.enqueue(SizeEstimator.arrayApply(array, arrayIndex));
                    ++arrayIndex;
                }
            } else {
                Random rand = new Random(42L);
                HashSet<Integer> drawn = new HashSet<Integer>(200);
                long s1 = SizeEstimator.sampleArray(array, state, rand, drawn, (int)length);
                long s2 = SizeEstimator.sampleArray(array, state, rand, drawn, (int)length);
                long size = Math.min(s1, s2);
                state.size += Math.max(s1, s2) + size * ((length - 100L) / 100L);
            }
        }
    }

    private static long sampleArray(Object array, SearchState state, Random rand, HashSet<Integer> drawn, int length) {
        long size = 0L;
        for (int i = 0; i < 100; ++i) {
            int index;
            while (drawn.contains(index = rand.nextInt(length))) {
            }
            drawn.add(index);
            Object obj = SizeEstimator.arrayApply(array, index);
            if (obj == null) continue;
            size += SizeEstimator.estimate(obj, state.visited);
        }
        return size;
    }

    private static Object arrayApply(Object obj, int index) {
        if (obj instanceof Object[]) {
            return ((Object[])obj)[index];
        }
        if (obj instanceof byte[]) {
            return ((byte[])obj)[index];
        }
        if (obj instanceof int[]) {
            return ((int[])obj)[index];
        }
        if (obj instanceof short[]) {
            return ((short[])obj)[index];
        }
        if (obj instanceof long[]) {
            return ((long[])obj)[index];
        }
        if (obj instanceof boolean[]) {
            return ((boolean[])obj)[index];
        }
        if (obj instanceof float[]) {
            return Float.valueOf(((float[])obj)[index]);
        }
        if (obj instanceof double[]) {
            return ((double[])obj)[index];
        }
        if (obj instanceof char[]) {
            return Character.valueOf(((char[])obj)[index]);
        }
        throw new IllegalArgumentException("illegal input for arrayApply " + obj);
    }

    private static int arrayLength(Object obj) {
        if (obj instanceof Object[]) {
            return ((Object[])obj).length;
        }
        if (obj instanceof byte[]) {
            return ((byte[])obj).length;
        }
        if (obj instanceof int[]) {
            return ((int[])obj).length;
        }
        if (obj instanceof short[]) {
            return ((short[])obj).length;
        }
        if (obj instanceof long[]) {
            return ((long[])obj).length;
        }
        if (obj instanceof boolean[]) {
            return ((boolean[])obj).length;
        }
        if (obj instanceof float[]) {
            return ((float[])obj).length;
        }
        if (obj instanceof double[]) {
            return ((double[])obj).length;
        }
        if (obj instanceof char[]) {
            return ((char[])obj).length;
        }
        throw new IllegalArgumentException("illegal input for arrayLength " + obj);
    }

    private static int primitiveSize(Class<?> cls) {
        if (cls == Byte.TYPE) {
            return 1;
        }
        if (cls == Boolean.TYPE) {
            return 1;
        }
        if (cls == Character.TYPE) {
            return 2;
        }
        if (cls == Short.TYPE) {
            return 2;
        }
        if (cls == Integer.TYPE) {
            return 4;
        }
        if (cls == Long.TYPE) {
            return 8;
        }
        if (cls == Float.TYPE) {
            return 4;
        }
        if (cls == Double.TYPE) {
            return 8;
        }
        throw new IllegalArgumentException("Non-primitive class " + cls + " passed to primitiveSize()");
    }

    private static ClassInfo getClassInfo(Class<?> cls) {
        ClassInfo info = classInfos.get(cls);
        if (info != null) {
            return info;
        }
        ClassInfo parent = SizeEstimator.getClassInfo(cls.getSuperclass());
        long shellSize = parent.getShellSize();
        LinkedList<Field> pointerFields = parent.getPointerFields();
        int[] sizeCount = new int[9];
        for (Field field : cls.getDeclaredFields()) {
            block7: {
                if (Modifier.isStatic(field.getModifiers())) continue;
                Class<?> fieldClass = field.getType();
                if (fieldClass.isPrimitive()) {
                    int n = SizeEstimator.primitiveSize(fieldClass);
                    sizeCount[n] = sizeCount[n] + 1;
                    continue;
                }
                try {
                    field.setAccessible(true);
                    pointerFields.add(0, field);
                }
                catch (SecurityException securityException) {
                }
                catch (RuntimeException re) {
                    if (re.getClass().getSimpleName().equals("InaccessibleObjectException")) break block7;
                    throw re;
                }
            }
            int n = pointerSize;
            sizeCount[n] = sizeCount[n] + 1;
        }
        long alignedSize = shellSize;
        for (Integer size : fieldSizes) {
            if (sizeCount[size] <= 0) continue;
            long count = sizeCount[size];
            alignedSize = Math.max(alignedSize, SizeEstimator.alignSizeUp(shellSize, size) + (long)size.intValue() * count);
            shellSize += (long)size.intValue() * count;
        }
        shellSize = SizeEstimator.alignSizeUp(alignedSize, pointerSize);
        ClassInfo newInfo = new ClassInfo(shellSize, pointerFields);
        classInfos.put(cls, newInfo);
        return newInfo;
    }

    private static long alignSize(long size) {
        return SizeEstimator.alignSizeUp(size, 8);
    }

    private static long alignSizeUp(long size, int alignSize) {
        return size + (long)alignSize - 1L & (long)(~(alignSize - 1));
    }

    private static Long knownSize(Object obj) {
        try {
            Method method = obj.getClass().getMethod("estimatedSize", new Class[0]);
            return (Long)method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        pointerSize = 4;
        objectSize = 8;
        fieldSizes.add(8);
        fieldSizes.add(4);
        fieldSizes.add(2);
        fieldSizes.add(1);
        String arch = System.getProperty("os.arch");
        is64bit = arch.contains("64") || arch.contains("s390x");
        boolean isCompressedOops = SizeEstimator.getIsCompressedOops();
        objectSize = !is64bit ? 8 : (!isCompressedOops ? 16 : 12);
        pointerSize = is64bit && !isCompressedOops ? 8 : 4;
        classInfos.clear();
        classInfos.put(Object.class, new ClassInfo(objectSize, new LinkedList<Field>()));
    }

    private static class ClassInfo {
        private final long shellSize;
        private final LinkedList<Field> pointerFields;

        ClassInfo(long shellSize, LinkedList<Field> pointerFields) {
            this.shellSize = shellSize;
            this.pointerFields = pointerFields;
        }

        long getShellSize() {
            return this.shellSize;
        }

        LinkedList<Field> getPointerFields() {
            return this.pointerFields;
        }
    }

    private static class SearchState {
        private final IdentityHashMap<Object, Object> visited;
        private final LinkedList<Object> stack = new LinkedList();
        long size = 0L;

        SearchState(IdentityHashMap<Object, Object> visited) {
            this.visited = visited;
        }

        void enqueue(Object obj) {
            if (obj != null && !this.visited.containsKey(obj)) {
                this.visited.put(obj, null);
                this.stack.add(obj);
            }
        }

        boolean isFinished() {
            return this.stack.isEmpty();
        }

        Object dequeue() {
            return this.stack.removeLast();
        }
    }
}

