/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.tools;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.metadata.RelColumnMapping;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.ListTransientTable;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.TableFunctionReturnTypeInference;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Optionality;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;

public class RelBuilder {
    protected final RelOptCluster cluster;
    protected final RelOptSchema relOptSchema;
    private final RelFactories.FilterFactory filterFactory;
    private final RelFactories.ProjectFactory projectFactory;
    private final RelFactories.AggregateFactory aggregateFactory;
    private final RelFactories.SortFactory sortFactory;
    private final RelFactories.ExchangeFactory exchangeFactory;
    private final RelFactories.SortExchangeFactory sortExchangeFactory;
    private final RelFactories.SetOpFactory setOpFactory;
    private final RelFactories.JoinFactory joinFactory;
    private final RelFactories.CorrelateFactory correlateFactory;
    private final RelFactories.ValuesFactory valuesFactory;
    private final RelFactories.TableScanFactory scanFactory;
    private final RelFactories.TableFunctionScanFactory tableFunctionScanFactory;
    private final RelFactories.SnapshotFactory snapshotFactory;
    private final RelFactories.MatchFactory matchFactory;
    private final RelFactories.SpoolFactory spoolFactory;
    private final RelFactories.RepeatUnionFactory repeatUnionFactory;
    private final Deque<Frame> stack = new ArrayDeque<Frame>();
    private final RexSimplify simplifier;
    private final Config config;

    protected RelBuilder(Context context, RelOptCluster cluster, RelOptSchema relOptSchema) {
        this.cluster = cluster;
        this.relOptSchema = relOptSchema;
        if (context == null) {
            context = Contexts.EMPTY_CONTEXT;
        }
        this.config = this.getConfig(context);
        this.aggregateFactory = Util.first(context.unwrap(RelFactories.AggregateFactory.class), RelFactories.DEFAULT_AGGREGATE_FACTORY);
        this.filterFactory = Util.first(context.unwrap(RelFactories.FilterFactory.class), RelFactories.DEFAULT_FILTER_FACTORY);
        this.projectFactory = Util.first(context.unwrap(RelFactories.ProjectFactory.class), RelFactories.DEFAULT_PROJECT_FACTORY);
        this.sortFactory = Util.first(context.unwrap(RelFactories.SortFactory.class), RelFactories.DEFAULT_SORT_FACTORY);
        this.exchangeFactory = Util.first(context.unwrap(RelFactories.ExchangeFactory.class), RelFactories.DEFAULT_EXCHANGE_FACTORY);
        this.sortExchangeFactory = Util.first(context.unwrap(RelFactories.SortExchangeFactory.class), RelFactories.DEFAULT_SORT_EXCHANGE_FACTORY);
        this.setOpFactory = Util.first(context.unwrap(RelFactories.SetOpFactory.class), RelFactories.DEFAULT_SET_OP_FACTORY);
        this.joinFactory = Util.first(context.unwrap(RelFactories.JoinFactory.class), RelFactories.DEFAULT_JOIN_FACTORY);
        this.correlateFactory = Util.first(context.unwrap(RelFactories.CorrelateFactory.class), RelFactories.DEFAULT_CORRELATE_FACTORY);
        this.valuesFactory = Util.first(context.unwrap(RelFactories.ValuesFactory.class), RelFactories.DEFAULT_VALUES_FACTORY);
        this.scanFactory = Util.first(context.unwrap(RelFactories.TableScanFactory.class), RelFactories.DEFAULT_TABLE_SCAN_FACTORY);
        this.tableFunctionScanFactory = Util.first(context.unwrap(RelFactories.TableFunctionScanFactory.class), RelFactories.DEFAULT_TABLE_FUNCTION_SCAN_FACTORY);
        this.snapshotFactory = Util.first(context.unwrap(RelFactories.SnapshotFactory.class), RelFactories.DEFAULT_SNAPSHOT_FACTORY);
        this.matchFactory = Util.first(context.unwrap(RelFactories.MatchFactory.class), RelFactories.DEFAULT_MATCH_FACTORY);
        this.spoolFactory = Util.first(context.unwrap(RelFactories.SpoolFactory.class), RelFactories.DEFAULT_SPOOL_FACTORY);
        this.repeatUnionFactory = Util.first(context.unwrap(RelFactories.RepeatUnionFactory.class), RelFactories.DEFAULT_REPEAT_UNION_FACTORY);
        RexExecutor executor = Util.first(context.unwrap(RexExecutor.class), Util.first(cluster.getPlanner().getExecutor(), RexUtil.EXECUTOR));
        RelOptPredicateList predicates = RelOptPredicateList.EMPTY;
        this.simplifier = new RexSimplify(cluster.getRexBuilder(), predicates, executor);
    }

    private Config getConfig(Context context) {
        Config config = Util.first(context.unwrap(Config.class), Config.DEFAULT);
        boolean simplify = Hook.REL_BUILDER_SIMPLIFY.get(config.simplify);
        if (simplify == config.simplify) {
            return config;
        }
        return config.toBuilder().withSimplify(simplify).build();
    }

    public static RelBuilder create(FrameworkConfig config) {
        return Frameworks.withPrepare(config, (cluster, relOptSchema, rootSchema, statement) -> new RelBuilder(config.getContext(), cluster, relOptSchema));
    }

    public String toString() {
        return this.stack.stream().map(frame -> RelOptUtil.toString(frame.rel)).collect(Collectors.joining(""));
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.cluster.getTypeFactory();
    }

    public RexBuilder getRexBuilder() {
        return this.cluster.getRexBuilder();
    }

    public static RelBuilderFactory proto(Context context) {
        return (cluster, schema) -> new RelBuilder(context, cluster, schema);
    }

    public static RelBuilderFactory proto(Object ... factories) {
        return RelBuilder.proto(Contexts.of(factories));
    }

    public RelOptCluster getCluster() {
        return this.cluster;
    }

    public RelOptSchema getRelOptSchema() {
        return this.relOptSchema;
    }

    public RelFactories.TableScanFactory getScanFactory() {
        return this.scanFactory;
    }

    public RelBuilder push(RelNode node) {
        this.stack.push(new Frame(node));
        return this;
    }

    private void replaceTop(RelNode node) {
        Frame frame = this.stack.pop();
        this.stack.push(new Frame(node, frame.fields));
    }

    public RelBuilder pushAll(Iterable<? extends RelNode> nodes) {
        for (RelNode relNode : nodes) {
            this.push(relNode);
        }
        return this;
    }

    public RelNode build() {
        return this.stack.pop().rel;
    }

    public RelNode peek() {
        return this.peek_().rel;
    }

    private Frame peek_() {
        return this.stack.peek();
    }

    public RelNode peek(int n) {
        return this.peek_((int)n).rel;
    }

    private Frame peek_(int n) {
        return (Frame)Iterables.get(this.stack, (int)n);
    }

    public RelNode peek(int inputCount, int inputOrdinal) {
        return this.peek_((int)inputCount, (int)inputOrdinal).rel;
    }

    private Frame peek_(int inputCount, int inputOrdinal) {
        return this.peek_(inputCount - 1 - inputOrdinal);
    }

    private int inputOffset(int inputCount, int inputOrdinal) {
        int offset = 0;
        for (int i = 0; i < inputOrdinal; ++i) {
            offset += this.peek(inputCount, i).getRowType().getFieldCount();
        }
        return offset;
    }

    public RexNode literal(Object value) {
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        if (value == null) {
            RelDataType type = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
            return rexBuilder.makeNullLiteral(type);
        }
        if (value instanceof Boolean) {
            return rexBuilder.makeLiteral((Boolean)value);
        }
        if (value instanceof BigDecimal) {
            return rexBuilder.makeExactLiteral((BigDecimal)value);
        }
        if (value instanceof Float || value instanceof Double) {
            return rexBuilder.makeApproxLiteral(BigDecimal.valueOf(((Number)value).doubleValue()));
        }
        if (value instanceof Number) {
            return rexBuilder.makeExactLiteral(BigDecimal.valueOf(((Number)value).longValue()));
        }
        if (value instanceof String) {
            return rexBuilder.makeLiteral((String)value);
        }
        if (value instanceof Enum) {
            return rexBuilder.makeLiteral(value, this.getTypeFactory().createSqlType(SqlTypeName.SYMBOL), false);
        }
        throw new IllegalArgumentException("cannot convert " + value + " (" + value.getClass() + ") to a constant");
    }

    public RelBuilder variable(Holder<RexCorrelVariable> v) {
        v.set((RexCorrelVariable)this.getRexBuilder().makeCorrel(this.peek().getRowType(), this.cluster.createCorrel()));
        return this;
    }

    public RexInputRef field(String fieldName) {
        return this.field(1, 0, fieldName);
    }

    public RexInputRef field(int inputCount, int inputOrdinal, String fieldName) {
        Frame frame = this.peek_(inputCount, inputOrdinal);
        List fieldNames = Pair.left(frame.fields());
        int i = fieldNames.indexOf(fieldName);
        if (i >= 0) {
            return this.field(inputCount, inputOrdinal, i);
        }
        throw new IllegalArgumentException("field [" + fieldName + "] not found; input fields are: " + fieldNames);
    }

    public RexInputRef field(int fieldOrdinal) {
        return (RexInputRef)this.field(1, 0, fieldOrdinal, false);
    }

    public RexInputRef field(int inputCount, int inputOrdinal, int fieldOrdinal) {
        return (RexInputRef)this.field(inputCount, inputOrdinal, fieldOrdinal, false);
    }

    private RexNode field(int inputCount, int inputOrdinal, int fieldOrdinal, boolean alias) {
        Frame frame = this.peek_(inputCount, inputOrdinal);
        RelNode input = frame.rel;
        RelDataType rowType = input.getRowType();
        if (fieldOrdinal < 0 || fieldOrdinal > rowType.getFieldCount()) {
            throw new IllegalArgumentException("field ordinal [" + fieldOrdinal + "] out of range; input fields are: " + rowType.getFieldNames());
        }
        RelDataTypeField field = rowType.getFieldList().get(fieldOrdinal);
        int offset = this.inputOffset(inputCount, inputOrdinal);
        RexInputRef ref = this.cluster.getRexBuilder().makeInputRef(field.getType(), offset + fieldOrdinal);
        RelDataTypeField aliasField = frame.fields().get(fieldOrdinal);
        if (!alias || field.getName().equals(aliasField.getName())) {
            return ref;
        }
        return this.alias(ref, aliasField.getName());
    }

    public RexNode field(String alias, String fieldName) {
        return this.field(1, alias, fieldName);
    }

    public RexNode field(int inputCount, String alias, String fieldName) {
        Objects.requireNonNull(alias);
        Objects.requireNonNull(fieldName);
        ArrayList<String> fields = new ArrayList<String>();
        for (int inputOrdinal = 0; inputOrdinal < inputCount; ++inputOrdinal) {
            Frame frame = this.peek_(inputOrdinal);
            for (Ord p : Ord.zip(frame.fields)) {
                if (((ImmutableSet)((Field)p.e).left).contains((Object)alias) && ((RelDataTypeField)((Field)p.e).right).getName().equals(fieldName)) {
                    return this.field(inputCount, inputCount - 1 - inputOrdinal, p.i);
                }
                fields.add(String.format(Locale.ROOT, "{aliases=%s,fieldName=%s}", ((Field)p.e).left, ((RelDataTypeField)((Field)p.e).right).getName()));
            }
        }
        throw new IllegalArgumentException("no aliased field found; fields are: " + fields);
    }

    public RexNode field(RexNode e, String name) {
        return this.getRexBuilder().makeFieldAccess(e, name, false);
    }

    public ImmutableList<RexNode> fields() {
        return this.fields(1, 0);
    }

    public ImmutableList<RexNode> fields(int inputCount, int inputOrdinal) {
        RelNode input = this.peek(inputCount, inputOrdinal);
        RelDataType rowType = input.getRowType();
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (int fieldOrdinal : Util.range(rowType.getFieldCount())) {
            nodes.add((Object)this.field(inputCount, inputOrdinal, fieldOrdinal));
        }
        return nodes.build();
    }

    public ImmutableList<RexNode> fields(RelCollation collation) {
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
            RexNode node = this.field(fieldCollation.getFieldIndex());
            switch (fieldCollation.direction) {
                case DESCENDING: {
                    node = this.desc(node);
                }
            }
            switch (fieldCollation.nullDirection) {
                case FIRST: {
                    node = this.nullsFirst(node);
                    break;
                }
                case LAST: {
                    node = this.nullsLast(node);
                }
            }
            nodes.add((Object)node);
        }
        return nodes.build();
    }

    public ImmutableList<RexNode> fields(List<? extends Number> ordinals) {
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (Number number : ordinals) {
            RexNode node = this.field(1, 0, number.intValue(), false);
            nodes.add((Object)node);
        }
        return nodes.build();
    }

    public ImmutableList<RexNode> fields(ImmutableBitSet ordinals) {
        return this.fields(ordinals.asList());
    }

    public ImmutableList<RexNode> fields(Iterable<String> fieldNames) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String fieldName : fieldNames) {
            builder.add((Object)this.field(fieldName));
        }
        return builder.build();
    }

    public ImmutableList<RexNode> fields(Mappings.TargetMapping mapping) {
        return this.fields(Mappings.asList(mapping));
    }

    public RexNode dot(RexNode node, String fieldName) {
        RexBuilder builder = this.cluster.getRexBuilder();
        return builder.makeFieldAccess(node, fieldName, true);
    }

    public RexNode dot(RexNode node, int fieldOrdinal) {
        RexBuilder builder = this.cluster.getRexBuilder();
        return builder.makeFieldAccess(node, fieldOrdinal);
    }

    @Nonnull
    public RexNode call(SqlOperator operator, RexNode ... operands) {
        return this.call(operator, (List<RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    @Nonnull
    private RexNode call(SqlOperator operator, List<RexNode> operandList) {
        RexBuilder builder = this.cluster.getRexBuilder();
        RelDataType type = builder.deriveReturnType(operator, operandList);
        return builder.makeCall(type, operator, operandList);
    }

    @Nonnull
    public RexNode call(SqlOperator operator, Iterable<? extends RexNode> operands) {
        return this.call(operator, (List<RexNode>)ImmutableList.copyOf(operands));
    }

    public RexNode and(RexNode ... operands) {
        return this.and((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    public RexNode and(Iterable<? extends RexNode> operands) {
        return RexUtil.composeConjunction(this.getRexBuilder(), operands);
    }

    public RexNode or(RexNode ... operands) {
        return this.or((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    public RexNode or(Iterable<? extends RexNode> operands) {
        return RexUtil.composeDisjunction(this.cluster.getRexBuilder(), operands);
    }

    public RexNode not(RexNode operand) {
        return this.call((SqlOperator)SqlStdOperatorTable.NOT, operand);
    }

    public RexNode equals(RexNode operand0, RexNode operand1) {
        return this.call((SqlOperator)SqlStdOperatorTable.EQUALS, operand0, operand1);
    }

    public RexNode notEquals(RexNode operand0, RexNode operand1) {
        return this.call((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, operand0, operand1);
    }

    public RexNode isNull(RexNode operand) {
        return this.call((SqlOperator)SqlStdOperatorTable.IS_NULL, operand);
    }

    public RexNode isNotNull(RexNode operand) {
        return this.call((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand);
    }

    public RexNode cast(RexNode expr, SqlTypeName typeName) {
        RelDataType type = this.cluster.getTypeFactory().createSqlType(typeName);
        return this.cluster.getRexBuilder().makeCast(type, expr);
    }

    public RexNode cast(RexNode expr, SqlTypeName typeName, int precision) {
        RelDataType type = this.cluster.getTypeFactory().createSqlType(typeName, precision);
        return this.cluster.getRexBuilder().makeCast(type, expr);
    }

    public RexNode cast(RexNode expr, SqlTypeName typeName, int precision, int scale) {
        RelDataType type = this.cluster.getTypeFactory().createSqlType(typeName, precision, scale);
        return this.cluster.getRexBuilder().makeCast(type, expr);
    }

    public RexNode alias(RexNode expr, String alias) {
        RexNode aliasLiteral = this.literal(alias);
        switch (expr.getKind()) {
            case AS: {
                RexCall call = (RexCall)expr;
                if (((RexNode)call.operands.get(1)).equals(aliasLiteral)) {
                    return expr;
                }
                expr = (RexNode)call.operands.get(0);
            }
        }
        return this.call((SqlOperator)SqlStdOperatorTable.AS, expr, aliasLiteral);
    }

    public RexNode desc(RexNode node) {
        return this.call((SqlOperator)SqlStdOperatorTable.DESC, node);
    }

    public RexNode nullsLast(RexNode node) {
        return this.call((SqlOperator)SqlStdOperatorTable.NULLS_LAST, node);
    }

    public RexNode nullsFirst(RexNode node) {
        return this.call((SqlOperator)SqlStdOperatorTable.NULLS_FIRST, node);
    }

    public GroupKey groupKey() {
        return this.groupKey((Iterable<? extends RexNode>)ImmutableList.of());
    }

    public GroupKey groupKey(RexNode ... nodes) {
        return this.groupKey((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public GroupKey groupKey(Iterable<? extends RexNode> nodes) {
        return new GroupKeyImpl((ImmutableList<RexNode>)ImmutableList.copyOf(nodes), null, null);
    }

    public GroupKey groupKey(Iterable<? extends RexNode> nodes, Iterable<? extends Iterable<? extends RexNode>> nodeLists) {
        return this.groupKey_(nodes, nodeLists);
    }

    @Deprecated
    public GroupKey groupKey(Iterable<? extends RexNode> nodes, boolean indicator, Iterable<? extends Iterable<? extends RexNode>> nodeLists) {
        Aggregate.checkIndicator(indicator);
        return this.groupKey_(nodes, nodeLists);
    }

    private GroupKey groupKey_(Iterable<? extends RexNode> nodes, Iterable<? extends Iterable<? extends RexNode>> nodeLists) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Iterable<? extends RexNode> iterable : nodeLists) {
            builder.add((Object)ImmutableList.copyOf(iterable));
        }
        return new GroupKeyImpl((ImmutableList<RexNode>)ImmutableList.copyOf(nodes), (ImmutableList<ImmutableList<RexNode>>)builder.build(), null);
    }

    public GroupKey groupKey(int ... fieldOrdinals) {
        return this.groupKey((Iterable<? extends RexNode>)this.fields(ImmutableIntList.of(fieldOrdinals)));
    }

    public GroupKey groupKey(String ... fieldNames) {
        return this.groupKey((Iterable<? extends RexNode>)this.fields((Iterable<String>)ImmutableList.copyOf((Object[])fieldNames)));
    }

    public GroupKey groupKey(@Nonnull ImmutableBitSet groupSet) {
        return this.groupKey(groupSet, (ImmutableList<ImmutableBitSet>)ImmutableList.of((Object)groupSet));
    }

    public GroupKey groupKey(ImmutableBitSet groupSet, @Nonnull Iterable<? extends ImmutableBitSet> groupSets) {
        return this.groupKey_(groupSet, (ImmutableList<ImmutableBitSet>)ImmutableList.copyOf(groupSets));
    }

    public GroupKey groupKey(ImmutableBitSet groupSet, ImmutableList<ImmutableBitSet> groupSets) {
        return this.groupKey_(groupSet, (ImmutableList<ImmutableBitSet>)(groupSets == null ? ImmutableList.of((Object)groupSet) : ImmutableList.copyOf(groupSets)));
    }

    @Deprecated
    public GroupKey groupKey(ImmutableBitSet groupSet, boolean indicator, ImmutableList<ImmutableBitSet> groupSets) {
        Aggregate.checkIndicator(indicator);
        return this.groupKey_(groupSet, (ImmutableList<ImmutableBitSet>)(groupSets == null ? ImmutableList.of((Object)groupSet) : ImmutableList.copyOf(groupSets)));
    }

    private GroupKey groupKey_(ImmutableBitSet groupSet, @Nonnull ImmutableList<ImmutableBitSet> groupSets) {
        if (groupSet.length() > this.peek().getRowType().getFieldCount()) {
            throw new IllegalArgumentException("out of bounds: " + groupSet);
        }
        Objects.requireNonNull(groupSets);
        ImmutableList<RexNode> nodes = this.fields(groupSet);
        return this.groupKey_((Iterable<? extends RexNode>)nodes, (Iterable<? extends Iterable<? extends RexNode>>)Util.transform(groupSets, bitSet -> this.fields((ImmutableBitSet)bitSet)));
    }

    @Deprecated
    public AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, RexNode filter, String alias, RexNode ... operands) {
        return this.aggregateCall(aggFunction, distinct, false, false, filter, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    @Deprecated
    public AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, boolean approximate, RexNode filter, String alias, RexNode ... operands) {
        return this.aggregateCall(aggFunction, distinct, approximate, false, filter, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    @Deprecated
    public AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, RexNode filter, String alias, Iterable<? extends RexNode> operands) {
        return this.aggregateCall(aggFunction, distinct, false, false, filter, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.copyOf(operands));
    }

    @Deprecated
    public AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, boolean approximate, RexNode filter, String alias, Iterable<? extends RexNode> operands) {
        return this.aggregateCall(aggFunction, distinct, approximate, false, filter, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.copyOf(operands));
    }

    public AggCall aggregateCall(SqlAggFunction aggFunction, Iterable<? extends RexNode> operands) {
        return this.aggregateCall(aggFunction, false, false, false, null, (ImmutableList<RexNode>)ImmutableList.of(), null, (ImmutableList<RexNode>)ImmutableList.copyOf(operands));
    }

    public AggCall aggregateCall(SqlAggFunction aggFunction, RexNode ... operands) {
        return this.aggregateCall(aggFunction, false, false, false, null, (ImmutableList<RexNode>)ImmutableList.of(), null, (ImmutableList<RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    protected AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, boolean approximate, boolean ignoreNulls, RexNode filter, ImmutableList<RexNode> orderKeys, String alias, ImmutableList<RexNode> operands) {
        return new AggCallImpl(aggFunction, distinct, approximate, ignoreNulls, filter, alias, operands, orderKeys);
    }

    public AggCall count(RexNode ... operands) {
        return this.count(false, null, operands);
    }

    public AggCall count(Iterable<? extends RexNode> operands) {
        return this.count(false, null, operands);
    }

    public AggCall count(boolean distinct, String alias, RexNode ... operands) {
        return this.aggregateCall(SqlStdOperatorTable.COUNT, distinct, false, false, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    public AggCall count(boolean distinct, String alias, Iterable<? extends RexNode> operands) {
        return this.aggregateCall(SqlStdOperatorTable.COUNT, distinct, false, false, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.copyOf(operands));
    }

    public AggCall countStar(String alias) {
        return this.count(false, alias, new RexNode[0]);
    }

    public AggCall sum(RexNode operand) {
        return this.sum(false, null, operand);
    }

    public AggCall sum(boolean distinct, String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.SUM, distinct, false, false, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.of((Object)operand));
    }

    public AggCall avg(RexNode operand) {
        return this.avg(false, null, operand);
    }

    public AggCall avg(boolean distinct, String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.AVG, distinct, false, false, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.of((Object)operand));
    }

    public AggCall min(RexNode operand) {
        return this.min(null, operand);
    }

    public AggCall min(String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.MIN, false, false, false, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.of((Object)operand));
    }

    public AggCall max(RexNode operand) {
        return this.max(null, operand);
    }

    public AggCall max(String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.MAX, false, false, false, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.of((Object)operand));
    }

    public RexNode patternField(String alpha, RelDataType type, int i) {
        return this.getRexBuilder().makePatternFieldRef(alpha, type, i);
    }

    public RexNode patternConcat(Iterable<? extends RexNode> nodes) {
        ImmutableList list = ImmutableList.copyOf(nodes);
        if (list.size() > 2) {
            return this.patternConcat(this.patternConcat(Util.skipLast(list)), (RexNode)Util.last(list));
        }
        RelDataType t = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
        return this.getRexBuilder().makeCall(t, SqlStdOperatorTable.PATTERN_CONCAT, (List<RexNode>)list);
    }

    public RexNode patternConcat(RexNode ... nodes) {
        return this.patternConcat((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public RexNode patternAlter(Iterable<? extends RexNode> nodes) {
        RelDataType t = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
        return this.getRexBuilder().makeCall(t, SqlStdOperatorTable.PATTERN_ALTER, (List<RexNode>)ImmutableList.copyOf(nodes));
    }

    public RexNode patternAlter(RexNode ... nodes) {
        return this.patternAlter((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public RexNode patternQuantify(Iterable<? extends RexNode> nodes) {
        RelDataType t = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
        return this.getRexBuilder().makeCall(t, SqlStdOperatorTable.PATTERN_QUANTIFIER, (List<RexNode>)ImmutableList.copyOf(nodes));
    }

    public RexNode patternQuantify(RexNode ... nodes) {
        return this.patternQuantify((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public RexNode patternPermute(Iterable<? extends RexNode> nodes) {
        RelDataType t = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
        return this.getRexBuilder().makeCall(t, SqlStdOperatorTable.PATTERN_PERMUTE, (List<RexNode>)ImmutableList.copyOf(nodes));
    }

    public RexNode patternPermute(RexNode ... nodes) {
        return this.patternPermute((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public RexNode patternExclude(RexNode node) {
        RelDataType t = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
        return this.getRexBuilder().makeCall(t, SqlStdOperatorTable.PATTERN_EXCLUDE, (List<RexNode>)ImmutableList.of((Object)node));
    }

    public RelBuilder scan(Iterable<String> tableNames) {
        ImmutableList names = ImmutableList.copyOf(tableNames);
        RelOptTable relOptTable = this.relOptSchema.getTableForMember((List<String>)names);
        if (relOptTable == null) {
            throw Static.RESOURCE.tableNotFound(String.join((CharSequence)".", (Iterable<? extends CharSequence>)names)).ex();
        }
        RelNode scan = this.scanFactory.createScan(this.cluster, relOptTable);
        this.push(scan);
        this.rename(relOptTable.getRowType().getFieldNames());
        if (!(scan instanceof TableScan)) {
            this.as((String)Util.last(ImmutableList.copyOf(tableNames)));
        }
        return this;
    }

    public RelBuilder scan(String ... tableNames) {
        return this.scan((Iterable<String>)ImmutableList.copyOf((Object[])tableNames));
    }

    public RelBuilder snapshot(RexNode period) {
        Frame frame = this.stack.pop();
        RelNode snapshot = this.snapshotFactory.createSnapshot(frame.rel, period);
        this.stack.push(new Frame(snapshot, frame.fields));
        return this;
    }

    private Set<RelColumnMapping> getColumnMappings(SqlOperator op) {
        SqlReturnTypeInference inference = op.getReturnTypeInference();
        if (inference instanceof TableFunctionReturnTypeInference) {
            return ((TableFunctionReturnTypeInference)inference).getColumnMappings();
        }
        return null;
    }

    public RexNode cursor(int inputCount, int ordinal) {
        if (inputCount <= ordinal || ordinal < 0) {
            throw new IllegalArgumentException("bad input count or ordinal");
        }
        RelNode input = this.peek(inputCount, ordinal);
        return this.call((SqlOperator)SqlStdOperatorTable.CURSOR, this.getRexBuilder().makeInputRef(input.getRowType(), ordinal));
    }

    public RelBuilder functionScan(SqlOperator operator, int inputCount, RexNode ... operands) {
        return this.functionScan(operator, inputCount, (Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    public RelBuilder functionScan(SqlOperator operator, int inputCount, Iterable<? extends RexNode> operands) {
        if (inputCount < 0 || inputCount > this.stack.size()) {
            throw new IllegalArgumentException("bad input count");
        }
        LinkedList<RelNode> inputs = new LinkedList<RelNode>();
        for (int i = 0; i < inputCount; ++i) {
            inputs.add(0, this.build());
        }
        RexNode call = this.call(operator, (List<RexNode>)ImmutableList.copyOf(operands));
        RelNode functionScan = this.tableFunctionScanFactory.createTableFunctionScan(this.cluster, inputs, call, null, this.getColumnMappings(operator));
        this.push(functionScan);
        return this;
    }

    public RelBuilder filter(RexNode ... predicates) {
        return this.filter((Iterable<CorrelationId>)ImmutableSet.of(), (Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])predicates));
    }

    public RelBuilder filter(Iterable<? extends RexNode> predicates) {
        return this.filter((Iterable<CorrelationId>)ImmutableSet.of(), predicates);
    }

    public RelBuilder filter(Iterable<CorrelationId> variablesSet, RexNode ... predicates) {
        return this.filter(variablesSet, (Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])predicates));
    }

    public RelBuilder filter(Iterable<CorrelationId> variablesSet, Iterable<? extends RexNode> predicates) {
        RexNode simplifiedPredicates = this.simplifier.simplifyFilterPredicates(predicates);
        if (simplifiedPredicates == null) {
            return this.empty();
        }
        if (!simplifiedPredicates.isAlwaysTrue()) {
            Frame frame = this.stack.pop();
            RelNode filter = this.filterFactory.createFilter(frame.rel, simplifiedPredicates, (Set<CorrelationId>)ImmutableSet.copyOf(variablesSet));
            this.stack.push(new Frame(filter, frame.fields));
        }
        return this;
    }

    public RelBuilder project(RexNode ... nodes) {
        return this.project((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public RelBuilder project(Iterable<? extends RexNode> nodes) {
        return this.project(nodes, (Iterable<String>)ImmutableList.of());
    }

    public RelBuilder project(Iterable<? extends RexNode> nodes, Iterable<String> fieldNames) {
        return this.project(nodes, fieldNames, false);
    }

    public RelBuilder projectPlus(RexNode ... nodes) {
        return this.projectPlus((Iterable<RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public RelBuilder projectPlus(Iterable<RexNode> nodes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        return this.project((Iterable<? extends RexNode>)builder.addAll(this.fields()).addAll(nodes).build());
    }

    public RelBuilder project(Iterable<? extends RexNode> nodes, Iterable<String> fieldNames, boolean force) {
        int i;
        Frame frame = this.stack.peek();
        RelDataType inputRowType = frame.rel.getRowType();
        ArrayList nodeList = Lists.newArrayList(nodes);
        if (!force && Iterables.isEmpty(fieldNames) && RexUtil.isIdentity(nodeList, inputRowType)) {
            return this;
        }
        ArrayList fieldNameList = Lists.newArrayList(fieldNames);
        while (fieldNameList.size() < nodeList.size()) {
            fieldNameList.add(null);
        }
        if (frame.rel instanceof Project && this.shouldMergeProject()) {
            Project project = (Project)frame.rel;
            for (int i2 = 0; i2 < fieldNameList.size(); ++i2) {
                RexNode node;
                if (fieldNameList.get(i2) != null || !((node = (RexNode)nodeList.get(i2)) instanceof RexInputRef)) continue;
                RexInputRef ref = (RexInputRef)node;
                fieldNameList.set(i2, project.getRowType().getFieldNames().get(ref.getIndex()));
            }
            List<RexNode> newNodes = RelOptUtil.pushPastProject(nodeList, project);
            Frame frame1 = this.stack.pop();
            ArrayList<Field> fields = new ArrayList<Field>();
            for (RelDataTypeField relDataTypeField : project.getInput().getRowType().getFieldList()) {
                fields.add(new Field((ImmutableSet<String>)ImmutableSet.of(), relDataTypeField));
            }
            for (Pair pair : Pair.zip(project.getProjects(), frame1.fields)) {
                switch (((RexNode)pair.left).getKind()) {
                    case INPUT_REF: {
                        int i3 = ((RexInputRef)pair.left).getIndex();
                        Field field = (Field)fields.get(i3);
                        ImmutableSet aliases = (ImmutableSet)((Field)pair.right).left;
                        fields.set(i3, new Field((ImmutableSet<String>)aliases, (RelDataTypeField)field.right));
                    }
                }
            }
            this.stack.push(new Frame(project.getInput(), ImmutableList.copyOf(fields)));
            return this.project(newNodes, fieldNameList, force);
        }
        if (this.config.simplify) {
            for (i = 0; i < nodeList.size(); ++i) {
                nodeList.set(i, this.simplifier.simplifyPreservingType((RexNode)nodeList.get(i)));
            }
        }
        for (i = 0; i < fieldNameList.size(); ++i) {
            if (fieldNameList.get(i) != null) continue;
            fieldNameList.set(i, this.inferAlias(nodeList, (RexNode)nodeList.get(i), i));
        }
        ImmutableList.Builder fields = ImmutableList.builder();
        AbstractSet uniqueNameList = this.getTypeFactory().getTypeSystem().isSchemaCaseSensitive() ? new HashSet() : new TreeSet(String.CASE_INSENSITIVE_ORDER);
        for (int i4 = 0; i4 < fieldNameList.size(); ++i4) {
            Field field;
            String name;
            RexNode node = (RexNode)nodeList.get(i4);
            String string = name = (String)fieldNameList.get(i4);
            if (name == null || uniqueNameList.contains(name)) {
                int j = 0;
                if (name == null) {
                    j = i4;
                }
                while (uniqueNameList.contains(name = SqlValidatorUtil.F_SUGGESTER.apply(string, j, j++))) {
                }
                fieldNameList.set(i4, name);
            }
            RelDataTypeFieldImpl fieldType = new RelDataTypeFieldImpl(name, i4, node.getType());
            switch (node.getKind()) {
                case INPUT_REF: {
                    int index = ((RexInputRef)node).getIndex();
                    field = new Field((ImmutableSet<String>)((ImmutableSet)((Field)frame.fields.get((int)index)).left), fieldType);
                    break;
                }
                default: {
                    field = new Field((ImmutableSet<String>)ImmutableSet.of(), fieldType);
                }
            }
            uniqueNameList.add(name);
            fields.add((Object)field);
        }
        if (!force && RexUtil.isIdentity(nodeList, inputRowType)) {
            if (fieldNameList.equals(inputRowType.getFieldNames())) {
                return this;
            }
            this.stack.pop();
            this.stack.push(new Frame(frame.rel, fields.build()));
            return this;
        }
        RelNode project = this.projectFactory.createProject(frame.rel, (List<? extends RexNode>)ImmutableList.copyOf((Collection)nodeList), fieldNameList);
        this.stack.pop();
        this.stack.push(new Frame(project, fields.build()));
        return this;
    }

    protected boolean shouldMergeProject() {
        return true;
    }

    public RelBuilder projectNamed(Iterable<? extends RexNode> nodes, Iterable<String> fieldNames, boolean force) {
        List nodeList;
        List list = nodeList = nodes instanceof List ? (List)nodes : ImmutableList.copyOf(nodes);
        List<String> fieldNameList = fieldNames == null ? null : (fieldNames instanceof List ? (List<String>)fieldNames : ImmutableNullableList.copyOf(fieldNames));
        RelNode input = this.peek();
        RelDataType rowType = RexUtil.createStructType(this.cluster.getTypeFactory(), nodeList, fieldNameList, SqlValidatorUtil.F_SUGGESTER);
        if (!force && RexUtil.isIdentity(nodeList, input.getRowType())) {
            if (input instanceof Project && fieldNames != null) {
                Frame frame = this.stack.pop();
                Project childProject = (Project)frame.rel;
                Project newInput = childProject.copy(childProject.getTraitSet(), childProject.getInput(), childProject.getProjects(), rowType);
                this.stack.push(new Frame(newInput, frame.fields));
            }
        } else {
            this.project(nodeList, rowType.getFieldNames(), force);
        }
        return this;
    }

    public RelBuilder rename(List<String> fieldNames) {
        List<String> oldFieldNames = this.peek().getRowType().getFieldNames();
        Preconditions.checkArgument((fieldNames.size() <= oldFieldNames.size() ? 1 : 0) != 0, (Object)"More names than fields");
        ArrayList<String> newFieldNames = new ArrayList<String>(oldFieldNames);
        for (int i = 0; i < fieldNames.size(); ++i) {
            String s = fieldNames.get(i);
            if (s == null) continue;
            newFieldNames.set(i, s);
        }
        if (oldFieldNames.equals(newFieldNames)) {
            return this;
        }
        if (this.peek() instanceof Values) {
            Values v = (Values)this.build();
            RelDataTypeFactory.FieldInfoBuilder b = this.getTypeFactory().builder();
            for (Pair<String, RelDataTypeField> p : Pair.zip(newFieldNames, v.getRowType().getFieldList())) {
                ((RelDataTypeFactory.Builder)b).add((String)p.left, ((RelDataTypeField)p.right).getType());
            }
            return this.values((Iterable<? extends List<RexLiteral>>)v.tuples, b.build());
        }
        return this.project((Iterable<? extends RexNode>)this.fields(), (Iterable<String>)newFieldNames, true);
    }

    private String inferAlias(List<RexNode> exprList, RexNode expr, int i) {
        switch (expr.getKind()) {
            case INPUT_REF: {
                RexInputRef ref = (RexInputRef)expr;
                return ((RelDataTypeField)((Field)this.stack.peek().fields.get(ref.getIndex())).getValue()).getName();
            }
            case CAST: {
                return this.inferAlias(exprList, ((RexCall)expr).getOperands().get(0), -1);
            }
            case AS: {
                RexCall call = (RexCall)expr;
                if (i >= 0) {
                    exprList.set(i, call.getOperands().get(0));
                }
                return ((NlsString)((RexLiteral)call.getOperands().get(1)).getValue()).getValue();
            }
        }
        return null;
    }

    public RelBuilder distinct() {
        return this.aggregate(this.groupKey((Iterable<? extends RexNode>)this.fields()), new AggCall[0]);
    }

    public RelBuilder aggregate(GroupKey groupKey, AggCall ... aggCalls) {
        return this.aggregate(groupKey, (Iterable<AggCall>)ImmutableList.copyOf((Object[])aggCalls));
    }

    public RelBuilder aggregate(GroupKey groupKey, Iterable<AggCall> aggCalls) {
        ImmutableList groupSets;
        Registrar registrar = new Registrar((Iterable<RexNode>)this.fields(), this.peek().getRowType().getFieldNames());
        GroupKeyImpl groupKey_ = (GroupKeyImpl)groupKey;
        ImmutableBitSet groupSet = ImmutableBitSet.of(registrar.registerExpressions((Iterable<? extends RexNode>)groupKey_.nodes));
        if (Iterables.isEmpty(aggCalls)) {
            Double minRowCount;
            Object mq = this.peek().getCluster().getMetadataQuery();
            if (!groupSet.isEmpty() || (minRowCount = ((RelMetadataQuery)mq).getMinRowCount(this.peek())) != null && !(minRowCount < 1.0)) {
                Boolean unique;
                if (registrar.extraNodes.size() == this.fields().size() && (unique = ((RelMetadataQuery)mq).areColumnsUnique(this.peek(), groupSet)) != null && unique.booleanValue()) {
                    return this.project((Iterable<? extends RexNode>)this.fields(groupSet));
                }
                Double maxRowCount = ((RelMetadataQuery)mq).getMaxRowCount(this.peek());
                if (maxRowCount != null && maxRowCount <= 1.0) {
                    return this.project((Iterable<? extends RexNode>)this.fields(groupSet));
                }
            }
        }
        if (groupKey_.nodeLists != null) {
            int sizeBefore = registrar.extraNodes.size();
            TreeSet<ImmutableBitSet> groupSetSet = new TreeSet<ImmutableBitSet>((Comparator<ImmutableBitSet>)ImmutableBitSet.ORDERING);
            for (Object nodeList : groupKey_.nodeLists) {
                ImmutableBitSet groupSet2 = ImmutableBitSet.of(registrar.registerExpressions((Iterable<? extends RexNode>)nodeList));
                if (!groupSet.contains(groupSet2)) {
                    throw new IllegalArgumentException("group set element " + nodeList + " must be a subset of group key");
                }
                groupSetSet.add(groupSet2);
            }
            groupSets = ImmutableList.copyOf(groupSetSet);
            if (registrar.extraNodes.size() > sizeBefore) {
                throw new IllegalArgumentException("group sets contained expressions not in group key: " + registrar.extraNodes.subList(sizeBefore, registrar.extraNodes.size()));
            }
        } else {
            groupSets = ImmutableList.of((Object)groupSet);
        }
        for (AggCall aggCall : aggCalls) {
            if (!(aggCall instanceof AggCallImpl)) continue;
            AggCallImpl aggCall1 = (AggCallImpl)aggCall;
            registrar.registerExpressions((Iterable<? extends RexNode>)aggCall1.operands);
            if (aggCall1.filter == null) continue;
            registrar.registerExpression(aggCall1.filter);
        }
        this.project(registrar.extraNodes);
        this.rename(registrar.names);
        Frame frame = this.stack.pop();
        RelNode r = frame.rel;
        ArrayList<AggregateCall> aggregateCalls = new ArrayList<AggregateCall>();
        for (AggCall aggCall : aggCalls) {
            AggregateCall aggregateCall;
            if (aggCall instanceof AggCallImpl) {
                int filterArg;
                AggCallImpl aggCall1 = (AggCallImpl)aggCall;
                List<Integer> args = registrar.registerExpressions((Iterable<? extends RexNode>)aggCall1.operands);
                int n = filterArg = aggCall1.filter == null ? -1 : registrar.registerExpression(aggCall1.filter);
                if (aggCall1.distinct && !aggCall1.aggFunction.isQuantifierAllowed()) {
                    throw new IllegalArgumentException("DISTINCT not allowed");
                }
                if (aggCall1.filter != null && !aggCall1.aggFunction.allowsFilter()) {
                    throw new IllegalArgumentException("FILTER not allowed");
                }
                RelCollation collation = RelCollations.of(aggCall1.orderKeys.stream().map(orderKey -> RelBuilder.collation(orderKey, RelFieldCollation.Direction.ASCENDING, null, Collections.emptyList())).collect(Collectors.toList()));
                aggregateCall = AggregateCall.create(aggCall1.aggFunction, aggCall1.distinct, aggCall1.approximate, aggCall1.ignoreNulls, args, filterArg, collation, groupSet.cardinality(), r, null, aggCall1.alias);
            } else {
                aggregateCall = ((AggCallImpl2)aggCall).aggregateCall;
            }
            aggregateCalls.add(aggregateCall);
        }
        assert (ImmutableBitSet.ORDERING.isStrictlyOrdered((Iterable)groupSets)) : groupSets;
        for (ImmutableBitSet set : groupSets) {
            assert (groupSet.contains(set));
        }
        if (!this.config.dedupAggregateCalls || Util.isDistinct(aggregateCalls)) {
            return this.aggregate_(groupSet, (ImmutableList<ImmutableBitSet>)groupSets, r, aggregateCalls, registrar.extraNodes, frame.fields);
        }
        HashSet<AggregateCall> callSet = new HashSet<AggregateCall>();
        ArrayList<Pair<Integer, String>> projects = new ArrayList<Pair<Integer, String>>();
        Util.range(groupSet.cardinality()).forEach(i -> projects.add(Pair.of(i, null)));
        ArrayList<AggregateCall> distinctAggregateCalls = new ArrayList<AggregateCall>();
        for (AggregateCall aggregateCall : aggregateCalls) {
            int i2;
            if (callSet.add(aggregateCall)) {
                i2 = distinctAggregateCalls.size();
                distinctAggregateCalls.add(aggregateCall);
            } else {
                i2 = distinctAggregateCalls.indexOf(aggregateCall);
                assert (i2 >= 0);
            }
            projects.add(Pair.of(groupSet.cardinality() + i2, aggregateCall.name));
        }
        this.aggregate_(groupSet, (ImmutableList<ImmutableBitSet>)groupSets, r, distinctAggregateCalls, registrar.extraNodes, frame.fields);
        List fields = projects.stream().map(p -> p.right == null ? this.field((Integer)p.left) : this.alias(this.field((Integer)p.left), (String)p.right)).collect(Collectors.toList());
        return this.project(fields);
    }

    private RelBuilder aggregate_(ImmutableBitSet groupSet, ImmutableList<ImmutableBitSet> groupSets, RelNode input, List<AggregateCall> aggregateCalls, List<RexNode> extraNodes, ImmutableList<Field> inFields) {
        RelNode aggregate = this.aggregateFactory.createAggregate(input, groupSet, groupSets, aggregateCalls);
        ImmutableList.Builder fields = ImmutableList.builder();
        List<RelDataTypeField> aggregateFields = aggregate.getRowType().getFieldList();
        int i = 0;
        for (Integer groupField : groupSet.asList()) {
            RexNode node = extraNodes.get(groupField);
            SqlKind kind = node.getKind();
            switch (kind) {
                case INPUT_REF: {
                    fields.add(inFields.get(((RexInputRef)node).getIndex()));
                    break;
                }
                default: {
                    String name = aggregateFields.get(i).getName();
                    RelDataTypeFieldImpl fieldType = new RelDataTypeFieldImpl(name, i, node.getType());
                    fields.add((Object)new Field((ImmutableSet<String>)ImmutableSet.of(), fieldType));
                }
            }
            ++i;
        }
        for (int j = 0; j < aggregateCalls.size(); ++j) {
            AggregateCall call = aggregateCalls.get(j);
            RelDataTypeFieldImpl fieldType = new RelDataTypeFieldImpl(aggregateFields.get(i + j).getName(), i + j, call.getType());
            fields.add((Object)new Field((ImmutableSet<String>)ImmutableSet.of(), fieldType));
        }
        this.stack.push(new Frame(aggregate, fields.build()));
        return this;
    }

    private RelBuilder setOp(boolean all, SqlKind kind, int n) {
        LinkedList<RelNode> inputs = new LinkedList<RelNode>();
        for (int i = 0; i < n; ++i) {
            inputs.add(0, this.build());
        }
        switch (kind) {
            case UNION: 
            case INTERSECT: 
            case EXCEPT: {
                if (n >= 1) break;
                throw new IllegalArgumentException("bad INTERSECT/UNION/EXCEPT input count");
            }
            default: {
                throw new AssertionError((Object)("bad setOp " + (Object)((Object)kind)));
            }
        }
        switch (n) {
            case 1: {
                return this.push((RelNode)inputs.get(0));
            }
        }
        return this.push(this.setOpFactory.createSetOp(kind, inputs, all));
    }

    public RelBuilder union(boolean all) {
        return this.union(all, 2);
    }

    public RelBuilder union(boolean all, int n) {
        return this.setOp(all, SqlKind.UNION, n);
    }

    public RelBuilder intersect(boolean all) {
        return this.intersect(all, 2);
    }

    public RelBuilder intersect(boolean all, int n) {
        return this.setOp(all, SqlKind.INTERSECT, n);
    }

    public RelBuilder minus(boolean all) {
        return this.minus(all, 2);
    }

    public RelBuilder minus(boolean all, int n) {
        return this.setOp(all, SqlKind.EXCEPT, n);
    }

    public RelBuilder transientScan(String tableName) {
        return this.transientScan(tableName, this.peek().getRowType());
    }

    public RelBuilder transientScan(String tableName, RelDataType rowType) {
        ListTransientTable transientTable = new ListTransientTable(tableName, rowType);
        RelOptTableImpl relOptTable = RelOptTableImpl.create(this.relOptSchema, rowType, (Table)transientTable, (ImmutableList<String>)ImmutableList.of((Object)tableName));
        RelNode scan = this.scanFactory.createScan(this.cluster, relOptTable);
        this.push(scan);
        this.rename(rowType.getFieldNames());
        return this;
    }

    private RelBuilder tableSpool(Spool.Type readType, Spool.Type writeType, RelOptTable table) {
        RelNode spool = this.spoolFactory.createTableSpool(this.peek(), readType, writeType, table);
        this.replaceTop(spool);
        return this;
    }

    public RelBuilder repeatUnion(String tableName, boolean all) {
        return this.repeatUnion(tableName, all, -1);
    }

    public RelBuilder repeatUnion(String tableName, boolean all, int iterationLimit) {
        RelOptTableFinder finder = new RelOptTableFinder(tableName);
        for (int i = 0; i < this.stack.size(); ++i) {
            this.peek(i).accept(finder);
            if (finder.relOptTable != null) break;
        }
        if (finder.relOptTable == null) {
            throw Static.RESOURCE.tableNotFound(tableName).ex();
        }
        RelNode iterative = this.tableSpool(Spool.Type.LAZY, Spool.Type.LAZY, finder.relOptTable).build();
        RelNode seed = this.tableSpool(Spool.Type.LAZY, Spool.Type.LAZY, finder.relOptTable).build();
        RelNode repUnion = this.repeatUnionFactory.createRepeatUnion(seed, iterative, all, iterationLimit);
        return this.push(repUnion);
    }

    public RelBuilder join(JoinRelType joinType, RexNode condition0, RexNode ... conditions) {
        return this.join(joinType, Lists.asList((Object)condition0, (Object[])conditions));
    }

    public RelBuilder join(JoinRelType joinType, Iterable<? extends RexNode> conditions) {
        return this.join(joinType, this.and(conditions), (Set<CorrelationId>)ImmutableSet.of());
    }

    public RelBuilder join(JoinRelType joinType, RexNode condition) {
        return this.join(joinType, condition, (Set<CorrelationId>)ImmutableSet.of());
    }

    public RelBuilder join(JoinRelType joinType, RexNode condition, Set<CorrelationId> variablesSet) {
        RelNode join;
        Frame right = this.stack.pop();
        Frame left = this.stack.pop();
        boolean correlate = variablesSet.size() == 1;
        RexNode postCondition = this.literal(true);
        if (this.config.simplify) {
            if (condition instanceof RexCall) {
                condition = RelOptUtil.collapseExpandedIsNotDistinctFromExpr((RexCall)condition, this.getRexBuilder());
            }
            condition = this.simplifier.simplifyUnknownAsFalse(condition);
        }
        if (correlate) {
            CorrelationId id = (CorrelationId)Iterables.getOnlyElement(variablesSet);
            ImmutableBitSet requiredColumns = RelOptUtil.correlationColumns(id, right.rel);
            if (!RelOptUtil.notContainsCorrelation(left.rel, id, Litmus.IGNORE)) {
                throw new IllegalArgumentException("variable " + id + " must not be used by left input to correlation");
            }
            switch (joinType) {
                case LEFT: {
                    this.stack.push(right);
                    this.filter(condition.accept(new Shifter(left.rel, id, right.rel)));
                    right = this.stack.pop();
                    break;
                }
                default: {
                    postCondition = condition;
                }
            }
            join = this.correlateFactory.createCorrelate(left.rel, right.rel, id, requiredColumns, joinType);
        } else {
            join = this.joinFactory.createJoin(left.rel, right.rel, condition, variablesSet, joinType, false);
        }
        ImmutableList.Builder fields = ImmutableList.builder();
        fields.addAll(left.fields);
        fields.addAll(right.fields);
        this.stack.push(new Frame(join, fields.build()));
        this.filter(postCondition);
        return this;
    }

    public RelBuilder correlate(JoinRelType joinType, CorrelationId correlationId, RexNode ... requiredFields) {
        return this.correlate(joinType, correlationId, (Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])requiredFields));
    }

    public RelBuilder correlate(JoinRelType joinType, CorrelationId correlationId, Iterable<? extends RexNode> requiredFields) {
        Frame right = this.stack.pop();
        Registrar registrar = new Registrar((Iterable<RexNode>)this.fields(), this.peek().getRowType().getFieldNames());
        List<Integer> requiredOrdinals = registrar.registerExpressions((Iterable<? extends RexNode>)ImmutableList.copyOf(requiredFields));
        this.project(registrar.extraNodes);
        this.rename(registrar.names);
        Frame left = this.stack.pop();
        RelNode correlate = this.correlateFactory.createCorrelate(left.rel, right.rel, correlationId, ImmutableBitSet.of(requiredOrdinals), joinType);
        ImmutableList.Builder fields = ImmutableList.builder();
        fields.addAll(left.fields);
        fields.addAll(right.fields);
        this.stack.push(new Frame(correlate, fields.build()));
        return this;
    }

    public RelBuilder join(JoinRelType joinType, String ... fieldNames) {
        ArrayList<RexNode> conditions = new ArrayList<RexNode>();
        for (String fieldName : fieldNames) {
            conditions.add(this.call((SqlOperator)SqlStdOperatorTable.EQUALS, this.field(2, 0, fieldName), this.field(2, 1, fieldName)));
        }
        return this.join(joinType, conditions);
    }

    public RelBuilder semiJoin(Iterable<? extends RexNode> conditions) {
        Frame right = this.stack.pop();
        RelNode semiJoin = this.joinFactory.createJoin(this.peek(), right.rel, this.and(conditions), (Set<CorrelationId>)ImmutableSet.of(), JoinRelType.SEMI, false);
        this.replaceTop(semiJoin);
        return this;
    }

    public RelBuilder semiJoin(RexNode ... conditions) {
        return this.semiJoin((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])conditions));
    }

    public RelBuilder antiJoin(Iterable<? extends RexNode> conditions) {
        Frame right = this.stack.pop();
        RelNode antiJoin = this.joinFactory.createJoin(this.peek(), right.rel, this.and(conditions), (Set<CorrelationId>)ImmutableSet.of(), JoinRelType.ANTI, false);
        this.replaceTop(antiJoin);
        return this;
    }

    public RelBuilder antiJoin(RexNode ... conditions) {
        return this.antiJoin((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])conditions));
    }

    public RelBuilder as(String alias) {
        Frame pair = this.stack.pop();
        List<Field> newFields = Util.transform(pair.fields, field -> field.addAlias(alias));
        this.stack.push(new Frame(pair.rel, ImmutableList.copyOf(newFields)));
        return this;
    }

    public RelBuilder values(String[] fieldNames, Object ... values) {
        if (fieldNames == null || fieldNames.length == 0 || values.length % fieldNames.length != 0 || values.length < fieldNames.length) {
            throw new IllegalArgumentException("Value count must be a positive multiple of field count");
        }
        final int rowCount = values.length / fieldNames.length;
        for (Ord fieldName : Ord.zip((Object[])fieldNames)) {
            if (!this.allNull(values, fieldName.i, fieldNames.length)) continue;
            throw new IllegalArgumentException("All values of field '" + (String)fieldName.e + "' are null; cannot deduce type");
        }
        final ImmutableList<ImmutableList<RexLiteral>> tupleList = this.tupleList(fieldNames.length, values);
        RelDataTypeFactory typeFactory = this.cluster.getTypeFactory();
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        for (final Ord fieldName : Ord.zip((Object[])fieldNames)) {
            String name = fieldName.e != null ? (String)fieldName.e : "expr$" + fieldName.i;
            RelDataType type = typeFactory.leastRestrictive((List<RelDataType>)new AbstractList<RelDataType>(){

                @Override
                public RelDataType get(int index) {
                    return ((RexLiteral)((ImmutableList)tupleList.get(index)).get(fieldName.i)).getType();
                }

                @Override
                public int size() {
                    return rowCount;
                }
            });
            ((RelDataTypeFactory.Builder)builder).add(name, type);
        }
        RelDataType rowType = builder.build();
        return this.values((Iterable<? extends List<RexLiteral>>)tupleList, rowType);
    }

    private ImmutableList<ImmutableList<RexLiteral>> tupleList(int columnCount, Object[] values) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ArrayList<RexLiteral> valueList = new ArrayList<RexLiteral>();
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            valueList.add((RexLiteral)this.literal(value));
            if ((i + 1) % columnCount != 0) continue;
            listBuilder.add((Object)ImmutableList.copyOf(valueList));
            valueList.clear();
        }
        return listBuilder.build();
    }

    private boolean allNull(Object[] values, int column, int columnCount) {
        for (int i = column; i < values.length; i += columnCount) {
            if (values[i] == null) continue;
            return false;
        }
        return true;
    }

    public RelBuilder empty() {
        Frame frame = this.stack.pop();
        RelNode values = this.valuesFactory.createValues(this.cluster, frame.rel.getRowType(), (List<ImmutableList<RexLiteral>>)ImmutableList.of());
        this.stack.push(new Frame(values, frame.fields));
        return this;
    }

    public RelBuilder values(RelDataType rowType, Object ... columnValues) {
        ImmutableList<ImmutableList<RexLiteral>> tupleList = this.tupleList(rowType.getFieldCount(), columnValues);
        RelNode values = this.valuesFactory.createValues(this.cluster, rowType, (List<ImmutableList<RexLiteral>>)ImmutableList.copyOf(tupleList));
        this.push(values);
        return this;
    }

    public RelBuilder values(Iterable<? extends List<RexLiteral>> tupleList, RelDataType rowType) {
        RelNode values = this.valuesFactory.createValues(this.cluster, rowType, (List<ImmutableList<RexLiteral>>)RelBuilder.copy(tupleList));
        this.push(values);
        return this;
    }

    public RelBuilder values(RelDataType rowType) {
        return this.values((Iterable<? extends List<RexLiteral>>)ImmutableList.of(), rowType);
    }

    private static <E> ImmutableList<ImmutableList<E>> copy(Iterable<? extends List<E>> tupleList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int changeCount = 0;
        for (List<E> literals : tupleList) {
            ImmutableList literals2 = ImmutableList.copyOf(literals);
            builder.add((Object)literals2);
            if (literals == literals2) continue;
            ++changeCount;
        }
        if (changeCount == 0) {
            return (ImmutableList)tupleList;
        }
        return builder.build();
    }

    public RelBuilder limit(int offset, int fetch) {
        return this.sortLimit(offset, fetch, (Iterable<? extends RexNode>)ImmutableList.of());
    }

    public RelBuilder exchange(RelDistribution distribution) {
        RelNode exchange = this.exchangeFactory.createExchange(this.peek(), distribution);
        this.replaceTop(exchange);
        return this;
    }

    public RelBuilder sortExchange(RelDistribution distribution, RelCollation collation) {
        RelNode exchange = this.sortExchangeFactory.createSortExchange(this.peek(), distribution, collation);
        this.replaceTop(exchange);
        return this;
    }

    public RelBuilder sort(int ... fields) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int field : fields) {
            builder.add((Object)(field < 0 ? this.desc(this.field(-field - 1)) : this.field(field)));
        }
        return this.sortLimit(-1, -1, (Iterable<? extends RexNode>)builder.build());
    }

    public RelBuilder sort(RexNode ... nodes) {
        return this.sortLimit(-1, -1, (Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public RelBuilder sort(Iterable<? extends RexNode> nodes) {
        return this.sortLimit(-1, -1, nodes);
    }

    public RelBuilder sortLimit(int offset, int fetch, RexNode ... nodes) {
        return this.sortLimit(offset, fetch, (Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public RelBuilder sortLimit(int offset, int fetch, Iterable<? extends RexNode> nodes) {
        RexNode fetchNode;
        Registrar registrar = new Registrar((Iterable<RexNode>)this.fields());
        List<RelFieldCollation> fieldCollations = registrar.registerFieldCollations(nodes);
        RexNode offsetNode = offset <= 0 ? null : this.literal(offset);
        RexNode rexNode = fetchNode = fetch < 0 ? null : this.literal(fetch);
        if (offsetNode == null && fetch == 0) {
            return this.empty();
        }
        if (offsetNode == null && fetchNode == null && fieldCollations.isEmpty()) {
            return this;
        }
        if (fieldCollations.isEmpty()) {
            Project project;
            assert (registrar.addedFieldCount() == 0);
            RelNode top = this.peek();
            if (top instanceof Sort) {
                Sort sort2 = (Sort)top;
                if (sort2.offset == null && sort2.fetch == null) {
                    this.replaceTop(sort2.getInput());
                    RelNode sort = this.sortFactory.createSort(this.peek(), sort2.collation, offsetNode, fetchNode);
                    this.replaceTop(sort);
                    return this;
                }
            }
            if (top instanceof Project && (project = (Project)top).getInput() instanceof Sort) {
                Sort sort2 = (Sort)project.getInput();
                if (sort2.offset == null && sort2.fetch == null) {
                    RelNode sort = this.sortFactory.createSort(sort2.getInput(), sort2.collation, offsetNode, fetchNode);
                    this.replaceTop(this.projectFactory.createProject(sort, project.getProjects(), Pair.right(project.getNamedProjects())));
                    return this;
                }
            }
        }
        if (registrar.addedFieldCount() > 0) {
            this.project(registrar.extraNodes);
        }
        RelNode sort = this.sortFactory.createSort(this.peek(), RelCollations.of(fieldCollations), offsetNode, fetchNode);
        this.replaceTop(sort);
        if (registrar.addedFieldCount() > 0) {
            this.project(registrar.originalExtraNodes);
        }
        return this;
    }

    private static RelFieldCollation collation(RexNode node, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection, List<RexNode> extraNodes) {
        switch (node.getKind()) {
            case INPUT_REF: {
                return new RelFieldCollation(((RexInputRef)node).getIndex(), direction, Util.first(nullDirection, direction.defaultNullDirection()));
            }
            case DESCENDING: {
                return RelBuilder.collation(((RexCall)node).getOperands().get(0), RelFieldCollation.Direction.DESCENDING, nullDirection, extraNodes);
            }
            case NULLS_FIRST: {
                return RelBuilder.collation(((RexCall)node).getOperands().get(0), direction, RelFieldCollation.NullDirection.FIRST, extraNodes);
            }
            case NULLS_LAST: {
                return RelBuilder.collation(((RexCall)node).getOperands().get(0), direction, RelFieldCollation.NullDirection.LAST, extraNodes);
            }
        }
        int fieldIndex = extraNodes.size();
        extraNodes.add(node);
        return new RelFieldCollation(fieldIndex, direction, Util.first(nullDirection, direction.defaultNullDirection()));
    }

    public RelBuilder convert(RelDataType castRowType, boolean rename) {
        RelNode r = this.build();
        RelNode r2 = RelOptUtil.createCastRel(r, castRowType, rename, this.projectFactory);
        this.push(r2);
        return this;
    }

    public RelBuilder permute(Mapping mapping) {
        assert (mapping.getMappingType().isSingleSource());
        assert (mapping.getMappingType().isMandatorySource());
        if (mapping.isIdentity()) {
            return this;
        }
        ArrayList<RexInputRef> exprList = new ArrayList<RexInputRef>();
        for (int i = 0; i < mapping.getTargetCount(); ++i) {
            exprList.add(this.field(mapping.getSource(i)));
        }
        return this.project(exprList);
    }

    public RelBuilder aggregate(GroupKey groupKey, List<AggregateCall> aggregateCalls) {
        return this.aggregate(groupKey, Lists.transform(aggregateCalls, AggCallImpl2::new));
    }

    public RelBuilder match(RexNode pattern, boolean strictStart, boolean strictEnd, Map<String, RexNode> patternDefinitions, Iterable<? extends RexNode> measureList, RexNode after, Map<String, ? extends SortedSet<String>> subsets, boolean allRows, Iterable<? extends RexNode> partitionKeys, Iterable<? extends RexNode> orderKeys, RexNode interval) {
        Registrar registrar = new Registrar((Iterable<RexNode>)this.fields(), this.peek().getRowType().getFieldNames());
        List<RelFieldCollation> fieldCollations = registrar.registerFieldCollations(orderKeys);
        ImmutableBitSet partitionBitSet = ImmutableBitSet.of(registrar.registerExpressions(partitionKeys));
        RelDataTypeFactory.FieldInfoBuilder typeBuilder = this.cluster.getTypeFactory().builder();
        for (RexNode rexNode : partitionKeys) {
            ((RelDataTypeFactory.Builder)typeBuilder).add(rexNode.toString(), rexNode.getType());
        }
        if (allRows) {
            for (RexNode rexNode : orderKeys) {
                if (typeBuilder.nameExists(rexNode.toString())) continue;
                ((RelDataTypeFactory.Builder)typeBuilder).add(rexNode.toString(), rexNode.getType());
            }
            RelDataType inputRowType = this.peek().getRowType();
            for (RelDataTypeField relDataTypeField : inputRowType.getFieldList()) {
                if (typeBuilder.nameExists(relDataTypeField.getName())) continue;
                ((RelDataTypeFactory.Builder)typeBuilder).add(relDataTypeField);
            }
        }
        ImmutableMap.Builder measures = ImmutableMap.builder();
        for (RexNode rexNode : measureList) {
            List<RexNode> operands = ((RexCall)rexNode).getOperands();
            String alias = operands.get(1).toString();
            ((RelDataTypeFactory.Builder)typeBuilder).add(alias, operands.get(0).getType());
            measures.put((Object)alias, (Object)operands.get(0));
        }
        RelNode relNode = this.matchFactory.createMatch(this.peek(), pattern, typeBuilder.build(), strictStart, strictEnd, patternDefinitions, (Map<String, RexNode>)measures.build(), after, subsets, allRows, partitionBitSet, RelCollations.of(fieldCollations), interval);
        this.stack.push(new Frame(relNode));
        return this;
    }

    public void clear() {
        this.stack.clear();
    }

    public static class ConfigBuilder {
        private boolean dedupAggregateCalls;
        private boolean simplify;

        private ConfigBuilder() {
        }

        public Config build() {
            return new Config(this.dedupAggregateCalls, this.simplify);
        }

        public ConfigBuilder withDedupAggregateCalls(boolean dedupAggregateCalls) {
            this.dedupAggregateCalls = dedupAggregateCalls;
            return this;
        }

        public ConfigBuilder withSimplify(boolean simplify) {
            this.simplify = simplify;
            return this;
        }
    }

    public static class Config {
        public static final Config DEFAULT = new Config(true, true);
        public final boolean dedupAggregateCalls;
        public final boolean simplify;

        private Config(boolean dedupAggregateCalls, boolean simplify) {
            this.dedupAggregateCalls = dedupAggregateCalls;
            this.simplify = simplify;
        }

        public static ConfigBuilder builder() {
            return DEFAULT.toBuilder();
        }

        public ConfigBuilder toBuilder() {
            return new ConfigBuilder().withDedupAggregateCalls(this.dedupAggregateCalls).withSimplify(this.simplify);
        }
    }

    private class Shifter
    extends RexShuttle {
        private final RelNode left;
        private final CorrelationId id;
        private final RelNode right;

        Shifter(RelNode left, CorrelationId id, RelNode right) {
            this.left = left;
            this.id = id;
            this.right = right;
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            RelDataType leftRowType = this.left.getRowType();
            RexBuilder rexBuilder = RelBuilder.this.getRexBuilder();
            int leftCount = leftRowType.getFieldCount();
            if (inputRef.getIndex() < leftCount) {
                RexNode v = rexBuilder.makeCorrel(leftRowType, this.id);
                return rexBuilder.makeFieldAccess(v, inputRef.getIndex());
            }
            return rexBuilder.makeInputRef(this.right, inputRef.getIndex() - leftCount);
        }
    }

    private static class Field
    extends Pair<ImmutableSet<String>, RelDataTypeField> {
        Field(ImmutableSet<String> left, RelDataTypeField right) {
            super(left, right);
        }

        Field addAlias(String alias) {
            if (((ImmutableSet)this.left).contains((Object)alias)) {
                return this;
            }
            ImmutableSet aliasList = ImmutableSet.builder().addAll((Iterable)this.left).add((Object)alias).build();
            return new Field((ImmutableSet<String>)aliasList, (RelDataTypeField)this.right);
        }
    }

    private static class Frame {
        final RelNode rel;
        final ImmutableList<Field> fields;

        private Frame(RelNode rel, ImmutableList<Field> fields) {
            this.rel = rel;
            this.fields = fields;
        }

        private Frame(RelNode rel) {
            String tableAlias = Frame.deriveAlias(rel);
            ImmutableList.Builder builder = ImmutableList.builder();
            ImmutableSet aliases = tableAlias == null ? ImmutableSet.of() : ImmutableSet.of((Object)tableAlias);
            for (RelDataTypeField field : rel.getRowType().getFieldList()) {
                builder.add((Object)new Field((ImmutableSet<String>)aliases, field));
            }
            this.rel = rel;
            this.fields = builder.build();
        }

        private static String deriveAlias(RelNode rel) {
            List<String> names;
            if (rel instanceof TableScan && !(names = rel.getTable().getQualifiedName()).isEmpty()) {
                return Util.last(names);
            }
            return null;
        }

        List<RelDataTypeField> fields() {
            return Pair.right(this.fields);
        }
    }

    private static class Registrar {
        final List<RexNode> originalExtraNodes;
        final List<RexNode> extraNodes;
        final List<String> names = new ArrayList<String>();

        Registrar(Iterable<RexNode> fields) {
            this(fields, (List<String>)ImmutableList.of());
        }

        Registrar(Iterable<RexNode> fields, List<String> fieldNames) {
            this.originalExtraNodes = ImmutableList.copyOf(fields);
            this.extraNodes = new ArrayList<RexNode>(this.originalExtraNodes);
            this.names.addAll(fieldNames);
        }

        int registerExpression(RexNode node) {
            switch (node.getKind()) {
                case AS: {
                    ImmutableList<RexNode> operands = ((RexCall)node).operands;
                    int i = this.registerExpression((RexNode)operands.get(0));
                    this.names.set(i, RexLiteral.stringValue((RexNode)operands.get(1)));
                    return i;
                }
            }
            int i = this.extraNodes.indexOf(node);
            if (i < 0) {
                i = this.extraNodes.size();
                this.extraNodes.add(node);
                this.names.add(null);
            }
            return i;
        }

        List<Integer> registerExpressions(Iterable<? extends RexNode> nodes) {
            ArrayList<Integer> builder = new ArrayList<Integer>();
            for (RexNode rexNode : nodes) {
                builder.add(this.registerExpression(rexNode));
            }
            return builder;
        }

        List<RelFieldCollation> registerFieldCollations(Iterable<? extends RexNode> orderKeys) {
            ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
            for (RexNode rexNode : orderKeys) {
                RelFieldCollation collation = RelBuilder.collation(rexNode, RelFieldCollation.Direction.ASCENDING, null, this.extraNodes);
                if (RelCollations.ordinals(fieldCollations).contains(collation.getFieldIndex())) continue;
                fieldCollations.add(collation);
            }
            return ImmutableList.copyOf(fieldCollations);
        }

        int addedFieldCount() {
            return this.extraNodes.size() - this.originalExtraNodes.size();
        }
    }

    private static class AggCallImpl2
    implements AggCall {
        private final AggregateCall aggregateCall;

        AggCallImpl2(AggregateCall aggregateCall) {
            this.aggregateCall = Objects.requireNonNull(aggregateCall);
        }

        @Override
        public AggCall sort(Iterable<RexNode> orderKeys) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall sort(RexNode ... orderKeys) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall approximate(boolean approximate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall filter(RexNode condition) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall as(String alias) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall distinct(boolean distinct) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall distinct() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall ignoreNulls(boolean ignoreNulls) {
            throw new UnsupportedOperationException();
        }
    }

    private class AggCallImpl
    implements AggCall {
        private final SqlAggFunction aggFunction;
        private final boolean distinct;
        private final boolean approximate;
        private final boolean ignoreNulls;
        private final RexNode filter;
        private final String alias;
        private final ImmutableList<RexNode> operands;
        private final ImmutableList<RexNode> orderKeys;

        AggCallImpl(SqlAggFunction aggFunction, boolean distinct, boolean approximate, boolean ignoreNulls, RexNode filter, String alias, ImmutableList<RexNode> operands, ImmutableList<RexNode> orderKeys) {
            this.aggFunction = Objects.requireNonNull(aggFunction);
            this.distinct = distinct && aggFunction.getDistinctOptionality() != Optionality.IGNORED;
            this.approximate = approximate;
            this.ignoreNulls = ignoreNulls;
            this.alias = alias;
            this.operands = Objects.requireNonNull(operands);
            this.orderKeys = Objects.requireNonNull(orderKeys);
            if (filter != null) {
                if (filter.getType().getSqlTypeName() != SqlTypeName.BOOLEAN) {
                    throw Static.RESOURCE.filterMustBeBoolean().ex();
                }
                if (filter.getType().isNullable()) {
                    filter = RelBuilder.this.call((SqlOperator)SqlStdOperatorTable.IS_TRUE, filter);
                }
            }
            this.filter = filter;
        }

        @Override
        public AggCall sort(Iterable<RexNode> orderKeys) {
            ImmutableList orderKeyList = ImmutableList.copyOf(orderKeys);
            return orderKeyList.equals(this.orderKeys) ? this : new AggCallImpl(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.filter, this.alias, this.operands, (ImmutableList<RexNode>)orderKeyList);
        }

        @Override
        public AggCall sort(RexNode ... orderKeys) {
            return this.sort((Iterable<RexNode>)ImmutableList.copyOf((Object[])orderKeys));
        }

        @Override
        public AggCall approximate(boolean approximate) {
            return approximate == this.approximate ? this : new AggCallImpl(this.aggFunction, this.distinct, approximate, this.ignoreNulls, this.filter, this.alias, this.operands, this.orderKeys);
        }

        @Override
        public AggCall filter(RexNode condition) {
            return Objects.equals(condition, this.filter) ? this : new AggCallImpl(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, condition, this.alias, this.operands, this.orderKeys);
        }

        @Override
        public AggCall as(String alias) {
            return Objects.equals(alias, this.alias) ? this : new AggCallImpl(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.filter, alias, this.operands, this.orderKeys);
        }

        @Override
        public AggCall distinct(boolean distinct) {
            return distinct == this.distinct ? this : new AggCallImpl(this.aggFunction, distinct, this.approximate, this.ignoreNulls, this.filter, this.alias, this.operands, this.orderKeys);
        }

        @Override
        public AggCall distinct() {
            return this.distinct(true);
        }

        @Override
        public AggCall ignoreNulls(boolean ignoreNulls) {
            return ignoreNulls == this.ignoreNulls ? this : new AggCallImpl(this.aggFunction, this.distinct, this.approximate, ignoreNulls, this.filter, this.alias, this.operands, this.orderKeys);
        }
    }

    public static class GroupKeyImpl
    implements GroupKey {
        public final ImmutableList<RexNode> nodes;
        public final ImmutableList<ImmutableList<RexNode>> nodeLists;
        public final String alias;

        GroupKeyImpl(ImmutableList<RexNode> nodes, ImmutableList<ImmutableList<RexNode>> nodeLists, String alias) {
            this.nodes = Objects.requireNonNull(nodes);
            this.nodeLists = nodeLists;
            this.alias = alias;
        }

        public String toString() {
            return this.alias == null ? this.nodes.toString() : this.nodes + " as " + this.alias;
        }

        @Override
        public GroupKey alias(String alias) {
            return Objects.equals(this.alias, alias) ? this : new GroupKeyImpl(this.nodes, this.nodeLists, alias);
        }
    }

    public static interface GroupKey {
        public GroupKey alias(String var1);
    }

    public static interface AggCall {
        public AggCall filter(RexNode var1);

        public AggCall sort(Iterable<RexNode> var1);

        public AggCall sort(RexNode ... var1);

        public AggCall approximate(boolean var1);

        public AggCall ignoreNulls(boolean var1);

        public AggCall as(String var1);

        public AggCall distinct(boolean var1);

        public AggCall distinct();
    }

    private static final class RelOptTableFinder
    extends RelHomogeneousShuttle {
        private RelOptTable relOptTable = null;
        private final String tableName;

        private RelOptTableFinder(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public RelNode visit(TableScan scan) {
            RelOptTable scanTable = scan.getTable();
            List<String> qualifiedName = scanTable.getQualifiedName();
            if (qualifiedName.get(qualifiedName.size() - 1).equals(this.tableName)) {
                this.relOptTable = scanTable;
            }
            return super.visit(scan);
        }
    }
}

