/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;

public class ProjectJoinJoinRemoveRule
extends RelOptRule {
    public static final ProjectJoinJoinRemoveRule INSTANCE = new ProjectJoinJoinRemoveRule(LogicalProject.class, LogicalJoin.class, RelFactories.LOGICAL_BUILDER);

    public ProjectJoinJoinRemoveRule(Class<? extends Project> projectClass, Class<? extends Join> joinClass, RelBuilderFactory relBuilderFactory) {
        super(ProjectJoinJoinRemoveRule.operand(projectClass, ProjectJoinJoinRemoveRule.operandJ(joinClass, null, join -> join.getJoinType() == JoinRelType.LEFT, ProjectJoinJoinRemoveRule.operandJ(joinClass, null, join -> join.getJoinType() == JoinRelType.LEFT, ProjectJoinJoinRemoveRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        Join topJoin = (Join)call.rel(1);
        Join bottomJoin = (Join)call.rel(2);
        int leftBottomChildSize = bottomJoin.getLeft().getRowType().getFieldCount();
        for (RexNode expr2 : project.getProjects()) {
            if (!RelOptUtil.InputFinder.bits(expr2).asList().stream().anyMatch(i -> i >= leftBottomChildSize && i < bottomJoin.getRowType().getFieldCount())) continue;
            return;
        }
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        RelOptUtil.splitJoinCondition(topJoin.getLeft(), topJoin.getRight(), topJoin.getCondition(), leftKeys, new ArrayList<Integer>(), new ArrayList<Boolean>());
        if (leftKeys.stream().anyMatch(s -> s >= leftBottomChildSize)) {
            return;
        }
        ArrayList<Integer> leftChildKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightChildKeys = new ArrayList<Integer>();
        RelOptUtil.splitJoinCondition(bottomJoin.getLeft(), bottomJoin.getRight(), bottomJoin.getCondition(), leftChildKeys, rightChildKeys, new ArrayList<Boolean>());
        if (!leftKeys.equals(leftChildKeys)) {
            return;
        }
        ImmutableBitSet.Builder columns = ImmutableBitSet.builder();
        rightChildKeys.forEach(key -> columns.set((int)key));
        Object mq = call.getMetadataQuery();
        if (!((RelMetadataQuery)mq).areColumnsUnique(bottomJoin.getRight(), columns.build()).booleanValue()) {
            return;
        }
        int offset = bottomJoin.getRight().getRowType().getFieldCount();
        RelBuilder relBuilder = call.builder();
        RexNode condition = RexUtil.shift(topJoin.getCondition(), leftBottomChildSize, -offset);
        RelNode join = relBuilder.push(bottomJoin.getLeft()).push(topJoin.getRight()).join(topJoin.getJoinType(), condition).build();
        List newExprs = project.getProjects().stream().map(expr -> RexUtil.shift(expr, leftBottomChildSize, -offset)).collect(Collectors.toList());
        relBuilder.push(join).project(newExprs);
        call.transformTo(relBuilder.build());
    }
}

