# This file is empty by default. Default Drill environment settings appear
# in drill-config.sh. Distributions can replace this file with a
# distribution-specific version that sets environment variables and options
# specific to that distribution. Users should not put anything in this file;
# put user options in drill-env.sh instead.

# MapR-specific environment settings for Drill

export HADOOP_VERSION=`cat /opt/mapr/hadoop/hadoopversion`
export HADOOP_HOME=${HADOOP_HOME:-"/opt/mapr/hadoop/hadoop-${HADOOP_VERSION}"}

export DRILL_JAVA_OPTS="${DRILL_JAVA_OPTS} -Djava.security.auth.login.config=/opt/mapr/conf/mapr.login.conf -Dhadoop.login=hybrid_keytab -Dzookeeper.sasl.client=false" 
export DRILL_LOG_DIR=${DRILL_LOG_DIR:-"/opt/mapr/drill/drill-1.12.0/logs"}
export DRILL_PID_DIR=${DRILL_PID_DIR:-"/opt/mapr/pid"}
export MAPR_IMPERSONATION_ENABLED=${MAPR_IMPERSONATION_ENABLED:-"true"}

# Only set MAPR_TICKETFILE_LOCATION when invoked in context of drillbit setup NOT sqlline. It is expected
# to generate a separate ticket when sqlline is used.
if [ "$DRILLBIT_CONTEXT" = "1" ]; then
    export MAPR_TICKETFILE_LOCATION=${MAPR_TICKETFILE_LOCATION:-"/opt/mapr/conf/mapruserticket"}
fi
export SQLLINE_JAVA_OPTS="${SQLLINE_JAVA_OPTS} -Ddrill.customAuthFactories=org.apache.drill.exec.rpc.security.maprsasl.MapRSaslFactory -Dzookeeper.sasl.client=false -Djava.security.auth.login.config=/opt/mapr/conf/mapr.login.conf"

