
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.apache.drill.exec.expr.fn.impl.gcast;


import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;

import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.base.Charsets;
import com.google.common.collect.ObjectArrays;

import com.google.common.base.Preconditions;
import io.netty.buffer.*;

import org.apache.commons.lang3.ArrayUtils;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.expr.fn.impl.StringFunctionUtil;
import org.apache.drill.exec.memory.*;
import org.apache.drill.exec.proto.SchemaDefProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserBitShared.DrillPBError;
import org.apache.drill.exec.proto.UserBitShared.SerializedField;
import org.apache.drill.exec.record.*;
import org.apache.drill.exec.vector.*;
import org.apache.drill.common.exceptions.*;
import org.apache.drill.exec.exception.*;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.types.TypeProtos.*;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.vector.complex.*;
import org.apache.drill.exec.vector.complex.reader.*;
import org.apache.drill.exec.vector.complex.impl.*;
import org.apache.drill.exec.vector.complex.writer.*;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.MapWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.ListWriter;
import org.apache.drill.exec.util.JsonStringArrayList;

import org.apache.drill.exec.exception.OutOfMemoryException;

import com.sun.codemodel.JType;
import com.sun.codemodel.JCodeModel;

import javax.inject.Inject;

import java.util.Arrays;
import java.util.Random;
import java.util.List;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.math.BigDecimal;
import java.math.BigInteger;

import org.joda.time.DateTime;
import org.joda.time.Period;

import org.apache.drill.exec.util.Text;

import org.apache.drill.exec.vector.accessor.sql.TimePrintMillis;
import javax.inject.Inject;






import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.expr.annotations.Workspace;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;

import java.nio.ByteBuffer;

/*
 * This class is generated using freemarker and the Decimal/CastDecimalSparseDecimalDense.java template.
 */

@SuppressWarnings("unused")
@FunctionTemplate(name = "castDECIMAL38DENSE",
    scope = FunctionTemplate.FunctionScope.SIMPLE,
    returnType = FunctionTemplate.ReturnType.DECIMAL_CAST,
    nulls = NullHandling.NULL_IF_NULL)
public class CastDecimal38SparseDecimal38Dense implements DrillSimpleFunc{

    @Param Decimal38SparseHolder in;
    @Inject DrillBuf buffer;
    @Param BigIntHolder precision;
    @Param BigIntHolder scale;
    @Output Decimal38DenseHolder out;

    public void setup() {
        int size = (4 * (org.apache.drill.exec.util.DecimalUtility.INTEGER_SIZE));
        buffer = buffer.reallocIfNeeded(size);
    }

    public void eval() {

        out.buffer = buffer;
        out.start = 0;

        // Re initialize the buffer everytime
        for (int i = 0; i < 4; i++) {
            out.setInteger(i, 0, out.start, out.buffer);
        }

        out.scale = (int) scale.value;
        out.precision = (int) precision.value;

        /* Before converting from a sparse representation to a dense representation
         * we need to convert it to an intermediate representation. In the sparse
         * representation we separate out the scale and the integer part of the decimal
         * and pad the scale part with additional zeroes for ease of performing arithmetic
         * operations. In the intermediate representation we strip out the extra zeroes and
         * combine the scale and integer part.
         */
        int[] intermediate = new int[in.nDecimalDigits - 1];

        int index = in.nDecimalDigits - 1;
        int actualDigits;

        if (in.scale > 0 && (actualDigits = (in.scale % org.apache.drill.exec.util.DecimalUtility.MAX_DIGITS)) > 0) {

            int paddedDigits = org.apache.drill.exec.util.DecimalUtility.MAX_DIGITS - actualDigits;

            int paddedMask = (int) Math.pow(10, paddedDigits);

            /* We have a scale that does not completely occupy a decimal
             * digit, so we have padded zeroes to it for ease of arithmetic
             * Truncate the extra zeroes added and move the digits to the right
             */
            int temp = (in.getInteger(index, in.start, in.buffer)/paddedMask);
            index--;

            while(index >= 0) {

                int transferDigits = (in.getInteger(index, in.start, in.buffer) % (paddedMask));

                intermediate[index] = (int) (temp + (Math.pow(10, actualDigits) * transferDigits));

                temp = (in.getInteger(index, in.start, in.buffer)/(paddedMask));

                index--;
            }
        } else {

            /* If the scale does not exist or it perfectly fits within a decimal digit
             * then we have padded no zeroes, which means there can atmost be only 38 digits, which
             * need only 5 decimal digit to be stored, simply copy over the integers
             */
            for (int i = 1; i < in.nDecimalDigits; i++)
                intermediate[i - 1] = in.getInteger(i, in.start, in.buffer);

        }

        /* Now we have an intermediate representation in the array intermediate[]
         * Every number in the intermediate representation is base 1 billion number
         * To represent it we require only 30 bits, but every integer has 32 bits.
         * By shifting the bits around we can utilize the extra two bits on every
         * number and create a dense representation
         */

          /* Allocate a byte array */
          int size = (((intermediate.length - 1) * org.apache.drill.exec.util.DecimalUtility.INTEGER_SIZE) + 1);
          byte[] intermediateBytes = new byte[size];
          java.nio.ByteBuffer wrapper = java.nio.ByteBuffer.wrap(intermediateBytes);

          wrapper.put((byte) intermediate[0]);

          for (int i = 1; i < intermediate.length; i++) {
            wrapper.put(java.nio.ByteBuffer.allocate(org.apache.drill.exec.util.DecimalUtility.INTEGER_SIZE).putInt(intermediate[i]).array());
          }

          final int[] mask = {0x03, 0x0F, 0x3F, 0xFF};
          int maskIndex = 0;
          int shiftOrder = 2;

          // Start just after the last integer and shift bits to the right
          index = size - (org.apache.drill.exec.util.DecimalUtility.INTEGER_SIZE+ 1);

          while (index >= 0) {

              /* get the last bits that need to shifted to the next byte */
              byte shiftBits = (byte) ((intermediateBytes[index] & mask[maskIndex]) << (8 - shiftOrder));

              int shiftOrder1 = ((index % org.apache.drill.exec.util.DecimalUtility.INTEGER_SIZE) == 0) ? shiftOrder - 2 : shiftOrder;

              /* transfer the bits from the left to the right */
              intermediateBytes[index + 1] = (byte) (((intermediateBytes[index + 1] & 0xFF) >>> (shiftOrder1)) | shiftBits);

              index--;

              if ((index % org.apache.drill.exec.util.DecimalUtility.INTEGER_SIZE) == 0) {
                  /* We are on a border */
                  shiftOrder += 2;
                  maskIndex++;
              }
          }

          int dstIndex = 0;

          // Set the bytes in the buffer
          out.buffer.setBytes(dstIndex, intermediateBytes, 1, (size - 1));
          out.setSign(in.getSign(in.start, in.buffer), out.start, out.buffer);
    }
}
