/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;

public abstract class KrbInputStream
extends DataInputStream {
    public KrbInputStream(InputStream in) {
        super(in);
    }

    public KerberosTime readTime() throws IOException {
        long value = this.readInt();
        KerberosTime time = new KerberosTime(value * 1000L);
        return time;
    }

    public abstract PrincipalName readPrincipal(int var1) throws IOException;

    public EncryptionKey readKey(int version) throws IOException {
        short eType = this.readShort();
        EncryptionType encryptionType = EncryptionType.fromValue((Integer)Integer.valueOf(eType));
        byte[] keyData = this.readCountedOctets();
        EncryptionKey key = new EncryptionKey(encryptionType, keyData);
        return key;
    }

    public String readCountedString() throws IOException {
        byte[] countedOctets = this.readCountedOctets();
        return new String(countedOctets, StandardCharsets.UTF_8);
    }

    public byte[] readCountedOctets() throws IOException {
        int len = this.readOctetsCount();
        if (len == 0) {
            return null;
        }
        byte[] data = new byte[len];
        if (this.read(data) == -1) {
            throw new IOException();
        }
        return data;
    }

    public abstract int readOctetsCount() throws IOException;
}

