/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.google.monitoring.runtime.instrumentation.common.com.google.common.collect.Lists;
import com.mapr.db.MetaTable;
import com.mapr.db.Table;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.TabletInfoImpl;
import com.mapr.db.impl.scan.ScanStatsImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.scan.ScanRange;
import com.mapr.db.scan.ScanStats;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.fs.FidInfo;
import com.mapr.fs.util.Fids;
import com.mapr.fs.utils.ssh.RunCommand;
import com.mapr.fs.utils.ssh.TestCluster;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.DocumentStream;
import org.ojai.json.Json;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestMetaTable
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestMetaTable.class);
    private static final String TABLE_NAME = "testtable-" + TestMetaTable.class.getSimpleName();
    private static final String INDEX1_NAME = "idx_age";
    private static final String INDEX2_NAME = "idx_state_age";
    private static final int NUM_USERS = 100000;
    private static final int NUM_ADMINS = 1000;
    private static Table table;
    private static Path tablePath;
    private static Collection<IndexDesc> tableIndexColl;
    private static BaseJsonTable keyOnlyIndexTable;
    private static BaseJsonTable keyValueIndexTable;

    private static void checkResult(String streamName, String output) {
        String local = output;
        if (local != null && (local = local.trim()).length() > 0) {
            System.err.println("error on " + streamName + ": " + local);
        }
    }

    private static void checkResult(RunCommand runCommand) {
        TestMetaTable.checkResult("stdout", runCommand.getStdOut());
        TestMetaTable.checkResult("stderr", runCommand.getStdErr());
    }

    @BeforeClass
    public static void setup_TestMetaTable() throws Exception {
        try (InputStream testJson = TestMetaTable.class.getClassLoader().getResourceAsStream("com/mapr/db/tests/json/for_metatable.json");
             DocumentStream stream = Json.newDocumentStream((InputStream)testJson);){
            int i;
            ArrayList docList = Lists.newArrayList();
            for (Document document : stream) {
                docList.add(document);
            }
            DBTests.setTableStatsSendInterval(1L);
            table = DBTests.createOrReplaceTable(TABLE_NAME, new String[]{"m"}).setOption(Table.TableOption.BUFFERWRITE, true);
            tablePath = table.getPath();
            long rowCount = 0L;
            Random rnd = new Random(0L);
            for (i = 0; i < 1000; ++i) {
                table.insertOrReplace(String.format("admin%05d", i), (Document)docList.get(rnd.nextInt(docList.size())));
            }
            rowCount += 1000L;
            for (i = 0; i < 100000; ++i) {
                table.insertOrReplace(String.format("user%05d", i), (Document)docList.get(rnd.nextInt(docList.size())));
            }
            table.flush();
            DBTests.createIndex(TABLE_NAME, INDEX1_NAME, new String[]{"age"}, new String[]{"name.first", "name.last", "state"});
            DBTests.createIndex(TABLE_NAME, INDEX2_NAME, new String[]{"state", "age"});
            DBTests.waitForIndexFlush(TABLE_NAME);
            DBTests.waitForRowCount(TABLE_NAME, rowCount += 100000L);
            DBTests.waitForRowCountFromNC(tablePath, rowCount, 75000L);
            tableIndexColl = DBTests.admin().getTableIndexes(tablePath, false);
            Assert.assertEquals((long)2L, (long)tableIndexColl.size());
            Iterator<IndexDesc> indexItr = tableIndexColl.iterator();
            IndexDesc indexTableDesc = indexItr.next();
            Assert.assertEquals((long)1L, (long)indexTableDesc.getIndexedFields().size());
            DBTests.waitForRowCount(TABLE_NAME, indexTableDesc.getIndexFid(), rowCount);
            keyValueIndexTable = (BaseJsonTable)MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
            indexTableDesc = indexItr.next();
            Assert.assertEquals((long)2L, (long)indexTableDesc.getIndexedFields().size());
            DBTests.waitForRowCount(TABLE_NAME, indexTableDesc.getIndexFid(), rowCount);
            keyOnlyIndexTable = (BaseJsonTable)MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        }
    }

    @AfterClass
    public static void cleanup_TestMetaTable() throws Exception {
        if (table != null) {
            table.close();
            DBTests.deleteTables(TABLE_NAME);
        }
        DBTests.setTableStatsSendInterval(5L);
    }

    @Test
    public void test_MetaTable() throws DBException, IOException {
        try (MetaTable metaTable0 = table.getMetaTable();
             MetaTable keyOnlyIndexMetaTable = keyOnlyIndexTable.getMetaTable();
             MetaTable keyValueIndexMetaTable = keyValueIndexTable.getMetaTable();){
            ScanStats scanStats0 = metaTable0.getScanStats();
            _logger.info("Primary table scan stats {}.", (Object)scanStats0);
            List scanRanges0 = metaTable0.getScanRanges();
            Assert.assertEquals((String)"Primary table was created with 2 tablets", (long)2L, (long)scanRanges0.size());
            long avgRowSize0 = metaTable0.getAverageRowSize();
            Assert.assertTrue((String)"Average row size of primary table should be greater than zero", (avgRowSize0 > 0L ? 1 : 0) != 0);
            ScanStats scanStats1 = keyOnlyIndexMetaTable.getScanStats();
            _logger.info("Small index table scan stats {}.", (Object)scanStats1);
            List scanRanges1 = keyOnlyIndexMetaTable.getScanRanges();
            Assert.assertEquals((String)"Index tables (non-hashed) are created with 1 tablet", (long)1L, (long)scanRanges1.size());
            Assert.assertTrue((String)"Primary table should always be bigger than index table", (scanStats0.getEstimatedSize() > scanStats1.getEstimatedSize() ? 1 : 0) != 0);
            Assert.assertEquals((String)"Primary table should have same number of rows as index table", (long)scanStats0.getEstimatedNumRows(), (long)scanStats1.getEstimatedNumRows());
            long avgRowSize1 = keyOnlyIndexMetaTable.getAverageRowSize();
            Assert.assertTrue((String)"Average row size of small index table should be greater than zero", (avgRowSize1 > 0L ? 1 : 0) != 0);
            ScanStats scanStats2 = keyValueIndexMetaTable.getScanStats();
            _logger.info("Large index table scan stats {}.", (Object)scanStats2);
            List scanRanges2 = keyValueIndexMetaTable.getScanRanges();
            Assert.assertEquals((String)"Index tables (non-hashed) are created with 1 tablet", (long)1L, (long)scanRanges2.size());
            Assert.assertTrue((String)"Primary table should always be bigger than index table", (scanStats0.getEstimatedSize() > scanStats2.getEstimatedSize() ? 1 : 0) != 0);
            Assert.assertEquals((String)"Primary table should have same number of rows as index table", (long)scanStats0.getEstimatedNumRows(), (long)scanStats2.getEstimatedNumRows());
            Assert.assertTrue((String)"Index table with more fields should always be bigger than the index table with less fields", (scanStats2.getEstimatedSize() > scanStats1.getEstimatedSize() ? 1 : 0) != 0);
            long avgRowSize2 = keyValueIndexMetaTable.getAverageRowSize();
            Assert.assertTrue((String)"Average row size of large index table should be greater than zero", (avgRowSize2 > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void test_MetaTableWithConditionOnNonId() throws DBException, IOException {
        try (MetaTable keyValueIndexMetaTable = keyValueIndexTable.getMetaTable();){
            ConditionImpl cond = MapRDBImpl.newCondition().or().is("age", QueryCondition.Op.LESS, 10).is("age", QueryCondition.Op.GREATER, 30).close().build();
            List scanRanges = keyValueIndexMetaTable.getScanRanges((QueryCondition)cond);
            Assert.assertEquals((String)"Condition should return 2 scan ranges", (long)2L, (long)scanRanges.size());
            ScanStatsImpl scanStats = (ScanStatsImpl)keyValueIndexMetaTable.getScanStats((QueryCondition)cond);
            _logger.info("scan stats is {}.", (Object)scanStats);
            Assert.assertEquals((String)"Condition should return 2 partitions for 2 scan ranges", (long)2L, (long)scanStats.getPartitionCount());
            Assert.assertEquals((String)"Condition should return 1 tablet since both scan ranges are part of the same tablet", (long)1L, (long)scanStats.getTabletCount());
        }
    }

    @Test
    public void test_MetaTableWithConditionOnId() throws DBException, IOException {
        try (MetaTable metaTable0 = table.getMetaTable();
             MetaTable keyOnlyIndexMetaTable = keyOnlyIndexTable.getMetaTable();
             MetaTable keyValueIndexMetaTable = keyValueIndexTable.getMetaTable();){
            ConditionImpl condtionOnIdField = MapRDBImpl.newCondition().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "user").build();
            ScanStats scanStats0 = metaTable0.getScanStats((QueryCondition)condtionOnIdField);
            _logger.info("Primary table scan stats {}.", (Object)scanStats0);
            List scanRanges0 = metaTable0.getScanRanges((QueryCondition)condtionOnIdField);
            Assert.assertEquals((String)"Condition should prune the scan range to one tablet.", (long)1L, (long)scanRanges0.size());
            ScanStats scanStats1 = keyOnlyIndexMetaTable.getScanStats((QueryCondition)condtionOnIdField);
            _logger.info("Small index table scan stats {}.", (Object)scanStats1);
            List scanRanges1 = keyOnlyIndexMetaTable.getScanRanges((QueryCondition)condtionOnIdField);
            Assert.assertEquals((String)"Index tables (non-hashed) are created with 1 tablet", (long)1L, (long)scanRanges1.size());
            Assert.assertTrue((String)"Primary table should always be bigger than index table", (scanStats0.getEstimatedSize() > scanStats1.getEstimatedSize() ? 1 : 0) != 0);
            Assert.assertTrue((String)"Primary table should have lesser number of rows as index table", (scanStats0.getEstimatedNumRows() < scanStats1.getEstimatedNumRows() ? 1 : 0) != 0);
            ScanStats scanStats2 = keyValueIndexMetaTable.getScanStats((QueryCondition)condtionOnIdField);
            _logger.info("Large index table scan stats {}.", (Object)scanStats2);
            List scanRanges2 = keyValueIndexMetaTable.getScanRanges((QueryCondition)condtionOnIdField);
            Assert.assertEquals((String)"Index tables (non-hashed) are created with 1 tablet", (long)1L, (long)scanRanges2.size());
            Assert.assertTrue((String)"Primary table should always be bigger than index table", (scanStats0.getEstimatedSize() * 2L > scanStats2.getEstimatedSize() ? 1 : 0) != 0);
            Assert.assertTrue((String)"Primary table should have lesser number of rows as index table", (scanStats0.getEstimatedNumRows() < scanStats2.getEstimatedNumRows() ? 1 : 0) != 0);
            Assert.assertTrue((String)"Index table with more fields should always be bigger than the index table with less fields", (scanStats2.getEstimatedSize() > scanStats1.getEstimatedSize() ? 1 : 0) != 0);
        }
    }

    @Test
    public void test_MetaTableTabletMapVersion() throws Exception {
        Table table = DBTests.createOrReplaceTable("testtable-table1", new String[]{"m"}).setOption(Table.TableOption.BUFFERWRITE, true);
        Path tablePath = table.getPath();
        MetaTable metaTable0 = table.getMetaTable();
        List scanRanges0 = metaTable0.getScanRanges();
        Assert.assertEquals((String)"Primary table does not have 2 tablets", (long)2L, (long)scanRanges0.size());
        DBTests.waitForSchemaUpdate();
        ScanRange range0 = (ScanRange)scanRanges0.get(0);
        TabletInfoImpl tInfo = (TabletInfoImpl)range0;
        String cmd = "maprcli table region merge -path " + tablePath + " -fid " + Fids.fidToString((FidInfo)tInfo.getFid());
        _logger.info(cmd);
        RunCommand rc = TestCluster.runCommand((String)cmd);
        TestMetaTable.checkResult(rc);
        table.close();
        table = MapRDBImpl.getTable((Path)tablePath);
        MetaTable metaTable1 = table.getMetaTable();
        List scanRanges1 = metaTable1.getScanRanges();
        Assert.assertEquals((String)"Primary table does not have 1 tablet after merge", (long)1L, (long)scanRanges1.size());
        DBTests.waitForSchemaUpdate();
        String cmd2 = "/opt/mapr/server/tools/loadtest -isjson true -keysize 128 -valsize 3072 -numrows 100000 -table " + tablePath;
        _logger.info(cmd2);
        RunCommand rc2 = TestCluster.runCommand((String)cmd2);
        TestMetaTable.checkResult(rc2);
        table.close();
        table = MapRDBImpl.getTable((Path)tablePath);
        MetaTable metaTable2 = table.getMetaTable();
        List scanRanges2 = metaTable2.getScanRanges();
        Assert.assertEquals((String)"Primary table does not have 2 tablets after split", (long)2L, (long)scanRanges2.size());
        table.close();
        DBTests.deleteTables("testtable-table1");
    }
}

