/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.google.common.collect.ImmutableMap;
import com.mapr.db.ControlInfo;
import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.ojai.DBDOMDocumentReader;
import com.mapr.db.ojai.DBDocumentReader2;
import com.mapr.db.ojai.DBDocumentReaderBase;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.json.Json;
import org.ojai.json.impl.JsonUtils;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.ojai.util.Values;

@Category(value={ClusterTest.class})
public class TestDBDocumentReader
extends BaseTest {
    private static final KeyValue _ID = DBValueBuilderImpl.KeyValueBuilder.initFrom("id1");

    private Document getRecord() {
        DBDocumentImpl r = new DBDocumentImpl();
        r.set("map.a", "eureka");
        r.set("map.b", 134566);
        HashMap<String, Object> m = new HashMap<String, Object>();
        HashMap<String, String> m2 = new HashMap<String, String>();
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(ODate.parse((String)"2014-06-22"));
        l.add(127);
        m.put("x1", OTime.parse((String)"11:20:30.450"));
        m.put("x2", OTimestamp.parse((String)"2009-02-23T00:00:00.000-08:00"));
        m2.put("y1", "pqrs");
        m2.put("y2", null);
        l.add(m2);
        ArrayList<Comparable<Boolean>> l2 = new ArrayList<Comparable<Boolean>>();
        l2.add(Boolean.valueOf(true));
        l2.add(Double.valueOf(222.111));
        l2.add(ByteBuffer.wrap("abcd".getBytes()));
        l.add(l2);
        m.put("inner", l);
        r.set("nestedmap", m);
        r.set("doubleval", 12345.6789);
        return r;
    }

    private Document getRecordWithArray() {
        Document r = this.getRecord();
        ArrayList<Comparable<Boolean>> l = new ArrayList<Comparable<Boolean>>();
        l.add(Boolean.valueOf(true));
        l.add(new BigDecimal(11111.2222));
        r.set("map.c", l);
        return r;
    }

    private void iterateOverTokens(DocumentReader reader) {
        DocumentReader.EventType et = null;
        String fieldName = null;
        while ((et = reader.next()) != null) {
            if (!reader.inMap() || reader.getFieldName() == null) continue;
            fieldName = reader.getFieldName();
            if (et == DocumentReader.EventType.STRING) {
                if (fieldName.equals("y1")) {
                    Assert.assertEquals((Object)true, (Object)reader.getString().equals("pqrs"));
                }
                if (!fieldName.equals("val1")) continue;
                Assert.assertEquals((Object)true, (Object)reader.getString().equals("abracadabra"));
                continue;
            }
            if (et == DocumentReader.EventType.INT) {
                if (!fieldName.equals("val1")) continue;
                Assert.assertEquals((long)1345L, (long)reader.getInt());
                continue;
            }
            if (et == DocumentReader.EventType.DECIMAL) {
                BigDecimal bigd = reader.getDecimal();
                BigDecimal d2 = new BigDecimal("9888.11123");
                Assert.assertEquals((Object)true, (Object)bigd.equals(d2));
                continue;
            }
            if (et == DocumentReader.EventType.DATE) {
                ODate d = reader.getDate();
                Assert.assertEquals((Object)"2014-06-22", (Object)d.toDateStr());
                continue;
            }
            if (et == DocumentReader.EventType.TIME) {
                OTime t = reader.getTime();
                Assert.assertEquals((Object)OTime.parse((String)"11:20:30.450"), (Object)t);
                continue;
            }
            if (et == DocumentReader.EventType.TIMESTAMP) {
                OTimestamp ts = reader.getTimestamp();
                Assert.assertEquals((Object)OTimestamp.parse((String)"2009-02-23T00:00:00.000-08:00"), (Object)ts);
                continue;
            }
            if (et != DocumentReader.EventType.BOOLEAN) continue;
            Assert.assertEquals((Object)true, (Object)reader.getBoolean());
        }
    }

    @Test
    public void testMultiLevelMap() throws Exception {
        Document r = this.getRecord();
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("val1", 1345);
        m.put("val2", "abracadabra");
        ArrayList<Comparable<BigDecimal>> l = new ArrayList<Comparable<BigDecimal>>();
        l.add(new BigDecimal("9888.11123"));
        l.add(Boolean.valueOf(true));
        r.set("map.array", l);
        r.set("map.secondmap", m);
        Table myTab = DBTests.createOrReplaceTable("mytab");
        myTab.insertOrReplace("k1", r);
        myTab.flush();
        DocumentStream rs = myTab.find();
        Iterator iter = rs.documentReaders().iterator();
        if (iter.hasNext()) {
            DocumentReader reader = (DocumentReader)iter.next();
            this.iterateOverTokens(reader);
        }
        myTab.close();
    }

    @Test
    public void testWithEmptyTable() throws Exception {
        Table myTab = DBTests.createOrReplaceTable("mytab");
        DocumentStream rs = myTab.find();
        Iterator iter = rs.documentReaders().iterator();
        if (iter.hasNext()) {
            DocumentReader reader = (DocumentReader)iter.next();
            this.iterateOverTokens(reader);
        }
        myTab.close();
    }

    @Test
    public void testWithRecordReaderIterable() throws Exception {
        Document r = this.getRecord();
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("val1", 1345);
        m.put("val2", "abracadabra");
        ArrayList<Comparable<BigDecimal>> l = new ArrayList<Comparable<BigDecimal>>();
        l.add(new BigDecimal(9888.11123));
        l.add(Boolean.valueOf(true));
        r.set("map.array", l);
        r.set("map.secondmap", m);
        Table myTab = DBTests.createOrReplaceTable("mytab");
        myTab.setOption(Table.TableOption.EXCLUDEID, false);
        myTab.insertOrReplace("k1", r);
        myTab.insertOrReplace("k2", r);
        myTab.flush();
        DocumentStream stream = myTab.find();
        int recordCount = 0;
        for (DocumentReader reader : stream.documentReaders()) {
            ++recordCount;
        }
        Assert.assertEquals((long)2L, (long)recordCount);
        myTab.close();
    }

    @Test
    public void testDelayedDOMCreation() throws Exception {
        Document r = this.getRecord();
        Table myTab = DBTests.createOrReplaceTable("mytab");
        Table newTab = DBTests.createOrReplaceTable("newTab");
        myTab.insertOrReplace("k1", r);
        myTab.flush();
        DocumentStream rs = myTab.find();
        Iterator iter = rs.iterator();
        int i = 0;
        while (iter.hasNext()) {
            newTab.insertOrReplace((Document)iter.next());
            ++i;
        }
        newTab.flush();
        myTab.close();
        Document rec = newTab.findById("k1");
        Assert.assertEquals((Object)"eureka", (Object)rec.getString("map.a"));
        Assert.assertEquals((long)127L, (long)rec.getInt("nestedmap.inner[1]"));
        newTab.close();
    }

    @Test
    public void testTimeDescriptor() throws Exception {
        Document doc = this.getRecord();
        MapRDBTableImpl myTab = (MapRDBTableImpl)DBTests.createOrReplaceTable("myTab");
        myTab.insertOrReplace("k1", doc);
        myTab.flush();
        DocumentStream rs = myTab.find();
        for (DocumentReader reader : rs.documentReaders()) {
            this.iterateOverReader(reader);
        }
    }

    private void iterateOverReader(DocumentReader r) {
        DocumentReader.EventType event = null;
        while ((event = r.next()) != null) {
            DBDocumentReader2 r1;
            if (r instanceof DBDocumentReader2) {
                r1 = (DBDocumentReader2)r;
                if (event != DocumentReader.EventType.END_MAP && event == DocumentReader.EventType.END_ARRAY) continue;
            }
            r1 = (DBDOMDocumentReader)r;
            if (event == DocumentReader.EventType.END_MAP || event == DocumentReader.EventType.END_ARRAY) continue;
            Assert.assertEquals((Object)false, (Object)r1.getControlInfo().isDelete());
        }
    }

    private void checkIdField(DocumentReader reader, boolean checkFound) {
        DocumentReader.EventType et = null;
        Object fieldName = null;
        boolean foundId = false;
        while ((et = reader.next()) != null) {
            if (!reader.inMap() || !"_id".equals(reader.getFieldName())) continue;
            foundId = true;
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)"k1", (Object)reader.getString());
        }
        Assert.assertEquals((Object)checkFound, (Object)foundId);
    }

    @Test
    public void testRowkeyParsing() throws Exception {
        Document doc = MapRDBImpl.newDocument();
        doc.set("a", "xyz");
        doc.set("b", false);
        doc.set("c", 222);
        MapRDBTableImpl myTab = (MapRDBTableImpl)DBTests.createOrReplaceTable("myTab");
        myTab.insertOrReplace("k1", doc);
        myTab.flush();
        DocumentStream rs = myTab.find();
        for (DocumentReader reader : rs.documentReaders()) {
            this.checkIdField(reader, true);
        }
        myTab.setOption(Table.TableOption.EXCLUDEID, true);
        rs = myTab.find();
        for (DocumentReader reader : rs.documentReaders()) {
            this.checkIdField(reader, false);
        }
        myTab.close();
    }

    private void iterateOverDBDocumentReaderBase(DBDocumentReaderBase reader) {
        DocumentReader.EventType et = null;
        String fieldName = null;
        reader.next();
        ControlInfo ctlInfo = reader.getControlInfo();
        Assert.assertEquals((Object)true, (Object)ctlInfo.isCreate());
        while ((et = reader.next()) != null) {
            if (reader.inMap() && reader.getFieldName() != null) {
                fieldName = reader.getFieldName();
                if (et == DocumentReader.EventType.STRING) {
                    if (fieldName.equals("a")) {
                        Assert.assertEquals((Object)"xyz", (Object)reader.getString());
                    }
                } else if (et == DocumentReader.EventType.BOOLEAN && fieldName.equals("b")) {
                    Assert.assertEquals((Object)false, (Object)reader.getBoolean());
                }
            }
            if (et == DocumentReader.EventType.END_MAP || et == DocumentReader.EventType.END_ARRAY) continue;
            ctlInfo = reader.getControlInfo();
        }
    }

    @Test
    public void testBaseInterface() throws Exception {
        Document doc = MapRDBImpl.newDocument();
        doc.set("a", "xyz");
        doc.set("b", false);
        doc.set("c", 222);
        MapRDBTableImpl myTab = (MapRDBTableImpl)DBTests.createOrReplaceTable("myTab");
        myTab.insertOrReplace("k1", doc);
        myTab.flush();
        DocumentStream rs = myTab.find();
        for (DBDocumentReaderBase reader : rs.documentReaders()) {
            this.iterateOverDBDocumentReaderBase(reader);
        }
    }

    @Test
    public void testReaderFromDocumentImpl() throws Exception {
        Document doc = MapRDBImpl.newDocument();
        doc.set("a", "xyz");
        doc.set("b", false);
        doc.set("c", 222);
        MapRDBTableImpl myTab = (MapRDBTableImpl)DBTests.createOrReplaceTable("myTab");
        myTab.insertOrReplace("key1", doc);
        myTab.flush();
        DocumentStream rs = myTab.find();
        for (Document docFromTable : rs) {
            DBDocumentReaderBase reader = (DBDocumentReaderBase)docFromTable.asReader();
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)reader.next());
            Assert.assertEquals((Object)"_id", (Object)reader.getFieldName());
            Assert.assertEquals((Object)"key1", (Object)reader.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)reader.next());
            Assert.assertEquals((Object)"xyz", (Object)reader.getString());
            DBDocumentReaderBase newReader = (DBDocumentReaderBase)docFromTable.asReader();
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)newReader.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)newReader.next());
            Assert.assertEquals((Object)"_id", (Object)newReader.getFieldName());
            Assert.assertEquals((Object)"key1", (Object)newReader.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)newReader.next());
            Assert.assertEquals((Object)"xyz", (Object)newReader.getString());
        }
        myTab.close();
    }

    @Test
    public void testStreamReaderFull() throws Exception {
        try (InputStream testJson = this.getResourceStream("com/mapr/db/tests/json/test2.json");
             DocumentStream stream = Json.newDocumentStream((InputStream)testJson);){
            DBDocumentImpl dbDoc = RowcolCodec.getDBDocument((Document)((Document)stream.iterator().next()));
            ByteBuffer encoded = RowcolCodec.encode((Document)dbDoc);
            DBDocumentReader2 r = new DBDocumentReader2((Map)ImmutableMap.of((Object)0, (Object)encoded), (Map)ImmutableMap.of((Object)FieldPath.EMPTY, (Object)0), _ID, false);
            DocumentReader.EventType et = null;
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)et);
            Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
            Assert.assertEquals((Object)"id1", (Object)r.getString());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
            Assert.assertEquals((Object)"map", (Object)r.getFieldName());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)et);
            Assert.assertEquals((Object)"array", (Object)r.getFieldName());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)et);
            Assert.assertEquals((long)0L, (long)r.getArrayIndex());
            Assert.assertEquals((double)42.0, (double)r.getDouble(), (double)0.0);
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)et);
            Assert.assertEquals((long)1L, (long)r.getArrayIndex());
            Assert.assertEquals((Object)"open sesame", (Object)r.getString());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)et);
            Assert.assertEquals((long)2L, (long)r.getArrayIndex());
            Assert.assertEquals((double)3.14, (double)r.getDouble(), (double)0.0);
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.DATE, (Object)et);
            Assert.assertEquals((long)3L, (long)r.getArrayIndex());
            Assert.assertEquals((Object)"2015-01-21", (Object)r.getDate().toString());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
            Assert.assertEquals((long)4L, (long)r.getArrayIndex());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)et);
            Assert.assertEquals((Object)"nested", (Object)r.getFieldName());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)et);
            Assert.assertEquals((long)0L, (long)r.getArrayIndex());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)et);
            Assert.assertEquals((long)0L, (long)r.getArrayIndex());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
            Assert.assertEquals((long)1L, (long)r.getArrayIndex());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)et);
            Assert.assertEquals((long)1L, (long)r.getArrayIndex());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)et);
            Assert.assertEquals((long)2L, (long)r.getArrayIndex());
            Assert.assertEquals((double)0.0, (double)r.getDouble(), (double)0.0);
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)et);
            Assert.assertEquals((long)3L, (long)r.getArrayIndex());
            Assert.assertEquals((Object)"", (Object)r.getString());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)et);
            Assert.assertEquals((Object)"nested", (Object)r.getFieldName());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)et);
            Assert.assertEquals((long)4L, (long)r.getArrayIndex());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)et);
            Assert.assertEquals((Object)"array", (Object)r.getFieldName());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.BINARY, (Object)et);
            Assert.assertEquals((Object)"binary", (Object)r.getFieldName());
            Assert.assertEquals((Object)Values.parseBinary((String)"YWJjZA=="), (Object)r.getBinary());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.BOOLEAN, (Object)et);
            Assert.assertEquals((Object)"boolean", (Object)r.getFieldName());
            Assert.assertEquals((Object)true, (Object)r.getBoolean());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.LONG, (Object)et);
            Assert.assertEquals((Object)"byte", (Object)r.getFieldName());
            Assert.assertEquals((long)127L, (long)r.getLong());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.DATE, (Object)et);
            Assert.assertEquals((Object)"date", (Object)r.getFieldName());
            Assert.assertEquals((Object)"2012-10-20", (Object)r.getDate().toString());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)et);
            Assert.assertEquals((Object)"decimal", (Object)r.getFieldName());
            Assert.assertEquals((Object)"123456789012345678901234567890123456789012345678901.23456789", (Object)r.getString());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)et);
            Assert.assertEquals((Object)"double", (Object)r.getFieldName());
            Assert.assertEquals((double)Double.MAX_VALUE, (double)r.getDouble(), (double)0.0);
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)et);
            Assert.assertEquals((Object)"float", (Object)r.getFieldName());
            Assert.assertEquals((double)3.4028235, (double)r.getDouble(), (double)0.0);
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.LONG, (Object)et);
            Assert.assertEquals((Object)"int", (Object)r.getFieldName());
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)r.getLong());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)et);
            Assert.assertEquals((Object)"interval", (Object)r.getFieldName());
            Assert.assertEquals((double)1.728E8, (double)r.getDouble(), (double)0.0);
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.LONG, (Object)et);
            Assert.assertEquals((Object)"long", (Object)r.getFieldName());
            Assert.assertEquals((long)Long.MAX_VALUE, (long)r.getLong());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.NULL, (Object)et);
            Assert.assertEquals((Object)"null", (Object)r.getFieldName());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.LONG, (Object)et);
            Assert.assertEquals((Object)"short", (Object)r.getFieldName());
            Assert.assertEquals((long)32767L, (long)r.getLong());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)et);
            Assert.assertEquals((Object)"string", (Object)r.getFieldName());
            Assert.assertEquals((Object)"eureka", (Object)r.getString());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.TIME, (Object)et);
            Assert.assertEquals((Object)"time", (Object)r.getFieldName());
            Assert.assertEquals((Object)"07:42:46.123", (Object)r.getTime().toString());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.TIMESTAMP, (Object)et);
            Assert.assertEquals((Object)"timestamp", (Object)r.getFieldName());
            Assert.assertEquals((Object)"2012-10-20T14:42:46.123Z", (Object)r.getTimestamp().toString());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)et);
            Assert.assertEquals((Object)"map", (Object)r.getFieldName());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)et);
            Assert.assertNull((Object)r.getFieldName());
            et = r.next();
            Assert.assertNull((Object)et);
        }
    }

    @Test
    public void testArrayIndexProjection() throws Exception {
        Document doc = MapRDBImpl.newDocument();
        doc.set("map.m", "abcd");
        doc.setArray("map.array", new String[]{"abc", "xyz"});
        doc.setArray("map.array[2]", new int[]{1111, 2222, 3333, 4444, 5555});
        Table myTab = DBTests.createOrReplaceTable("mytab");
        myTab.insertOrReplace("k1", doc);
        myTab.flush();
        DocumentStream rs = myTab.find(new String[]{"map.array[1]", "map.array[2][3]"});
        Iterator iter = rs.documentReaders().iterator();
        DocumentReader r = (DocumentReader)iter.next();
        DocumentReader.EventType et = null;
        et = r.next();
        Assert.assertNotNull((Object)et);
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
        et = r.next();
        Assert.assertNotNull((Object)et);
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)et);
        Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
        Assert.assertEquals((Object)"k1", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"map", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
        Assert.assertEquals((Object)"array", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)r.getArrayIndex());
        Assert.assertEquals((Object)"xyz", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
        Assert.assertEquals((long)2L, (long)r.getArrayIndex());
        Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
        Assert.assertEquals((long)3L, (long)r.getArrayIndex());
        Assert.assertEquals((long)4444L, (long)r.getInt());
        Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertNull((Object)r.next());
    }

    @Test
    public void testArrayIndexProjection2() throws Exception {
        Table table = DBTests.createOrReplaceTable("mytab");
        table.setOption(Table.TableOption.BUFFERWRITE, true);
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        Document doc = MapRDBImpl.newDocument().set("arr", list);
        table.insertOrReplace("rkey1", doc);
        table.flush();
        Document findRes = table.findById("rkey1", new String[]{"arr[2]"});
        Document result = MapRDBImpl.newDocument((Map)findRes.asMap());
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        list2.add(null);
        list2.add(null);
        list2.add(2);
        Document expectedDoc = MapRDBImpl.newDocument().set("_id", "rkey1").set("arr", list2);
        Assert.assertEquals((Object)expectedDoc, (Object)result);
        table.close();
        DBTests.deleteTables("mytab");
    }

    @Test
    public void testEmptyArray() throws Exception {
        Table table = DBTests.createOrReplaceTable("mytab");
        table.setOption(Table.TableOption.BUFFERWRITE, true);
        ArrayList list = new ArrayList();
        Document doc = MapRDBImpl.newDocument().set("arr", list);
        table.insertOrReplace("rkey1", doc);
        table.flush();
        Document findRes = table.findById("rkey1", new String[]{"arr"});
        Document result = MapRDBImpl.newDocument((Map)findRes.asMap());
        Document expectedDoc = MapRDBImpl.newDocument().set("_id", "rkey1").set("arr", list);
        Assert.assertEquals((Object)expectedDoc, (Object)result);
        table.close();
        DBTests.deleteTables("mytab");
    }

    @Test
    public void testMultiCfProjection() throws Exception {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("cf1", "l0");
        cfPath.put("cf2", "s1.s2");
        cfPath.put("cf3", "s1.s2.l2");
        Table table = DBTests.createOrReplaceTable("mytab", cfPath);
        Document doc1 = MapRDB.newDocument().set("l0.a1", "str1").set("s1.l1", "str2").set("s1.s2.l2", "str3");
        table.insertOrReplace("k0", doc1);
        table.flush();
        try (DocumentStream records = table.find(new String[]{"s1.s2.l2", "s1.l1", "l0"});){
            for (DocumentReader reader : records.documentReaders()) {
                DocumentBuilder builder = MapRDB.newDocumentBuilder();
                JsonUtils.addToMap((DocumentReader)reader, (DocumentBuilder)builder);
                Document builtDoc = builder.getDocument();
                Assert.assertEquals((Object)doc1.setId("k0"), (Object)builtDoc);
            }
        }
        table.close();
        DBTests.deleteTables("mytab");
    }
}

