/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.ojai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mapr.db.ojai.DBValueBuilder;
import com.mapr.tests.annotations.SimpleTest;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Value;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

@Category(value={SimpleTest.class})
public class TestDBValueBuilder {
    @Test
    public void testDBValueBuilder() {
        Value value = null;
        DBValueBuilder valueBuilder = DBValueBuilder.INSTANCE;
        value = valueBuilder.newNullValue();
        Assert.assertEquals((Object)Value.Type.NULL, (Object)value.getType());
        boolean bool = true;
        value = valueBuilder.newValue(bool);
        Assert.assertEquals((Object)Value.Type.BOOLEAN, (Object)value.getType());
        Assert.assertEquals((Object)bool, (Object)value.getBoolean());
        String string = "string";
        value = valueBuilder.newValue(string);
        Assert.assertEquals((Object)Value.Type.STRING, (Object)value.getType());
        Assert.assertEquals((Object)string, (Object)value.getString());
        value = valueBuilder.newValue((byte)127);
        Assert.assertEquals((Object)Value.Type.BYTE, (Object)value.getType());
        Assert.assertEquals((long)127L, (long)value.getByte());
        value = valueBuilder.newValue((short)Short.MAX_VALUE);
        Assert.assertEquals((Object)Value.Type.SHORT, (Object)value.getType());
        Assert.assertEquals((long)32767L, (long)value.getShort());
        value = valueBuilder.newValue(Integer.MAX_VALUE);
        Assert.assertEquals((Object)Value.Type.INT, (Object)value.getType());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)value.getInt());
        value = valueBuilder.newValue(Long.MAX_VALUE);
        Assert.assertEquals((Object)Value.Type.LONG, (Object)value.getType());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)value.getLong());
        value = valueBuilder.newValue(Float.MAX_VALUE);
        Assert.assertEquals((Object)Value.Type.FLOAT, (Object)value.getType());
        Assert.assertEquals((float)Float.MAX_VALUE, (float)value.getFloat(), (float)0.0f);
        value = valueBuilder.newValue(Double.MAX_VALUE);
        Assert.assertEquals((Object)Value.Type.DOUBLE, (Object)value.getType());
        Assert.assertEquals((double)Double.MAX_VALUE, (double)value.getDouble(), (double)0.0);
        value = valueBuilder.newValue(BigDecimal.ONE);
        Assert.assertEquals((Object)Value.Type.DECIMAL, (Object)value.getType());
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)value.getDecimal());
        ODate date = ODate.fromDaysSinceEpoch((int)1);
        value = valueBuilder.newValue(date);
        Assert.assertEquals((Object)Value.Type.DATE, (Object)value.getType());
        Assert.assertEquals((Object)date, (Object)value.getDate());
        OTime time = OTime.fromMillisOfDay((int)0);
        value = valueBuilder.newValue(time);
        Assert.assertEquals((Object)Value.Type.TIME, (Object)value.getType());
        Assert.assertEquals((Object)time, (Object)value.getTime());
        OTimestamp timestamp = OTimestamp.parse((String)"2015-06-29T12:33:22.000Z");
        value = valueBuilder.newValue(timestamp);
        Assert.assertEquals((Object)Value.Type.TIMESTAMP, (Object)value.getType());
        Assert.assertEquals((Object)timestamp, (Object)value.getTimestamp());
        OInterval interval = new OInterval(0L);
        value = valueBuilder.newValue(interval);
        Assert.assertEquals((Object)Value.Type.INTERVAL, (Object)value.getType());
        Assert.assertEquals((Object)interval, (Object)value.getInterval());
        byte[] byteArray = new byte[]{0};
        value = valueBuilder.newValue(byteArray);
        Assert.assertEquals((Object)Value.Type.BINARY, (Object)value.getType());
        Assert.assertEquals((Object)ByteBuffer.wrap(byteArray), (Object)value.getBinary());
        ByteBuffer byteBuff = ByteBuffer.allocate(0);
        value = valueBuilder.newValue(byteBuff);
        Assert.assertEquals((Object)Value.Type.BINARY, (Object)value.getType());
        Assert.assertEquals((Object)byteBuff, (Object)value.getBinary());
        ImmutableMap map = ImmutableMap.of((Object)"key", (Object)25);
        value = valueBuilder.newValue((Map)map);
        Assert.assertEquals((Object)Value.Type.MAP, (Object)value.getType());
        Assert.assertEquals((Object)map, (Object)value.getMap());
        ImmutableList list = ImmutableList.of((Object)1, (Object)"abc", (Object)2.5, (Object)true);
        value = valueBuilder.newValue((List)list);
        Assert.assertEquals((Object)Value.Type.ARRAY, (Object)value.getType());
        Assert.assertEquals((Object)list, (Object)value.getList());
    }
}

