/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.condition;

import com.mapr.db.Table;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.tests.utils.Datasets;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.ArrayList;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.store.QueryCondition;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestDateTimeCastingWithCondition
extends BaseTest
implements Datasets {
    private static final Logger _logger = LoggerFactory.getLogger(TestDateTimeCastingWithCondition.class);
    private static final String TABLE_NAME = "testtable-testcasting";
    static Table table = null;

    @BeforeClass
    public static void setUpBeforeClass() throws IOException {
        int i;
        table = DBTests.createOrReplaceTable(TABLE_NAME);
        int numDocuments = DATE_STRINGS.length;
        for (i = 0; i < 3; ++i) {
            Document r = MapRDBImpl.newDocument();
            r.set("business_name", "Biz1").set("dateOfService", ODate.parse((String)DATE_STRINGS[i])).set("timeofService", TIMES[i]).set("datewithtz", DATESINTZ[i]).set("ts", OTimestamp.parse((String)DATE_TIME_TS[i])).set("datetimeWithTZ", OTime.parse((String)DATE_TIME_IN_TZ[i]));
            table.insertOrReplace("k" + i, r);
        }
        Document r3 = MapRDBImpl.newDocument().set("business_name", "Biz1").set("dateOfService", ODate.parse((String)DATE_STRINGS[i])).set("timeofService", TIMES[i]).set("datewithtz", DATESINTZ[i]).set("ts", ODate.parse((String)DATE_TIME_TS[i])).set("datetimeWithTZ", ODate.parse((String)DATE_TIME_IN_TZ[i]));
        table.insertOrReplace("k" + i, r3);
        Document r4 = MapRDBImpl.newDocument().set("business_name", "Biz1").set("dateOfService", ODate.parse((String)DATE_STRINGS[++i])).set("timeofService", TIMES[i]).set("datewithtz", DATESINTZ[i]).set("ts", OTime.parse((String)DATE_TIME_TS[i])).set("datetimeWithTZ", ODate.parse((String)DATE_TIME_IN_TZ[i]));
        table.insertOrReplace("k" + i, r4);
        table.flush();
        _logger.info("{} documents inserted.", (Object)numDocuments);
    }

    @AfterClass
    public static void cleanupAfterClass() throws Exception {
        if (table != null) {
            table.close();
            DBTests.deleteTables(TABLE_NAME);
        }
    }

    @Test
    public void test0() throws Exception {
        ConditionImpl cond = MapRDBImpl.newCondition().is("dateOfService", QueryCondition.Op.GREATER_OR_EQUAL, ODate.parse((String)"2015-01-01")).build();
        DocumentStream docs = table.find((QueryCondition)cond);
        Assert.assertNotNull((Object)docs);
        int count = 0;
        for (Document doc : docs) {
            ++count;
            Assert.assertEquals((long)2015L, (long)doc.getDate("dateOfService").getYear());
            Assert.assertEquals((long)12L, (long)doc.getDate("dateOfService").getMonth());
            Assert.assertEquals((long)12L, (long)doc.getDate("dateOfService").getDayOfMonth());
            Assert.assertEquals((Object)"k4", (Object)doc.getId().getString());
            _logger.info("Returned document : " + doc);
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void test1() throws Exception {
        ConditionImpl cond = MapRDBImpl.newCondition().is("timeofService", QueryCondition.Op.LESS, OTime.parse((String)"10:40:00")).build();
        DocumentStream docs = table.find((QueryCondition)cond);
        String[] keys = new String[]{"k0", "k1"};
        int count = 0;
        for (Document doc : docs) {
            Assert.assertEquals((Object)keys[count], (Object)doc.getId().getString());
            ++count;
            _logger.info("Returned document : " + doc);
        }
        Assert.assertEquals((long)keys.length, (long)count);
    }

    @Test
    public void test2() throws Exception {
        ConditionImpl cond = MapRDBImpl.newCondition().is("ts", QueryCondition.Op.GREATER_OR_EQUAL, OTimestamp.parse((String)"2008-05-05T07:32:55Z")).build();
        DocumentStream docs = table.find((QueryCondition)cond);
        String[] keys = new String[]{"k2"};
        int count = 0;
        for (Document doc : docs) {
            Assert.assertEquals((Object)keys[count], (Object)doc.getId().getString());
            ++count;
            _logger.info("Returned document : " + doc);
        }
        Assert.assertEquals((long)keys.length, (long)count);
    }

    @Test
    public void test3() throws Exception {
        ConditionImpl cond = MapRDBImpl.newCondition().and().is("ts", QueryCondition.Op.GREATER_OR_EQUAL, OTimestamp.parse((String)"2006-06-06T00:01:02Z")).is("ts", QueryCondition.Op.LESS_OR_EQUAL, OTimestamp.parse((String)"2012-01-01T00:00:00Z")).close().build();
        DocumentStream docs = table.find((QueryCondition)cond);
        String[] keys = new String[]{"k1", "k2"};
        int count = 0;
        for (Document doc : docs) {
            Assert.assertEquals((Object)keys[count], (Object)doc.getId().getString());
            ++count;
            _logger.info("Returned document : " + doc);
        }
        Assert.assertEquals((long)keys.length, (long)count);
    }

    @Test
    public void test4() throws Exception {
        ConditionImpl cond = MapRDBImpl.newCondition().is("ts", QueryCondition.Op.GREATER_OR_EQUAL, OTime.parse((String)"11:30:00")).build();
        DocumentStream docs = table.find((QueryCondition)cond);
        String[] keys = new String[]{"k4"};
        int count = 0;
        for (Document doc : docs) {
            Assert.assertEquals((Object)keys[count], (Object)doc.getId().getString());
            ++count;
            _logger.info("Returned document : " + doc);
        }
        Assert.assertEquals((long)keys.length, (long)count);
    }

    @Test
    public void test5() throws Exception {
        ConditionImpl cond = MapRDBImpl.newCondition().and().is("dateOfService", QueryCondition.Op.GREATER_OR_EQUAL, ODate.parse((String)"2012-01-01")).is("dateOfService", QueryCondition.Op.LESS, ODate.parse((String)"2014-01-05")).close().build();
        DocumentStream docs = table.find((QueryCondition)cond);
        String[] keys = new String[]{"k0"};
        int count = 0;
        for (Document doc : docs) {
            Assert.assertEquals((Object)keys[count], (Object)doc.getId().getString());
            ++count;
            _logger.info("Returned document : " + doc);
        }
        Assert.assertEquals((long)keys.length, (long)count);
    }

    @Test
    public void test6() throws Exception {
        ConditionImpl cond = MapRDBImpl.newCondition().or().is("dateOfService", QueryCondition.Op.EQUAL, ODate.parse((String)"2012-10-12")).is("ts", QueryCondition.Op.EQUAL, OTime.parse((String)"11:45:00")).close().build();
        DocumentStream docs = table.find((QueryCondition)cond);
        String[] keys = new String[]{"k0", "k4"};
        int count = 0;
        for (Document doc : docs) {
            Assert.assertEquals((Object)keys[count], (Object)doc.getId().getString());
            ++count;
            _logger.info("Returned document : " + doc);
        }
        Assert.assertEquals((long)keys.length, (long)count);
    }

    @Test
    public void test7() throws Exception {
        ConditionImpl cond = MapRDBImpl.newCondition();
        cond.is("datewithtz", QueryCondition.Op.GREATER_OR_EQUAL, ODate.parse((String)"2016-01-01")).build();
        DocumentStream s = table.find((QueryCondition)cond);
        String[] keys = new String[]{"k0", "k1", "k3"};
        int count = 0;
        for (Document d : s) {
            Assert.assertEquals((Object)keys[count], (Object)d.getId().getString());
            ++count;
        }
        Assert.assertEquals((long)keys.length, (long)count);
    }

    @Test
    public void test8() throws Exception {
        ConditionImpl cond = MapRDBImpl.newCondition();
        cond.is("datetimeWithTZ", QueryCondition.Op.GREATER_OR_EQUAL, ODate.parse((String)"2016-07-01")).build();
        DocumentStream s = table.find((QueryCondition)cond);
        String[] keys = new String[]{"k4"};
        int count = 0;
        for (Document d : s) {
            Assert.assertEquals((Object)keys[count], (Object)d.getId().getString());
            ++count;
        }
        Assert.assertEquals((long)keys.length, (long)count);
    }

    @Test
    public void test9() throws Exception {
        ArrayList<ODate> tsList = new ArrayList<ODate>();
        tsList.add(ODate.parse((String)"2014-02-10"));
        tsList.add(ODate.parse((String)"2015-12-12"));
        ConditionImpl cond = MapRDBImpl.newCondition();
        cond.in("dateOfService", tsList).build();
        DocumentStream s = table.find((QueryCondition)cond);
        String[] keys = new String[]{"k2", "k4"};
        int count = 0;
        for (Document d : s) {
            Assert.assertEquals((Object)keys[count], (Object)d.getId().getString());
            ++count;
        }
        Assert.assertEquals((long)keys.length, (long)count);
    }

    @Test
    public void test10() throws Exception {
        ArrayList<ODate> tsList = new ArrayList<ODate>();
        tsList.add(ODate.parse((String)"2014-02-12"));
        tsList.add(ODate.parse((String)"2015-12-12"));
        ConditionImpl cond = MapRDBImpl.newCondition();
        cond.notIn("dateOfService", tsList).build();
        DocumentStream s = table.find((QueryCondition)cond);
        String[] keys = new String[]{"k0", "k1", "k2"};
        int count = 0;
        for (Document d : s) {
            Assert.assertEquals((Object)keys[count], (Object)d.getId().getString());
            ++count;
        }
        Assert.assertEquals((long)keys.length, (long)count);
    }

    @Test
    public void test11() throws Exception {
        ArrayList<OTime> tsList = new ArrayList<OTime>();
        tsList.add(OTime.parse((String)"09:30:00"));
        tsList.add(OTime.parse((String)"04:00:00"));
        ConditionImpl cond = MapRDBImpl.newCondition();
        cond.notIn("timeofService", tsList).build();
        DocumentStream s = table.find((QueryCondition)cond);
        String[] keys = new String[]{"k1", "k2", "k3", "k4"};
        int count = 0;
        for (Document d : s) {
            Assert.assertEquals((Object)keys[count], (Object)d.getId().getString());
            ++count;
        }
        Assert.assertEquals((long)keys.length, (long)count);
    }
}

