/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.admin;

import com.mapr.db.FamilyDescriptor;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.exceptions.FamilyExistsException;
import com.mapr.db.exceptions.FamilyNotFoundException;
import com.mapr.db.exceptions.OpNotPermittedException;
import com.mapr.db.exceptions.TableExistsException;
import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.FieldPath;

@Category(value={ClusterTest.class})
public class TestAdmin
extends BaseTest {
    static AdminImpl testAdmin;
    private static final Path TABLE_1;
    private static final FieldPath A_B_C;
    private static final FieldPath X_Y_Z;
    private static final TableDescriptor TABLE_DESC_1;

    @BeforeClass
    public static void setupTestAdmin() throws IOException {
        testAdmin = (AdminImpl)MapRDBImpl.newAdmin();
    }

    @AfterClass
    public static void cleanupTestAdmin() throws Exception {
        if (testAdmin != null) {
            testAdmin.close();
        }
    }

    @Before
    public void beforeTest() {
        DBTests.getTestRoot();
    }

    @After
    public void afterTest() {
        try {
            DBTests.rmdir(DBTests.getTestRoot());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void test_CreateTable() throws Exception {
        Table table = testAdmin.createTable(TABLE_DESC_1);
        table.close();
        TableDescriptor desc = testAdmin.getTableDescriptor(TABLE_1);
        Assert.assertEquals((Object)TABLE_1, (Object)desc.getPath());
        Assert.assertEquals((long)512L, (long)desc.getSplitSize());
        Assert.assertFalse((boolean)desc.isAutoSplit());
        Assert.assertTrue((boolean)desc.isBulkLoad());
        List families = desc.getFamilies();
        Assert.assertEquals((long)2L, (long)families.size());
        FamilyDescriptor family = (FamilyDescriptor)families.get(0);
        Assert.assertEquals((Object)"default", (Object)family.getName());
        Assert.assertEquals((Object)FieldPath.EMPTY, (Object)family.getJsonFieldPath());
        Assert.assertEquals((Object)FamilyDescriptor.Compression.ZLIB, (Object)family.getCompression());
        Assert.assertFalse((boolean)family.isInMemory());
        family = (FamilyDescriptor)families.get(1);
        Assert.assertEquals((Object)"f", (Object)family.getName());
        Assert.assertEquals((Object)X_Y_Z, (Object)family.getJsonFieldPath());
        Assert.assertEquals((Object)FamilyDescriptor.Compression.None, (Object)family.getCompression());
        Assert.assertTrue((boolean)family.isInMemory());
        desc.setPath(DBTests.getTablePath("table2")).setBulkLoad(false);
        testAdmin.createTable(desc);
    }

    @Test
    public void test_AlterTable() throws Exception {
        try (Table table = testAdmin.createTable(TABLE_DESC_1);){
            TableDescriptor desc = testAdmin.getTableDescriptor(TABLE_1);
            desc.setBulkLoad(false);
            testAdmin.alterTable(desc);
            try {
                desc = testAdmin.getTableDescriptor(TABLE_1);
                desc.setBulkLoad(true);
                testAdmin.alterTable(desc);
                Assert.fail();
            }
            catch (OpNotPermittedException opNotPermittedException) {
                // empty catch block
            }
            try {
                desc = testAdmin.getTableDescriptor(TABLE_1);
                desc.addFamily(MapRDBImpl.newFamilyDescriptor().setName("g").setCompression(FamilyDescriptor.Compression.ZLIB).setJsonFieldPath("p.q.r"));
                testAdmin.alterTable(desc);
                Assert.fail();
            }
            catch (OpNotPermittedException opNotPermittedException) {
                // empty catch block
            }
            try {
                desc.setPath(DBTests.getTablePath("" + Math.random()));
                testAdmin.alterTable(desc);
                Assert.fail();
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            desc = testAdmin.getTableDescriptor(TABLE_1);
            desc.setAutoSplit(true);
            desc.setSplitSize(8192L);
            testAdmin.alterTable(desc);
        }
    }

    @Test
    public void test_AddRemoveFamily() throws Exception {
        try (Table table = testAdmin.createTable(TABLE_DESC_1);){
            TableDescriptor desc = testAdmin.getTableDescriptor(TABLE_1);
            Assert.assertEquals((long)2L, (long)desc.getFamilies().size());
            FamilyDescriptor fdesc = MapRDBImpl.newFamilyDescriptor((String)"f", (FieldPath)X_Y_Z);
            try {
                testAdmin.addFamily(TABLE_1, fdesc);
                Assert.fail();
            }
            catch (FamilyExistsException familyExistsException) {
                // empty catch block
            }
            try {
                testAdmin.addFamily(DBTests.getTablePath("" + Math.random()), fdesc);
                Assert.fail();
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            fdesc.setName("g");
            try {
                testAdmin.addFamily(TABLE_1, fdesc);
                Assert.fail();
            }
            catch (FamilyExistsException familyExistsException) {
                // empty catch block
            }
            fdesc.setJsonFieldPath(A_B_C);
            testAdmin.addFamily(TABLE_1, fdesc);
            try {
                Assert.assertFalse((boolean)testAdmin.deleteFamily(TABLE_1, "h"));
                Assert.fail((String)"Should get error that column family delete is not permitted");
            }
            catch (OpNotPermittedException opNotPermittedException) {
                // empty catch block
            }
            Assert.assertFalse((boolean)testAdmin.deleteFamily(DBTests.getTablePath("" + Math.random()), "h"));
            try {
                Assert.assertTrue((boolean)testAdmin.deleteFamily(TABLE_1, "g"));
                Assert.fail((String)"Should get error that column family delete is not permitted");
            }
            catch (OpNotPermittedException opNotPermittedException) {
                // empty catch block
            }
        }
    }

    @Test
    public void test_AlterFamily() throws Exception {
        try (Table table = testAdmin.createTable(TABLE_DESC_1);){
            TableDescriptor desc = testAdmin.getTableDescriptor(TABLE_1);
            FamilyDescriptor fdesc = (FamilyDescriptor)desc.getFamilies().get(1);
            try {
                testAdmin.alterFamily(TABLE_1, "g", fdesc);
                Assert.fail();
            }
            catch (FamilyNotFoundException familyNotFoundException) {
                // empty catch block
            }
            fdesc.setJsonFieldPath(A_B_C);
            try {
                testAdmin.alterFamily(TABLE_1, "f", fdesc);
                Assert.fail();
            }
            catch (OpNotPermittedException opNotPermittedException) {
                // empty catch block
            }
            try {
                testAdmin.alterFamily(DBTests.getTablePath("" + Math.random()), "g", fdesc);
                Assert.fail();
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            fdesc.setJsonFieldPath(X_Y_Z).setInMemory(false).setCompression(FamilyDescriptor.Compression.ZLIB).setName("g");
            testAdmin.alterFamily(TABLE_1, "f", fdesc);
            desc = testAdmin.getTableDescriptor(TABLE_1);
            Assert.assertNull((Object)desc.getFamily("f"));
            FamilyDescriptor newFamilyDesc = desc.getFamily("g");
            Assert.assertNotNull((Object)newFamilyDesc);
            Assert.assertEquals((Object)FamilyDescriptor.Compression.ZLIB, (Object)newFamilyDesc.getCompression());
            Assert.assertEquals((Object)false, (Object)newFamilyDesc.isInMemory());
        }
    }

    @Test
    public void test_ListTables() throws TableExistsException, IOException {
        int i;
        for (i = 1; i <= 10; ++i) {
            testAdmin.createTable(DBTests.getTablePath("ktp29J" + i));
        }
        for (i = 0; i < 5; ++i) {
            testAdmin.createTable(DBTests.getTablePath(i + "ktp29J_" + i));
        }
        testAdmin.createTable(DBTests.getTablePath("bangalore"));
        testAdmin.createTable(DBTests.getTablePath("london"));
        testAdmin.createTable(DBTests.getTablePath("tokyo"));
        testAdmin.createTable(DBTests.getTablePath("paris"));
        testAdmin.createTable(DBTests.getTablePath("just_some_table"));
        DBTests.maprfs().create(DBTests.getTablePath("just_some_file")).close();
        DBTests.maprfs().create(DBTests.getTablePath("some_other_file")).close();
        DBTests.maprfs().create(DBTests.getTablePath("more_files_1")).close();
        DBTests.maprfs().create(DBTests.getTablePath("more_files_2")).close();
        List tables = testAdmin.listTables(DBTests.getTestRoot());
        Assert.assertEquals((long)20L, (long)tables.size());
        tables = testAdmin.listTables(DBTests.getTestRoot() + "/ktp29J?");
        Assert.assertEquals((long)9L, (long)tables.size());
        tables = testAdmin.listTables(DBTests.getTestRoot() + "/ktp29J*");
        Assert.assertEquals((long)10L, (long)tables.size());
        tables = testAdmin.listTables(DBTests.getTestRoot() + "/?ktp29J?");
        Assert.assertEquals((long)0L, (long)tables.size());
        tables = testAdmin.listTables(DBTests.getTestRoot() + "/?ktp29J*");
        Assert.assertEquals((long)5L, (long)tables.size());
        tables = testAdmin.listTables(DBTests.getTestRoot() + "/*ktp29J*");
        Assert.assertEquals((long)15L, (long)tables.size());
        tables = testAdmin.listTables(DBTests.getTestRoot() + "/bangalore");
        Assert.assertEquals((long)1L, (long)tables.size());
        tables = testAdmin.listTables(DBTests.getTestRoot() + "/bangalore*");
        Assert.assertEquals((long)1L, (long)tables.size());
        tables = testAdmin.listTables(DBTests.getTestRoot() + "/bang*");
        Assert.assertEquals((long)1L, (long)tables.size());
        tables = testAdmin.listTables(DBTests.getTestRoot() + "/just_some_file");
        Assert.assertEquals((long)0L, (long)tables.size());
        tables = testAdmin.listTables(DBTests.getTestRoot() + "/just_some_*");
        Assert.assertEquals((long)1L, (long)tables.size());
    }

    static {
        TABLE_1 = DBTests.getTablePath("table1");
        A_B_C = FieldPath.parseFrom((String)"a.b.c");
        X_Y_Z = FieldPath.parseFrom((String)"x.y.z");
        TABLE_DESC_1 = MapRDBImpl.newTableDescriptor((Path)TABLE_1).setSplitSize(512L).setAutoSplit(false).setBulkLoad(true);
        FamilyDescriptor familyDesc = MapRDBImpl.newDefaultFamilyDescriptor().setCompression(FamilyDescriptor.Compression.ZLIB);
        TABLE_DESC_1.addFamily(familyDesc);
        familyDesc = MapRDBImpl.newFamilyDescriptor().setName("f").setJsonFieldPath(X_Y_Z).setInMemory(true).setCompression(FamilyDescriptor.Compression.None);
        TABLE_DESC_1.addFamily(familyDesc);
    }
}

