/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kudu;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.kudu.KuduStoragePlugin;
import org.apache.drill.exec.store.kudu.KuduStoragePluginConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="kudu-tablet-scan")
public class KuduSubScan
extends AbstractBase
implements SubScan {
    static final Logger logger = LoggerFactory.getLogger(KuduSubScan.class);
    @JsonProperty
    public final KuduStoragePluginConfig storage;
    private final KuduStoragePlugin kuduStoragePlugin;
    private final List<KuduSubScanSpec> tabletScanSpecList;
    private final List<SchemaPath> columns;

    @JsonCreator
    public KuduSubScan(@JacksonInject StoragePluginRegistry registry, @JsonProperty(value="storage") StoragePluginConfig storage, @JsonProperty(value="tabletScanSpecList") LinkedList<KuduSubScanSpec> tabletScanSpecList, @JsonProperty(value="columns") List<SchemaPath> columns) throws ExecutionSetupException {
        super((String)null);
        this.kuduStoragePlugin = (KuduStoragePlugin)registry.getPlugin(storage);
        this.tabletScanSpecList = tabletScanSpecList;
        this.storage = (KuduStoragePluginConfig)storage;
        this.columns = columns;
    }

    public KuduSubScan(KuduStoragePlugin plugin, KuduStoragePluginConfig config, List<KuduSubScanSpec> tabletInfoList, List<SchemaPath> columns) {
        super((String)null);
        this.kuduStoragePlugin = plugin;
        this.storage = config;
        this.tabletScanSpecList = tabletInfoList;
        this.columns = columns;
    }

    public List<KuduSubScanSpec> getTabletScanSpecList() {
        return this.tabletScanSpecList;
    }

    @JsonIgnore
    public KuduStoragePluginConfig getStorageConfig() {
        return this.storage;
    }

    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    public boolean isExecutable() {
        return false;
    }

    @JsonIgnore
    public KuduStoragePlugin getStorageEngine() {
        return this.kuduStoragePlugin;
    }

    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return (T)physicalVisitor.visitSubScan((SubScan)this, value);
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new KuduSubScan(this.kuduStoragePlugin, this.storage, this.tabletScanSpecList, this.columns);
    }

    public Iterator<PhysicalOperator> iterator() {
        return Iterators.emptyIterator();
    }

    public int getOperatorType() {
        return 33;
    }

    public static class KuduSubScanSpec {
        private final String tableName;
        private final byte[] startKey;
        private final byte[] endKey;

        @JsonCreator
        public KuduSubScanSpec(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="startKey") byte[] startKey, @JsonProperty(value="endKey") byte[] endKey) {
            this.tableName = tableName;
            this.startKey = startKey;
            this.endKey = endKey;
        }

        public String getTableName() {
            return this.tableName;
        }

        public byte[] getStartKey() {
            return this.startKey;
        }

        public byte[] getEndKey() {
            return this.endKey;
        }
    }
}

