/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.Value;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Parsable<RECORD> {
    private static final Logger LOG = LoggerFactory.getLogger(Parsable.class);
    private final Parser<RECORD> parser;
    private final RECORD record;
    private final Map<String, ParsedField> cache = new TreeMap<String, ParsedField>();
    private final Set<String> needed;
    private final Set<String> usefulIntermediates;
    private final Set<ParsedField> toBeParsed = new HashSet<ParsedField>();
    private final Map<String, Set<String>> typeRemappings;

    public Parsable(Parser<RECORD> parser, RECORD record, Map<String, Set<String>> typeRemappings) {
        this.parser = parser;
        this.record = record;
        this.typeRemappings = typeRemappings;
        this.needed = parser.getNeeded();
        this.usefulIntermediates = parser.getUsefulIntermediateFields();
    }

    public void setRootDissection(String type, String value) {
        LOG.debug("Got root dissection: type={}", (Object)type);
        ParsedField parsedfield = new ParsedField(type, "", value);
        this.cache.put(parsedfield.getId(), parsedfield);
        this.toBeParsed.add(parsedfield);
    }

    public void addDissection(String base, String type, String name, Long value) throws DissectionFailure {
        LOG.debug("Got new (Long) dissection: base=" + base + "; type=" + type + "; name=\"" + name + "\"");
        this.addDissection(base, type, name, new Value(value), false);
    }

    public void addDissection(String base, String type, String name, Double value) throws DissectionFailure {
        LOG.debug("Got new (Double) dissection: base=" + base + "; type=" + type + "; name=\"" + name + "\"");
        this.addDissection(base, type, name, new Value(value), false);
    }

    public void addDissection(String base, String type, String name, String value) throws DissectionFailure {
        LOG.debug("Got new (String) dissection: base=" + base + "; type=" + type + "; name=\"" + name + "\"");
        this.addDissection(base, type, name, new Value(value), false);
    }

    public void addDissection(String base, String type, String name, Value value) throws DissectionFailure {
        LOG.debug("Got new (Value) dissection: base=" + base + "; type=" + type + "; name=\"" + name + "\"");
        this.addDissection(base, type, name, value, false);
    }

    private void addDissection(String base, String type, String name, Value value, boolean recursion) throws DissectionFailure {
        String neededWildCardName;
        String completeName;
        if (base.isEmpty()) {
            completeName = name;
            neededWildCardName = type + ':' + "*";
        } else {
            completeName = base + '.' + name;
            neededWildCardName = type + ':' + base + ".*";
        }
        String neededName = type + ':' + completeName;
        if (!recursion && this.typeRemappings.containsKey(completeName)) {
            Set<String> typeRemappingSet = this.typeRemappings.get(completeName);
            for (String typeRemapping : typeRemappingSet) {
                if (type.equals(typeRemapping)) {
                    throw new DissectionFailure("[Type Remapping] Trying to map to the same type (mapping definition bug!):  base=" + base + " type=" + type + " name=" + name);
                }
                this.addDissection(base, typeRemapping, name, value, true);
            }
        }
        ParsedField parsedfield = new ParsedField(type, completeName, value);
        if (this.usefulIntermediates.contains(completeName)) {
            this.cache.put(parsedfield.getId(), parsedfield);
            this.toBeParsed.add(parsedfield);
        }
        if (this.needed.contains(neededName)) {
            this.parser.store(this.record, neededName, neededName, value);
        }
        if (this.needed.contains(neededWildCardName)) {
            this.parser.store(this.record, neededWildCardName, neededName, value);
        }
    }

    public ParsedField getParsableField(String type, String name) {
        return this.cache.get(ParsedField.makeId(type, name));
    }

    public RECORD getRecord() {
        return this.record;
    }

    public void setAsParsed(ParsedField parsedField) {
        this.toBeParsed.remove(parsedField);
    }

    public Set<ParsedField> getToBeParsed() {
        return this.toBeParsed;
    }
}

