/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.jdbc.JDBCStatsUtils;

public class JDBCStatsAggregator
implements StatsAggregator {
    private Connection conn;
    private String connectionString;
    private Configuration hiveconf;
    private Task<?> sourceTask;
    private final Map<String, PreparedStatement> columnMapping;
    private final Log LOG = LogFactory.getLog((String)this.getClass().getName());
    private int timeout = 30;
    private final String comment = "Hive stats aggregation: " + this.getClass().getName();
    private int maxRetries;
    private long waitWindow;
    private final Random r;

    public JDBCStatsAggregator() {
        this.columnMapping = new HashMap<String, PreparedStatement>();
        this.r = new Random();
    }

    @Override
    public boolean connect(Configuration hiveconf, Task sourceTask) {
        this.hiveconf = hiveconf;
        this.timeout = (int)HiveConf.getTimeVar(hiveconf, HiveConf.ConfVars.HIVE_STATS_JDBC_TIMEOUT, TimeUnit.SECONDS);
        this.connectionString = HiveConf.getVar(hiveconf, HiveConf.ConfVars.HIVESTATSDBCONNECTIONSTRING);
        String driver = HiveConf.getVar(hiveconf, HiveConf.ConfVars.HIVESTATSJDBCDRIVER);
        this.maxRetries = HiveConf.getIntVar(hiveconf, HiveConf.ConfVars.HIVE_STATS_RETRIES_MAX);
        this.waitWindow = HiveConf.getTimeVar(hiveconf, HiveConf.ConfVars.HIVE_STATS_RETRIES_WAIT, TimeUnit.MILLISECONDS);
        this.sourceTask = sourceTask;
        try {
            JavaUtils.loadClass(driver).newInstance();
        }
        catch (Exception e) {
            this.LOG.error((Object)("Error during instantiating JDBC driver " + driver + ". "), (Throwable)e);
            return false;
        }
        DriverManager.setLoginTimeout(this.timeout);
        Utilities.SQLCommand<Void> setQueryTimeout = new Utilities.SQLCommand<Void>(){

            @Override
            public Void run(PreparedStatement stmt) throws SQLException {
                Utilities.setQueryTimeout(stmt, JDBCStatsAggregator.this.timeout);
                return null;
            }
        };
        int failures = 0;
        while (true) {
            try {
                this.conn = Utilities.connectWithRetry(this.connectionString, this.waitWindow, this.maxRetries);
                for (String statType : JDBCStatsUtils.getSupportedStatistics()) {
                    PreparedStatement selStmt = Utilities.prepareWithRetry(this.conn, JDBCStatsUtils.getSelectAggr(statType, this.comment), this.waitWindow, this.maxRetries);
                    this.columnMapping.put(statType, selStmt);
                    Utilities.executeWithRetry(setQueryTimeout, selStmt, this.waitWindow, failures);
                }
                return true;
            }
            catch (SQLRecoverableException e) {
                if (failures > this.maxRetries) {
                    this.LOG.error((Object)("Error during JDBC connection and preparing statement: " + e));
                    return false;
                }
                long waitTime = Utilities.getRandomWaitTime(this.waitWindow, failures, this.r);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e1) {}
            }
            catch (SQLException e) {
                return false;
            }
            ++failures;
        }
    }

    @Override
    public String aggregateStats(String fileID, String statType) {
        if (!JDBCStatsUtils.isValidStatistic(statType)) {
            this.LOG.warn((Object)("Invalid statistic: " + statType + ", supported stats: " + JDBCStatsUtils.getSupportedStatistics()));
            return null;
        }
        Utilities.SQLCommand<ResultSet> execQuery = new Utilities.SQLCommand<ResultSet>(){

            @Override
            public ResultSet run(PreparedStatement stmt) throws SQLException {
                return stmt.executeQuery();
            }
        };
        JDBCStatsUtils.validateRowId(fileID, this.hiveconf);
        String keyPrefix = Utilities.escapeSqlLike(fileID) + "%";
        int failures = 0;
        while (true) {
            try {
                long retval = 0L;
                PreparedStatement selStmt = this.columnMapping.get(statType);
                selStmt.setString(1, keyPrefix);
                selStmt.setString(2, Character.toString('\\'));
                ResultSet result = Utilities.executeWithRetry(execQuery, selStmt, this.waitWindow, this.maxRetries);
                if (!result.next()) {
                    this.LOG.warn((Object)"Nothing published. Nothing aggregated.");
                    return null;
                }
                retval = result.getLong(1);
                return Long.toString(retval);
            }
            catch (SQLRecoverableException e) {
                if (failures >= this.maxRetries) {
                    return null;
                }
                this.closeConnection();
                long waitTime = Utilities.getRandomWaitTime(this.waitWindow, failures, this.r);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException iex) {
                    // empty catch block
                }
                if (!this.connect(this.hiveconf, this.sourceTask)) {
                    this.LOG.error((Object)("Error during publishing aggregation. " + e));
                    return null;
                }
            }
            catch (SQLException e) {
                this.LOG.error((Object)("Error during publishing aggregation. " + e));
                return null;
            }
            ++failures;
        }
    }

    @Override
    public boolean closeConnection() {
        if (this.conn == null) {
            return true;
        }
        try {
            this.conn.close();
            if (HiveConf.getVar(this.hiveconf, HiveConf.ConfVars.HIVESTATSDBCLASS).equalsIgnoreCase("jdbc:derby")) {
                try {
                    DriverManager.getConnection(this.connectionString + ";shutdown=true");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (SQLException e) {
            this.LOG.error((Object)("Error during JDBC termination. " + e));
            return false;
        }
    }

    @Override
    public boolean cleanUp(String rowID) {
        Utilities.SQLCommand<Void> execUpdate = new Utilities.SQLCommand<Void>(){

            @Override
            public Void run(PreparedStatement stmt) throws SQLException {
                stmt.executeUpdate();
                return null;
            }
        };
        try {
            JDBCStatsUtils.validateRowId(rowID, this.hiveconf);
            String keyPrefix = Utilities.escapeSqlLike(rowID) + "%";
            PreparedStatement delStmt = Utilities.prepareWithRetry(this.conn, JDBCStatsUtils.getDeleteAggr(rowID, this.comment), this.waitWindow, this.maxRetries);
            delStmt.setString(1, keyPrefix);
            delStmt.setString(2, Character.toString('\\'));
            int failures = 0;
            while (true) {
                try {
                    Utilities.executeWithRetry(execUpdate, delStmt, this.waitWindow, this.maxRetries);
                    return true;
                }
                catch (SQLRecoverableException e) {
                    if (failures >= this.maxRetries) {
                        this.LOG.error((Object)("Error during clean-up after " + this.maxRetries + " retries. " + e));
                        return false;
                    }
                    this.closeConnection();
                    long waitTime = Utilities.getRandomWaitTime(this.waitWindow, failures, this.r);
                    try {
                        Thread.sleep(waitTime);
                    }
                    catch (InterruptedException iex) {
                        // empty catch block
                    }
                    if (!this.connect(this.hiveconf, this.sourceTask)) {
                        this.LOG.error((Object)("Error during clean-up. " + e));
                        return false;
                    }
                }
                catch (SQLException e) {
                    this.LOG.error((Object)("Error during clean-up. " + e));
                    return false;
                }
                ++failures;
            }
        }
        catch (SQLException e) {
            this.LOG.error((Object)("Error during publishing aggregation. " + e));
            return false;
        }
    }
}

