/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMdSize;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.ImmutableNullableList;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.plan.ColStatistics;

public class HiveRelMdSize
extends RelMdSize {
    private static final HiveRelMdSize INSTANCE = new HiveRelMdSize();
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Object)INSTANCE, (Method[])new Method[]{BuiltInMethod.AVERAGE_COLUMN_SIZES.method, BuiltInMethod.AVERAGE_ROW_SIZE.method});

    private HiveRelMdSize() {
    }

    public List<Double> averageColumnSizes(HiveTableScan scan) {
        List<Integer> neededcolsLst = scan.getNeededColIndxsFrmReloptHT();
        List<ColStatistics> columnStatistics = ((RelOptHiveTable)scan.getTable()).getColStat(neededcolsLst, true);
        ImmutableList.Builder list = ImmutableList.builder();
        int indxRqdCol = 0;
        int nFields = scan.getRowType().getFieldCount();
        for (int i = 0; i < nFields; ++i) {
            if (neededcolsLst.contains(i)) {
                ColStatistics columnStatistic = columnStatistics.get(indxRqdCol);
                ++indxRqdCol;
                if (columnStatistic == null) {
                    RelDataTypeField field = scan.getRowType().getFieldList().get(i);
                    list.add(this.averageTypeValueSize(field.getType()));
                    continue;
                }
                list.add((Object)columnStatistic.getAvgColLen());
                continue;
            }
            list.add(new Double(0.0));
        }
        return list.build();
    }

    public List<Double> averageColumnSizes(HiveJoin rel) {
        RelNode left = rel.getLeft();
        RelNode right = rel.getRight();
        List<Double> lefts = RelMetadataQuery.getAverageColumnSizes(left);
        List<Double> rights = null;
        if (!rel.isLeftSemiJoin()) {
            rights = RelMetadataQuery.getAverageColumnSizes(right);
        }
        if (lefts == null && rights == null) {
            return null;
        }
        int fieldCount = rel.getRowType().getFieldCount();
        Double[] sizes = new Double[fieldCount];
        if (lefts != null) {
            lefts.toArray(sizes);
        }
        if (rights != null) {
            int leftCount = left.getRowType().getFieldCount();
            for (int i = 0; i < rights.size(); ++i) {
                sizes[leftCount + i] = rights.get(i);
            }
        }
        return ImmutableNullableList.copyOf(sizes);
    }

    @Override
    public Double averageTypeValueSize(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case BOOLEAN: 
            case TINYINT: {
                return 1.0;
            }
            case SMALLINT: {
                return 2.0;
            }
            case INTEGER: 
            case FLOAT: 
            case REAL: 
            case DECIMAL: 
            case DATE: 
            case TIME: {
                return 4.0;
            }
            case BIGINT: 
            case DOUBLE: 
            case TIMESTAMP: 
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return 8.0;
            }
            case BINARY: {
                return type.getPrecision();
            }
            case VARBINARY: {
                return Math.min((double)type.getPrecision(), 100.0);
            }
            case CHAR: {
                return (double)type.getPrecision() * 2.0;
            }
            case VARCHAR: {
                return Math.min((double)type.getPrecision() * 2.0, 100.0);
            }
            case ROW: {
                Double average = 0.0;
                for (RelDataTypeField field : type.getFieldList()) {
                    average = average + this.averageTypeValueSize(field.getType());
                }
                return average;
            }
        }
        return null;
    }
}

