/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.plan.hep.HepRelVertex;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.RelVisitor;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.SemiJoin;
import hive.org.apache.calcite.rel.core.TableScan;
import hive.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMdRowCount;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.ImmutableBitSet;
import hive.org.apache.calcite.util.Pair;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdUniqueKeys;

public class HiveRelMdRowCount
extends RelMdRowCount {
    protected static final Log LOG = LogFactory.getLog((String)HiveRelMdRowCount.class.getName());
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.ROW_COUNT.method, (Object)new HiveRelMdRowCount());

    protected HiveRelMdRowCount() {
    }

    public Double getRowCount(Join join) {
        PKFKRelationInfo pkfk = HiveRelMdRowCount.analyzeJoinForPKFK(join);
        if (pkfk != null) {
            double selectivity = pkfk.pkInfo.selectivity * pkfk.ndvScalingFactor;
            selectivity = Math.min(1.0, selectivity);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Identified Primary - Foreign Key relation:");
                LOG.debug((Object)RelOptUtil.toString(join));
                LOG.debug((Object)pkfk);
            }
            return pkfk.fkInfo.rowCount * selectivity;
        }
        return join.getRows();
    }

    public Double getRowCount(SemiJoin rel) {
        PKFKRelationInfo pkfk = HiveRelMdRowCount.analyzeJoinForPKFK(rel);
        if (pkfk != null) {
            double selectivity = pkfk.pkInfo.selectivity * pkfk.ndvScalingFactor;
            selectivity = Math.min(1.0, selectivity);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Identified Primary - Foreign Key relation:");
                LOG.debug((Object)RelOptUtil.toString(rel));
                LOG.debug((Object)pkfk);
            }
            return pkfk.fkInfo.rowCount * selectivity;
        }
        return super.getRowCount(rel);
    }

    public static PKFKRelationInfo analyzeJoinForPKFK(Join joinRel) {
        int pkSide;
        boolean rightIsKey;
        RelNode left = joinRel.getInputs().get(0);
        RelNode right = joinRel.getInputs().get(1);
        List<RexNode> initJoinFilters = RelOptUtil.conjunctions(joinRel.getCondition());
        if (initJoinFilters.isEmpty()) {
            return null;
        }
        ArrayList<RexNode> leftFilters = new ArrayList<RexNode>();
        ArrayList<RexNode> rightFilters = new ArrayList<RexNode>();
        ArrayList<RexNode> joinFilters = new ArrayList<RexNode>(initJoinFilters);
        if (joinRel instanceof SemiJoin) {
            return null;
        }
        RelOptUtil.classifyFilters(joinRel, joinFilters, joinRel.getJoinType(), false, !joinRel.getJoinType().generatesNullsOnRight(), !joinRel.getJoinType().generatesNullsOnLeft(), joinFilters, leftFilters, rightFilters);
        Pair<Integer, Integer> joinCols = HiveRelMdRowCount.canHandleJoin(joinRel, leftFilters, rightFilters, joinFilters);
        if (joinCols == null) {
            return null;
        }
        int leftColIdx = (Integer)joinCols.left;
        int rightColIdx = (Integer)joinCols.right;
        RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
        RexNode leftPred = RexUtil.composeConjunction(rexBuilder, leftFilters, true);
        RexNode rightPred = RexUtil.composeConjunction(rexBuilder, rightFilters, true);
        ImmutableBitSet lBitSet = ImmutableBitSet.of(leftColIdx);
        ImmutableBitSet rBitSet = ImmutableBitSet.of(rightColIdx);
        boolean leftIsKey = (joinRel.getJoinType() == JoinRelType.INNER || joinRel.getJoinType() == JoinRelType.RIGHT) && !(joinRel instanceof SemiJoin) && HiveRelMdRowCount.isKey(lBitSet, left);
        boolean bl = rightIsKey = (joinRel.getJoinType() == JoinRelType.INNER || joinRel.getJoinType() == JoinRelType.LEFT) && HiveRelMdRowCount.isKey(rBitSet, right);
        if (!leftIsKey && !rightIsKey) {
            return null;
        }
        double leftRowCount = RelMetadataQuery.getRowCount(left);
        double rightRowCount = RelMetadataQuery.getRowCount(right);
        if (leftIsKey && rightIsKey && rightRowCount < leftRowCount) {
            leftIsKey = false;
        }
        int n = leftIsKey ? 0 : (pkSide = rightIsKey ? 1 : -1);
        boolean isPKSideSimpleTree = pkSide != -1 ? IsSimpleTreeOnJoinKey.check(pkSide == 0 ? left : right, pkSide == 0 ? leftColIdx : rightColIdx) : false;
        double leftNDV = isPKSideSimpleTree ? RelMetadataQuery.getDistinctRowCount(left, lBitSet, leftPred) : -1.0;
        double rightNDV = isPKSideSimpleTree ? RelMetadataQuery.getDistinctRowCount(right, rBitSet, rightPred) : -1.0;
        double ndvScalingFactor = 1.0;
        if (isPKSideSimpleTree) {
            double d = ndvScalingFactor = pkSide == 0 ? leftNDV / rightNDV : rightNDV / leftNDV;
        }
        if (pkSide == 0) {
            FKSideInfo fkInfo = new FKSideInfo(rightRowCount, rightNDV);
            double pkSelectivity = HiveRelMdRowCount.pkSelectivity(joinRel, true, left, leftRowCount);
            PKSideInfo pkInfo = new PKSideInfo(leftRowCount, leftNDV, joinRel.getJoinType().generatesNullsOnRight() ? 1.0 : pkSelectivity);
            return new PKFKRelationInfo(1, fkInfo, pkInfo, ndvScalingFactor, isPKSideSimpleTree);
        }
        if (pkSide == 1) {
            FKSideInfo fkInfo = new FKSideInfo(leftRowCount, leftNDV);
            double pkSelectivity = HiveRelMdRowCount.pkSelectivity(joinRel, false, right, rightRowCount);
            PKSideInfo pkInfo = new PKSideInfo(rightRowCount, rightNDV, joinRel.getJoinType().generatesNullsOnLeft() ? 1.0 : pkSelectivity);
            return new PKFKRelationInfo(1, fkInfo, pkInfo, ndvScalingFactor, isPKSideSimpleTree);
        }
        return null;
    }

    private static double pkSelectivity(Join joinRel, boolean leftChild, RelNode child, double childRowCount) {
        if (leftChild && joinRel.getJoinType().generatesNullsOnRight() || !leftChild && joinRel.getJoinType().generatesNullsOnLeft()) {
            return 1.0;
        }
        HiveTableScan tScan = HiveRelMdUniqueKeys.getTableScan(child, true);
        if (tScan != null) {
            double tRowCount = RelMetadataQuery.getRowCount(tScan);
            return childRowCount / tRowCount;
        }
        return 1.0;
    }

    private static boolean isKey(ImmutableBitSet c, RelNode rel) {
        boolean isKey = false;
        Set<ImmutableBitSet> keys = RelMetadataQuery.getUniqueKeys(rel);
        if (keys != null) {
            for (ImmutableBitSet key : keys) {
                if (!key.equals(c)) continue;
                isKey = true;
                break;
            }
        }
        return isKey;
    }

    private static Pair<Integer, Integer> canHandleJoin(Join joinRel, List<RexNode> leftFilters, List<RexNode> rightFilters, List<RexNode> joinFilters) {
        if (joinFilters.size() != 1) {
            return null;
        }
        RexNode joinCond = joinFilters.get(0);
        if (!(joinCond instanceof RexCall)) {
            return null;
        }
        if (((RexCall)joinCond).getOperator() != SqlStdOperatorTable.EQUALS) {
            return null;
        }
        ImmutableBitSet leftCols = RelOptUtil.InputFinder.bits(((RexCall)joinCond).getOperands().get(0));
        ImmutableBitSet rightCols = RelOptUtil.InputFinder.bits(((RexCall)joinCond).getOperands().get(1));
        if (leftCols.cardinality() != 1 || rightCols.cardinality() != 1) {
            return null;
        }
        int nFieldsLeft = joinRel.getLeft().getRowType().getFieldList().size();
        int nFieldsRight = joinRel.getRight().getRowType().getFieldList().size();
        int nSysFields = joinRel.getSystemFieldList().size();
        ImmutableBitSet rightFieldsBitSet = ImmutableBitSet.range(nSysFields + nFieldsLeft, nSysFields + nFieldsLeft + nFieldsRight);
        if (rightFieldsBitSet.contains(leftCols)) {
            ImmutableBitSet t = leftCols;
            leftCols = rightCols;
            rightCols = t;
        }
        int leftColIdx = leftCols.nextSetBit(0) - nSysFields;
        int rightColIdx = rightCols.nextSetBit(0) - (nSysFields + nFieldsLeft);
        return new Pair<Integer, Integer>(leftColIdx, rightColIdx);
    }

    private static class IsSimpleTreeOnJoinKey
    extends RelVisitor {
        int joinKey;
        boolean simpleTree;

        static boolean check(RelNode r, int joinKey) {
            IsSimpleTreeOnJoinKey v = new IsSimpleTreeOnJoinKey(joinKey);
            v.go(r);
            return v.simpleTree;
        }

        IsSimpleTreeOnJoinKey(int joinKey) {
            this.joinKey = joinKey;
            this.simpleTree = true;
        }

        @Override
        public void visit(RelNode node, int ordinal, RelNode parent) {
            if (node instanceof HepRelVertex) {
                node = ((HepRelVertex)node).getCurrentRel();
            }
            this.simpleTree = node instanceof TableScan ? true : (node instanceof Project ? this.isSimple((Project)node) : (node instanceof Filter ? this.isSimple((Filter)node) : false));
            if (this.simpleTree) {
                super.visit(node, ordinal, parent);
            }
        }

        private boolean isSimple(Project project) {
            RexNode r = project.getProjects().get(this.joinKey);
            if (r instanceof RexInputRef) {
                this.joinKey = ((RexInputRef)r).getIndex();
                return true;
            }
            return false;
        }

        private boolean isSimple(Filter filter) {
            ImmutableBitSet condBits = RelOptUtil.InputFinder.bits(filter.getCondition());
            return HiveRelMdRowCount.isKey(condBits, filter);
        }
    }

    static class PKSideInfo
    extends FKSideInfo {
        public final double selectivity;

        public PKSideInfo(double rowCount, double distinctCount, double selectivity) {
            super(rowCount, distinctCount);
            this.selectivity = selectivity;
        }

        @Override
        public String toString() {
            return String.format("PKInfo(rowCount=%.2f,ndv=%.2f,selectivity=%.2f)", this.rowCount, this.distinctCount, this.selectivity);
        }
    }

    static class FKSideInfo {
        public final double rowCount;
        public final double distinctCount;

        public FKSideInfo(double rowCount, double distinctCount) {
            this.rowCount = rowCount;
            this.distinctCount = distinctCount;
        }

        public String toString() {
            return String.format("FKInfo(rowCount=%.2f,ndv=%.2f)", this.rowCount, this.distinctCount);
        }
    }

    static class PKFKRelationInfo {
        public final int fkSide;
        public final double ndvScalingFactor;
        public final FKSideInfo fkInfo;
        public final PKSideInfo pkInfo;
        public final boolean isPKSideSimple;

        PKFKRelationInfo(int fkSide, FKSideInfo fkInfo, PKSideInfo pkInfo, double ndvScalingFactor, boolean isPKSideSimple) {
            this.fkSide = fkSide;
            this.fkInfo = fkInfo;
            this.pkInfo = pkInfo;
            this.ndvScalingFactor = ndvScalingFactor;
            this.isPKSideSimple = isPKSideSimple;
        }

        public String toString() {
            return String.format("Primary - Foreign Key join:\n\tfkSide = %d\n\tFKInfo:%s\n\tPKInfo:%s\n\tisPKSideSimple:%s\n\tNDV Scaling Factor:%.2f\n", this.fkSide, this.fkInfo, this.pkInfo, this.isPKSideSimple, this.ndvScalingFactor);
        }
    }
}

