/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import hive.org.apache.calcite.rel.RelCollations;
import hive.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMdMemory;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.util.BuiltInMethod;
import java.lang.reflect.Method;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSort;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;

public class HiveRelMdMemory
extends RelMdMemory {
    private static final HiveRelMdMemory INSTANCE = new HiveRelMdMemory();
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Object)INSTANCE, (Method[])new Method[]{BuiltInMethod.MEMORY.method, BuiltInMethod.CUMULATIVE_MEMORY_WITHIN_PHASE.method, BuiltInMethod.CUMULATIVE_MEMORY_WITHIN_PHASE_SPLIT.method});

    private HiveRelMdMemory() {
    }

    public Double memory(HiveTableScan tableScan) {
        return 0.0;
    }

    public Double memory(HiveAggregate aggregate) {
        Double avgRowSize = RelMetadataQuery.getAverageRowSize(aggregate.getInput());
        Double rowCount = RelMetadataQuery.getRowCount(aggregate.getInput());
        if (avgRowSize == null || rowCount == null) {
            return null;
        }
        return avgRowSize * rowCount;
    }

    public Double memory(HiveFilter filter) {
        return 0.0;
    }

    public Double memory(HiveJoin join) {
        return join.getMemory();
    }

    public Double cumulativeMemoryWithinPhaseSplit(HiveJoin join) {
        return join.getCumulativeMemoryWithinPhaseSplit();
    }

    public Double memory(HiveLimit limit) {
        return 0.0;
    }

    public Double memory(HiveProject project) {
        return 0.0;
    }

    public Double memory(HiveSort sort) {
        if (sort.getCollation() != RelCollations.EMPTY) {
            Double avgRowSize = RelMetadataQuery.getAverageRowSize(sort.getInput());
            Double rowCount = RelMetadataQuery.getRowCount(sort.getInput());
            if (avgRowSize == null || rowCount == null) {
                return null;
            }
            return avgRowSize * rowCount;
        }
        return 0.0;
    }

    public Double memory(HiveUnion union) {
        return 0.0;
    }
}

