/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMdDistinctRowCount;
import hive.org.apache.calcite.rel.metadata.RelMdUtil;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.ImmutableBitSet;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveCost;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.plan.ColStatistics;

public class HiveRelMdDistinctRowCount
extends RelMdDistinctRowCount {
    private static final HiveRelMdDistinctRowCount INSTANCE = new HiveRelMdDistinctRowCount();
    public static final RelMetadataProvider SOURCE = ChainedRelMetadataProvider.of(ImmutableList.of(ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.DISTINCT_ROW_COUNT.method, (Object)INSTANCE), ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.CUMULATIVE_COST.method, (Object)INSTANCE)));

    private HiveRelMdDistinctRowCount() {
    }

    public Double getDistinctRowCount(RelNode rel, ImmutableBitSet groupKey, RexNode predicate) {
        if (rel instanceof HiveTableScan) {
            return this.getDistinctRowCount((HiveTableScan)rel, groupKey, predicate);
        }
        return super.getDistinctRowCount(rel, groupKey, predicate);
    }

    private Double getDistinctRowCount(HiveTableScan htRel, ImmutableBitSet groupKey, RexNode predicate) {
        List<Integer> projIndxLst = HiveCalciteUtil.translateBitSetToProjIndx(groupKey);
        List<ColStatistics> colStats = htRel.getColStat(projIndxLst);
        Double noDistinctRows = 1.0;
        for (ColStatistics cStat : colStats) {
            noDistinctRows = noDistinctRows * (double)cStat.getCountDistint();
        }
        return Math.min(noDistinctRows, htRel.getRows());
    }

    public static Double getDistinctRowCount(RelNode r, int indx) {
        ImmutableBitSet bitSetOfRqdProj = ImmutableBitSet.of(indx);
        return RelMetadataQuery.getDistinctRowCount(r, bitSetOfRqdProj, r.getCluster().getRexBuilder().makeLiteral(true));
    }

    public Double getDistinctRowCount(Join rel, ImmutableBitSet groupKey, RexNode predicate) {
        if (rel instanceof HiveJoin) {
            HiveJoin hjRel = (HiveJoin)rel;
            if (hjRel.isLeftSemiJoin()) {
                return RelMetadataQuery.getDistinctRowCount(hjRel.getLeft(), groupKey, rel.getCluster().getRexBuilder().makeLiteral(true));
            }
            return RelMdUtil.getJoinDistinctRowCount((RelNode)rel, (JoinRelType)rel.getJoinType(), (ImmutableBitSet)groupKey, (RexNode)predicate, (boolean)true);
        }
        return RelMetadataQuery.getDistinctRowCount(rel, groupKey, predicate);
    }

    public RelOptCost getCumulativeCost(HiveJoin rel) {
        RelOptCost cost = RelMetadataQuery.getNonCumulativeCost(rel);
        List<RelNode> inputs = rel.getInputs();
        RelOptCost maxICost = HiveCost.ZERO;
        for (RelNode input : inputs) {
            RelOptCost iCost = RelMetadataQuery.getCumulativeCost(input);
            if (!maxICost.isLt(iCost)) continue;
            maxICost = iCost;
        }
        return cost.plus(maxICost);
    }
}

