/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Aggregate;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rex.RexFieldCollation;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexOver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;

public class HiveWindowingFixRule
extends RelOptRule {
    public static final HiveWindowingFixRule INSTANCE = new HiveWindowingFixRule();
    private final RelFactories.ProjectFactory projectFactory = HiveProject.DEFAULT_PROJECT_FACTORY;

    private HiveWindowingFixRule() {
        super(HiveWindowingFixRule.operand(Project.class, HiveWindowingFixRule.operand(Aggregate.class, HiveWindowingFixRule.any()), new RelOptRuleOperand[0]));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        Aggregate aggregate = (Aggregate)call.rel(1);
        int groupingFields = aggregate.getGroupCount() + aggregate.getIndicatorCount();
        HashSet<String> projectExprsDigest = new HashSet<String>();
        HashMap<String, Object> windowingExprsDigestToNodes = new HashMap<String, Object>();
        for (RexNode r : project.getChildExps()) {
            if (r instanceof RexOver) {
                RexOver rexOverNode = (RexOver)r;
                for (RexNode operand : rexOverNode.getOperands()) {
                    if (!(operand instanceof RexInputRef) || ((RexInputRef)operand).getIndex() < groupingFields) continue;
                    windowingExprsDigestToNodes.put(operand.toString(), operand);
                }
                for (RexNode partitionKey : rexOverNode.getWindow().partitionKeys) {
                    if (!(partitionKey instanceof RexInputRef) || ((RexInputRef)partitionKey).getIndex() < groupingFields) continue;
                    windowingExprsDigestToNodes.put(partitionKey.toString(), partitionKey);
                }
                for (RexFieldCollation orderKey : rexOverNode.getWindow().orderKeys) {
                    if (!(orderKey.left instanceof RexInputRef) || ((RexInputRef)orderKey.left).getIndex() < groupingFields) continue;
                    windowingExprsDigestToNodes.put(((RexNode)orderKey.left).toString(), orderKey.left);
                }
                continue;
            }
            projectExprsDigest.add(r.toString());
        }
        ArrayList<RexNode> belowProjectExprs = new ArrayList<RexNode>();
        ArrayList<String> belowProjectColumnNames = new ArrayList<String>();
        ArrayList<RexInputRef> topProjectExprs = new ArrayList<RexInputRef>();
        int projectCount = project.getChildExps().size();
        for (int i = 0; i < projectCount; ++i) {
            belowProjectExprs.add(project.getChildExps().get(i));
            belowProjectColumnNames.add(project.getRowType().getFieldNames().get(i));
            topProjectExprs.add(RexInputRef.of(i, project.getRowType()));
        }
        boolean windowingFix = false;
        for (Map.Entry windowingExpr : windowingExprsDigestToNodes.entrySet()) {
            if (projectExprsDigest.contains(windowingExpr.getKey())) continue;
            windowingFix = true;
            belowProjectExprs.add((RexNode)windowingExpr.getValue());
            int colIndex = 0;
            String alias = "window_col_" + colIndex;
            while (belowProjectColumnNames.contains(alias)) {
                alias = "window_col_" + colIndex++;
            }
            belowProjectColumnNames.add(alias);
        }
        if (!windowingFix) {
            return;
        }
        RelNode newProjectRel = this.projectFactory.createProject(aggregate, belowProjectExprs, belowProjectColumnNames);
        RelNode newTopProjectRel = this.projectFactory.createProject(newProjectRel, topProjectExprs, project.getRowType().getFieldNames());
        call.transformTo(newTopProjectRel);
    }
}

