/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelFieldCollation;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.sql.validate.SqlValidator;
import hive.org.apache.calcite.sql2rel.RelFieldTrimmer;
import hive.org.apache.calcite.util.ImmutableBitSet;
import hive.org.apache.calcite.util.Util;
import java.util.Set;

public class HiveRelFieldTrimmer
extends RelFieldTrimmer {
    public HiveRelFieldTrimmer(SqlValidator validator) {
        super(validator);
    }

    public HiveRelFieldTrimmer(SqlValidator validator, RelFactories.ProjectFactory projectFactory, RelFactories.FilterFactory filterFactory, RelFactories.JoinFactory joinFactory, RelFactories.SemiJoinFactory semiJoinFactory, RelFactories.SortFactory sortFactory, RelFactories.AggregateFactory aggregateFactory, RelFactories.SetOpFactory setOpFactory) {
        super(validator, projectFactory, filterFactory, joinFactory, semiJoinFactory, sortFactory, aggregateFactory, setOpFactory);
    }

    @Override
    protected RelFieldTrimmer.TrimResult trimChild(RelNode rel, RelNode input, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        Util.discard(rel);
        if (input.getClass().getName().endsWith("MedMdrClassExtentRel")) {
            fieldsUsed = ImmutableBitSet.range(input.getRowType().getFieldCount());
        }
        ImmutableList<RelCollation> collations = RelMetadataQuery.collations(input);
        for (RelCollation collation : collations) {
            for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
                fieldsUsed = fieldsUsed.set(fieldCollation.getFieldIndex());
            }
        }
        return this.dispatchTrimFields(input, fieldsUsed, extraFields);
    }
}

