/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.LinkedHashMultimap;
import hive.com.google.common.collect.Sets;
import hive.org.apache.calcite.plan.RelOptPredicateList;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.core.TableScan;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.sql.SqlKind;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;

public class HivePreFilteringRule
extends RelOptRule {
    protected static final Log LOG = LogFactory.getLog((String)HivePreFilteringRule.class.getName());
    public static final HivePreFilteringRule INSTANCE = new HivePreFilteringRule();
    private final RelFactories.FilterFactory filterFactory = HiveFilter.DEFAULT_FILTER_FACTORY;
    private static final Set<SqlKind> COMPARISON = EnumSet.of(SqlKind.EQUALS, new SqlKind[]{SqlKind.GREATER_THAN_OR_EQUAL, SqlKind.LESS_THAN_OR_EQUAL, SqlKind.GREATER_THAN, SqlKind.LESS_THAN, SqlKind.NOT_EQUALS});

    private HivePreFilteringRule() {
        super(HivePreFilteringRule.operand(Filter.class, HivePreFilteringRule.operand(RelNode.class, HivePreFilteringRule.any()), new RelOptRuleOperand[0]));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        Object filterChild = call.rel(1);
        if (filterChild instanceof TableScan) {
            return;
        }
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RexNode condition = RexUtil.pullFactors(rexBuilder, filter.getCondition());
        List<Object> commonOperands = new ArrayList();
        switch (condition.getKind()) {
            case AND: {
                ImmutableList<RexNode> operands = RexUtil.flattenAnd(((RexCall)condition).getOperands());
                for (RexNode operand : operands) {
                    if (operand.getKind() != SqlKind.OR) continue;
                    commonOperands.addAll(HivePreFilteringRule.extractCommonOperands(rexBuilder, operand));
                }
                break;
            }
            case OR: {
                commonOperands = HivePreFilteringRule.extractCommonOperands(rexBuilder, condition);
                break;
            }
            default: {
                return;
            }
        }
        if (commonOperands.isEmpty()) {
            return;
        }
        RelOptPredicateList predicates = RelMetadataQuery.getPulledUpPredicates(filter);
        ArrayList<RexNode> newConjuncts = new ArrayList<RexNode>();
        for (RexNode rexNode : commonOperands) {
            boolean found = false;
            for (RexNode conjunct : predicates.pulledUpPredicates) {
                if (!rexNode.toString().equals(conjunct.toString())) continue;
                found = true;
                break;
            }
            if (found) continue;
            newConjuncts.add(rexNode);
        }
        if (newConjuncts.isEmpty()) {
            return;
        }
        RexNode newCondition = RexUtil.pullFactors(rexBuilder, RexUtil.composeConjunction(rexBuilder, newConjuncts, false));
        RelNode relNode = this.filterFactory.createFilter((RelNode)filterChild, newCondition);
        RelNode newTopFilter = this.filterFactory.createFilter(relNode, condition);
        call.transformTo(newTopFilter);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<RexNode> extractCommonOperands(RexBuilder rexBuilder, RexNode condition) {
        void var3_4;
        assert (condition.getKind() == SqlKind.OR);
        LinkedHashMultimap<String, RexCall> reductionCondition = LinkedHashMultimap.create();
        Object var3_3 = null;
        ImmutableList<RexNode> operands = RexUtil.flattenOr(((RexCall)condition).getOperands());
        for (int i = 0; i < operands.size(); ++i) {
            void var3_7;
            RexNode operand = (RexNode)operands.get(i);
            RexNode operandCNF = RexUtil.toCnf(rexBuilder, operand);
            List<RexNode> conjunctions = RelOptUtil.conjunctions(operandCNF);
            HashSet<String> refsInCurrentOperand = Sets.newHashSet();
            for (RexNode conjunction : conjunctions) {
                if (!(conjunction instanceof RexCall)) {
                    return new ArrayList<RexNode>();
                }
                RexCall conjCall = (RexCall)conjunction;
                RexNode ref = null;
                if (COMPARISON.contains((Object)conjCall.getOperator().getKind())) {
                    if (conjCall.operands.get(0) instanceof RexInputRef && conjCall.operands.get(1) instanceof RexLiteral) {
                        ref = (RexNode)conjCall.operands.get(0);
                    } else {
                        if (!(conjCall.operands.get(1) instanceof RexInputRef) || !(conjCall.operands.get(0) instanceof RexLiteral)) return new ArrayList<RexNode>();
                        ref = (RexNode)conjCall.operands.get(1);
                    }
                } else if (conjCall.getOperator().getKind().equals((Object)SqlKind.IN)) {
                    ref = (RexNode)conjCall.operands.get(0);
                } else {
                    if (!conjCall.getOperator().getKind().equals((Object)SqlKind.BETWEEN)) return new ArrayList<RexNode>();
                    ref = (RexNode)conjCall.operands.get(1);
                }
                String stringRef = ref.toString();
                reductionCondition.put(stringRef, conjCall);
                refsInCurrentOperand.add(stringRef);
            }
            if (i == 0) {
                HashSet<String> hashSet = refsInCurrentOperand;
            } else {
                Sets.SetView setView = Sets.intersection(var3_4, refsInCurrentOperand);
            }
            if (!var3_7.isEmpty()) continue;
            return new ArrayList<RexNode>();
        }
        ArrayList<RexNode> commonOperands = new ArrayList<RexNode>();
        for (String ref : var3_4) {
            commonOperands.add(RexUtil.composeDisjunction(rexBuilder, reductionCondition.get(ref), false));
        }
        return commonOperands;
    }
}

