/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import hive.com.google.common.collect.ImmutableMap;
import hive.com.google.common.collect.Lists;
import hive.com.google.common.collect.Maps;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.rules.MultiJoin;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.rex.RexVisitorImpl;
import hive.org.apache.calcite.util.ImmutableBitSet;
import hive.org.apache.calcite.util.ImmutableIntList;
import hive.org.apache.calcite.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;

public class HiveJoinToMultiJoinRule
extends RelOptRule {
    public static final HiveJoinToMultiJoinRule INSTANCE = new HiveJoinToMultiJoinRule(Join.class);

    public HiveJoinToMultiJoinRule(Class<? extends Join> clazz) {
        super(HiveJoinToMultiJoinRule.operand(clazz, HiveJoinToMultiJoinRule.operand(RelNode.class, HiveJoinToMultiJoinRule.any()), HiveJoinToMultiJoinRule.operand(RelNode.class, HiveJoinToMultiJoinRule.any())));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        boolean combinable;
        Join join = (Join)call.rel(0);
        Object left = call.rel(1);
        Object right = call.rel(2);
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        if (join.getJoinType() != JoinRelType.INNER) {
            return;
        }
        ArrayList<RelNode> newInputs = Lists.newArrayList();
        ArrayList<RexNode> newJoinFilters = Lists.newArrayList();
        newJoinFilters.add(join.getCondition());
        ArrayList<Pair<JoinRelType, RexNode>> joinSpecs = Lists.newArrayList();
        ArrayList<ImmutableBitSet> projFields = Lists.newArrayList();
        if (left instanceof Join || left instanceof MultiJoin) {
            RexNode leftCondition = left instanceof Join ? ((Join)left).getCondition() : ((MultiJoin)left).getJoinFilter();
            combinable = HiveJoinToMultiJoinRule.isCombinablePredicate(join, join.getCondition(), leftCondition);
            if (combinable) {
                newJoinFilters.add(leftCondition);
                for (RelNode input : left.getInputs()) {
                    projFields.add(null);
                    joinSpecs.add(Pair.of(JoinRelType.INNER, null));
                    newInputs.add(input);
                }
            } else {
                projFields.add(null);
                joinSpecs.add(Pair.of(JoinRelType.INNER, null));
                newInputs.add((RelNode)left);
            }
        } else {
            projFields.add(null);
            joinSpecs.add(Pair.of(JoinRelType.INNER, null));
            newInputs.add((RelNode)left);
        }
        if (right instanceof Join || right instanceof MultiJoin) {
            RexNode rightCondition = right instanceof Join ? this.shiftRightFilter(join, (RelNode)left, (RelNode)right, ((Join)right).getCondition()) : this.shiftRightFilter(join, (RelNode)left, (RelNode)right, ((MultiJoin)right).getJoinFilter());
            combinable = HiveJoinToMultiJoinRule.isCombinablePredicate(join, join.getCondition(), rightCondition);
            if (combinable) {
                newJoinFilters.add(rightCondition);
                for (RelNode input : right.getInputs()) {
                    projFields.add(null);
                    joinSpecs.add(Pair.of(JoinRelType.INNER, null));
                    newInputs.add(input);
                }
            } else {
                projFields.add(null);
                joinSpecs.add(Pair.of(JoinRelType.INNER, null));
                newInputs.add((RelNode)right);
            }
        } else {
            projFields.add(null);
            joinSpecs.add(Pair.of(JoinRelType.INNER, null));
            newInputs.add((RelNode)right);
        }
        if (newJoinFilters.size() == 1) {
            return;
        }
        RexNode newCondition = RexUtil.flatten(rexBuilder, RexUtil.composeConjunction(rexBuilder, newJoinFilters, false));
        ImmutableMap<Integer, ImmutableIntList> newJoinFieldRefCountsMap = this.addOnJoinFieldRefCounts(newInputs, join.getRowType().getFieldCount(), newCondition);
        List<RexNode> newPostJoinFilters = this.combinePostJoinFilters(join, (RelNode)left, (RelNode)right);
        MultiJoin multiJoin = new MultiJoin(join.getCluster(), newInputs, newCondition, join.getRowType(), false, Pair.right(joinSpecs), Pair.left(joinSpecs), projFields, newJoinFieldRefCountsMap, RexUtil.composeConjunction(rexBuilder, newPostJoinFilters, true));
        call.transformTo(multiJoin);
    }

    private static boolean isCombinablePredicate(Join join, RexNode condition, RexNode otherCondition) {
        HiveCalciteUtil.JoinPredicateInfo joinPredInfo = HiveCalciteUtil.JoinPredicateInfo.constructJoinPredicateInfo(join, condition);
        HiveCalciteUtil.JoinPredicateInfo otherJoinPredInfo = HiveCalciteUtil.JoinPredicateInfo.constructJoinPredicateInfo(join, otherCondition);
        if (joinPredInfo.getProjsFromLeftPartOfJoinKeysInJoinSchema().equals(otherJoinPredInfo.getProjsFromLeftPartOfJoinKeysInJoinSchema())) {
            return false;
        }
        return !joinPredInfo.getProjsFromRightPartOfJoinKeysInJoinSchema().equals(otherJoinPredInfo.getProjsFromRightPartOfJoinKeysInJoinSchema());
    }

    private RexNode shiftRightFilter(Join joinRel, RelNode left, RelNode right, RexNode rightFilter) {
        if (rightFilter == null) {
            return null;
        }
        int nFieldsOnLeft = left.getRowType().getFieldList().size();
        int nFieldsOnRight = right.getRowType().getFieldList().size();
        int[] adjustments = new int[nFieldsOnRight];
        for (int i = 0; i < nFieldsOnRight; ++i) {
            adjustments[i] = nFieldsOnLeft;
        }
        rightFilter = rightFilter.accept(new RelOptUtil.RexInputConverter(joinRel.getCluster().getRexBuilder(), right.getRowType().getFieldList(), joinRel.getRowType().getFieldList(), adjustments));
        return rightFilter;
    }

    private ImmutableMap<Integer, ImmutableIntList> addOnJoinFieldRefCounts(List<RelNode> multiJoinInputs, int nTotalFields, RexNode joinCondition) {
        int[] joinCondRefCounts = new int[nTotalFields];
        joinCondition.accept(new InputReferenceCounter(joinCondRefCounts));
        HashMap<Integer, int[]> refCountsMap = Maps.newHashMap();
        int nInputs = multiJoinInputs.size();
        int currInput = -1;
        int startField = 0;
        int nFields = 0;
        for (int i = 0; i < nTotalFields; ++i) {
            if (joinCondRefCounts[i] == 0) continue;
            while (i >= startField + nFields) {
                startField += nFields;
                assert (++currInput < nInputs);
                nFields = multiJoinInputs.get(currInput).getRowType().getFieldCount();
            }
            int[] refCounts = (int[])refCountsMap.get(currInput);
            if (refCounts == null) {
                refCounts = new int[nFields];
                refCountsMap.put(currInput, refCounts);
            }
            int n = i - startField;
            refCounts[n] = refCounts[n] + joinCondRefCounts[i];
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : refCountsMap.entrySet()) {
            builder.put(entry.getKey(), ImmutableIntList.of((int[])entry.getValue()));
        }
        return builder.build();
    }

    private List<RexNode> combinePostJoinFilters(Join joinRel, RelNode left, RelNode right) {
        ArrayList<RexNode> filters = Lists.newArrayList();
        if (right instanceof MultiJoin) {
            MultiJoin multiRight = (MultiJoin)right;
            filters.add(this.shiftRightFilter(joinRel, left, multiRight, multiRight.getPostJoinFilter()));
        }
        if (left instanceof MultiJoin) {
            filters.add(((MultiJoin)left).getPostJoinFilter());
        }
        return filters;
    }

    private class InputReferenceCounter
    extends RexVisitorImpl<Void> {
        private final int[] refCounts;

        public InputReferenceCounter(int[] refCounts) {
            super(true);
            this.refCounts = refCounts;
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            int n = inputRef.getIndex();
            this.refCounts[n] = this.refCounts[n] + 1;
            return null;
        }
    }
}

