/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.RelOptPredicateList;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.rex.RexVisitorImpl;
import hive.org.apache.calcite.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hive.common.util.AnnotationUtils;

public class HiveJoinPushTransitivePredicatesRule
extends RelOptRule {
    private final RelFactories.FilterFactory filterFactory;
    public static final HiveJoinPushTransitivePredicatesRule INSTANCE = new HiveJoinPushTransitivePredicatesRule(Join.class, RelFactories.DEFAULT_FILTER_FACTORY);

    public HiveJoinPushTransitivePredicatesRule(Class<? extends Join> clazz, RelFactories.FilterFactory filterFactory) {
        super(HiveJoinPushTransitivePredicatesRule.operand(clazz, HiveJoinPushTransitivePredicatesRule.operand(RelNode.class, HiveJoinPushTransitivePredicatesRule.any()), HiveJoinPushTransitivePredicatesRule.operand(RelNode.class, HiveJoinPushTransitivePredicatesRule.any())));
        this.filterFactory = filterFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Object curr;
        Join join = (Join)call.rel(0);
        RelOptPredicateList preds = RelMetadataQuery.getPulledUpPredicates(join);
        RexBuilder rB = join.getCluster().getRexBuilder();
        Object lChild = call.rel(1);
        Object rChild = call.rel(2);
        ImmutableList<RexNode> leftPreds = this.getValidPreds(preds.leftInferredPredicates, lChild.getRowType().getFieldList());
        ImmutableList<RexNode> rightPreds = this.getValidPreds(preds.rightInferredPredicates, rChild.getRowType().getFieldList());
        if (leftPreds.isEmpty() && rightPreds.isEmpty()) {
            return;
        }
        if (leftPreds.size() > 0) {
            curr = lChild;
            lChild = this.filterFactory.createFilter((RelNode)lChild, RexUtil.composeConjunction(rB, leftPreds, false));
            call.getPlanner().onCopy((RelNode)curr, (RelNode)lChild);
        }
        if (rightPreds.size() > 0) {
            curr = rChild;
            rChild = this.filterFactory.createFilter((RelNode)rChild, RexUtil.composeConjunction(rB, rightPreds, false));
            call.getPlanner().onCopy((RelNode)curr, (RelNode)rChild);
        }
        Join newRel = join.copy(join.getTraitSet(), join.getCondition(), (RelNode)lChild, (RelNode)rChild, join.getJoinType(), join.isSemiJoinDone());
        call.getPlanner().onCopy(join, newRel);
        call.transformTo(newRel);
    }

    private ImmutableList<RexNode> getValidPreds(List<RexNode> rexs, List<RelDataTypeField> types) {
        InputRefValidator validator = new InputRefValidator(types);
        ArrayList<RexNode> valids = new ArrayList<RexNode>(rexs.size());
        for (RexNode rex : rexs) {
            try {
                rex.accept(validator);
                valids.add(rex);
            }
            catch (Util.FoundOne e) {
                Util.swallow(e, null);
            }
        }
        return ImmutableList.copyOf(valids);
    }

    private static class InputRefValidator
    extends RexVisitorImpl<Void> {
        private final List<RelDataTypeField> types;

        protected InputRefValidator(List<RelDataTypeField> types) {
            super(true);
            this.types = types;
        }

        @Override
        public Void visitCall(RexCall call) {
            if (AnnotationUtils.getAnnotation(GenericUDFOPNotNull.class, Description.class).name().equals(call.getOperator().getName()) && call.getOperands().get(0) instanceof RexInputRef && !this.types.get(((RexInputRef)call.getOperands().get(0)).getIndex()).getType().isNullable()) {
                throw new Util.FoundOne(call);
            }
            return (Void)super.visitCall(call);
        }
    }
}

