/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.rules.JoinCommuteRule;
import hive.org.apache.calcite.util.Permutation;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;

public class HiveJoinCommuteRule
extends RelOptRule {
    public static final HiveJoinCommuteRule INSTANCE = new HiveJoinCommuteRule(HiveProject.class, HiveJoin.class);

    public HiveJoinCommuteRule(Class<? extends Project> projClazz, Class<? extends Join> joinClazz) {
        super(HiveJoinCommuteRule.operand(projClazz, HiveJoinCommuteRule.operand(joinClazz, HiveJoinCommuteRule.any()), new RelOptRuleOperand[0]));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project topProject = (Project)call.rel(0);
        Join join = (Join)call.rel(1);
        Permutation topPermutation = topProject.getPermutation();
        if (topPermutation == null) {
            return;
        }
        if (topPermutation.isIdentity()) {
            return;
        }
        RelNode swapped = JoinCommuteRule.swap(join, true);
        if (swapped == null) {
            return;
        }
        if (swapped instanceof Join) {
            return;
        }
        Project bottomProject = (Project)swapped;
        Permutation bottomPermutation = bottomProject.getPermutation();
        if (bottomPermutation == null) {
            return;
        }
        if (bottomPermutation.isIdentity()) {
            return;
        }
        Permutation product = topPermutation.product(bottomPermutation);
        if (!product.isIdentity()) {
            return;
        }
        Join swappedJoin = (Join)bottomProject.getInput(0);
        call.transformTo(swappedJoin);
    }
}

