/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.type.SqlTypeName;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public final class HiveJoinAddNotNullRule
extends RelOptRule {
    private static final String NOT_NULL_FUNC_NAME = "isnotnull";
    public static final HiveJoinAddNotNullRule INSTANCE = new HiveJoinAddNotNullRule(HiveFilter.DEFAULT_FILTER_FACTORY);
    private final RelFactories.FilterFactory filterFactory;

    public HiveJoinAddNotNullRule(RelFactories.FilterFactory filterFactory) {
        super(HiveJoinAddNotNullRule.operand(Join.class, HiveJoinAddNotNullRule.operand(RelNode.class, HiveJoinAddNotNullRule.any()), HiveJoinAddNotNullRule.operand(RelNode.class, HiveJoinAddNotNullRule.any())));
        this.filterFactory = filterFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        Object leftInput = call.rel(1);
        Object rightInput = call.rel(2);
        if (join.getJoinType() != JoinRelType.INNER) {
            return;
        }
        if (join.getCondition().isAlwaysTrue()) {
            return;
        }
        HiveCalciteUtil.JoinPredicateInfo joinPredInfo = HiveCalciteUtil.JoinPredicateInfo.constructJoinPredicateInfo(join);
        HashSet<Integer> joinLeftKeyPositions = new HashSet<Integer>();
        HashSet<Integer> joinRightKeyPositions = new HashSet<Integer>();
        for (int i = 0; i < joinPredInfo.getEquiJoinPredicateElements().size(); ++i) {
            HiveCalciteUtil.JoinLeafPredicateInfo joinLeafPredInfo = joinPredInfo.getEquiJoinPredicateElements().get(i);
            joinLeftKeyPositions.addAll(joinLeafPredInfo.getProjsFromLeftPartOfJoinKeysInChildSchema());
            joinRightKeyPositions.addAll(joinLeafPredInfo.getProjsFromRightPartOfJoinKeysInChildSchema());
        }
        RelOptCluster cluster = join.getCluster();
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        Map<String, RexNode> newLeftConditions = HiveJoinAddNotNullRule.getNotNullConditions(cluster, rexBuilder, leftInput, joinLeftKeyPositions);
        Map<String, RexNode> newRightConditions = HiveJoinAddNotNullRule.getNotNullConditions(cluster, rexBuilder, rightInput, joinRightKeyPositions);
        if (newLeftConditions == null && newRightConditions == null) {
            return;
        }
        if (newLeftConditions != null) {
            if (leftInput instanceof HiveFilter) {
                leftInput = leftInput.getInput(0);
            }
            leftInput = HiveJoinAddNotNullRule.createHiveFilterConjunctiveCondition(this.filterFactory, rexBuilder, leftInput, newLeftConditions.values());
        }
        if (newRightConditions != null) {
            if (rightInput instanceof HiveFilter) {
                rightInput = rightInput.getInput(0);
            }
            rightInput = HiveJoinAddNotNullRule.createHiveFilterConjunctiveCondition(this.filterFactory, rexBuilder, rightInput, newRightConditions.values());
        }
        Join newJoin = join.copy(join.getTraitSet(), join.getCondition(), (RelNode)leftInput, (RelNode)rightInput, join.getJoinType(), join.isSemiJoinDone());
        call.getPlanner().onCopy(join, newJoin);
        call.transformTo(newJoin);
    }

    private static Map<String, RexNode> getNotNullConditions(RelOptCluster cluster, RexBuilder rexBuilder, RelNode input, Set<Integer> inputKeyPositions) {
        boolean added = false;
        RelDataType returnType = cluster.getTypeFactory().createSqlType(SqlTypeName.BOOLEAN);
        Map<Object, Object> newConditions = input instanceof HiveFilter ? HiveJoinAddNotNullRule.splitCondition(((HiveFilter)input).getCondition()) : new HashMap();
        for (int pos : inputKeyPositions) {
            try {
                RelDataType keyType = input.getRowType().getFieldList().get(pos).getType();
                if (!keyType.isNullable()) continue;
                SqlOperator funcCall = SqlFunctionConverter.getCalciteOperator(NOT_NULL_FUNC_NAME, FunctionRegistry.getFunctionInfo(NOT_NULL_FUNC_NAME).getGenericUDF(), ImmutableList.of(keyType), returnType);
                RexNode cond = rexBuilder.makeCall(funcCall, rexBuilder.makeInputRef(input, pos));
                String digest = cond.toString();
                if (newConditions.containsKey(digest)) continue;
                newConditions.put(digest, cond);
                added = true;
            }
            catch (SemanticException e) {
                throw new AssertionError((Object)e.getMessage());
            }
        }
        if (!added) {
            return null;
        }
        return newConditions;
    }

    private static Map<String, RexNode> splitCondition(RexNode condition) {
        HashMap<String, RexNode> newConditions = new HashMap<String, RexNode>();
        if (condition.getKind() == SqlKind.AND) {
            for (RexNode node : ((RexCall)condition).getOperands()) {
                newConditions.put(node.toString(), node);
            }
        } else {
            newConditions.put(condition.toString(), condition);
        }
        return newConditions;
    }

    private static RelNode createHiveFilterConjunctiveCondition(RelFactories.FilterFactory filterFactory, RexBuilder rexBuilder, RelNode input, Collection<RexNode> conditions) {
        RexNode newCondition = RexUtil.composeConjunction(rexBuilder, conditions, false);
        return filterFactory.createFilter(input, newCondition);
    }
}

