/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.InvalidRelException;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.JoinInfo;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.core.SemiJoin;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.util.ImmutableIntList;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelOptUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRulesRegistry;

public class HiveSemiJoin
extends SemiJoin
implements HiveRelNode {
    public static final RelFactories.SemiJoinFactory HIVE_SEMIJOIN_FACTORY = new HiveSemiJoinFactoryImpl();
    private final RexNode joinFilter;

    public static HiveSemiJoin getSemiJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        try {
            HiveSemiJoin semiJoin = new HiveSemiJoin(cluster, traitSet, left, right, condition, leftKeys, rightKeys);
            return semiJoin;
        }
        catch (InvalidRelException | CalciteSemanticException e) {
            throw new RuntimeException(e);
        }
    }

    protected HiveSemiJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys) throws InvalidRelException, CalciteSemanticException {
        super(cluster, traitSet, left, right, condition, leftKeys, rightKeys);
        ImmutableList<RelDataTypeField> systemFieldList = ImmutableList.of();
        ArrayList<List<RexNode>> joinKeyExprs = new ArrayList<List<RexNode>>();
        ArrayList<Integer> filterNulls = new ArrayList<Integer>();
        for (int i = 0; i < this.getInputs().size(); ++i) {
            joinKeyExprs.add(new ArrayList());
        }
        this.joinFilter = HiveRelOptUtil.splitJoinCondition(systemFieldList, this.getInputs(), this.getCondition(), joinKeyExprs, filterNulls, null);
    }

    public RexNode getJoinFilter() {
        return this.joinFilter;
    }

    @Override
    public SemiJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        try {
            JoinInfo joinInfo = JoinInfo.of(left, right, condition);
            HiveSemiJoin semijoin = new HiveSemiJoin(this.getCluster(), traitSet, left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys);
            HiveRulesRegistry registry = semijoin.getCluster().getPlanner().getContext().unwrap(HiveRulesRegistry.class);
            if (registry != null) {
                registry.copyPushedPredicates(this, semijoin);
            }
            return semijoin;
        }
        catch (InvalidRelException | CalciteSemanticException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return RelMetadataQuery.getNonCumulativeCost(this);
    }

    private static class HiveSemiJoinFactoryImpl
    implements RelFactories.SemiJoinFactory {
        private HiveSemiJoinFactoryImpl() {
        }

        @Override
        public RelNode createSemiJoin(RelNode left, RelNode right, RexNode condition) {
            JoinInfo joinInfo = JoinInfo.of(left, right, condition);
            RelOptCluster cluster = left.getCluster();
            return HiveSemiJoin.getSemiJoin(cluster, left.getTraitSet(), left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys);
        }
    }
}

