/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelTrait;
import hive.org.apache.calcite.plan.RelTraitDef;
import hive.org.apache.calcite.rel.RelDistribution;
import hive.org.apache.calcite.rel.RelDistributionTraitDef;
import hive.org.apache.calcite.util.mapping.Mappings;
import java.util.List;

public class HiveRelDistribution
implements RelDistribution {
    List<Integer> keys;
    RelDistribution.Type type;

    public HiveRelDistribution(RelDistribution.Type type, List<Integer> keys) {
        this.type = type;
        this.keys = keys;
    }

    @Override
    public RelTraitDef<?> getTraitDef() {
        return RelDistributionTraitDef.INSTANCE;
    }

    @Override
    public void register(RelOptPlanner planner) {
    }

    @Override
    public boolean satisfies(RelTrait trait) {
        if (trait == this) {
            return true;
        }
        switch (((RelDistribution)trait).getType()) {
            case HASH_DISTRIBUTED: {
                return this.getKeys().equals(((RelDistribution)trait).getKeys());
            }
        }
        throw new RuntimeException("Other distributions are not used yet.");
    }

    @Override
    public RelDistribution apply(Mappings.TargetMapping mapping) {
        if (this.keys.isEmpty()) {
            return this;
        }
        return new HiveRelDistribution(this.type, this.keys);
    }

    @Override
    public List<Integer> getKeys() {
        return this.keys;
    }

    @Override
    public RelDistribution.Type getType() {
        return this.type;
    }
}

