/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import hive.parquet.hadoop.ParquetInputFormat;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.parquet.VectorizedParquetInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.read.DataWritableReadSupport;
import org.apache.hadoop.hive.ql.io.parquet.read.ParquetRecordReaderWrapper;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class MapredParquetInputFormat
extends FileInputFormat<Void, ArrayWritable> {
    private static final Log LOG = LogFactory.getLog(MapredParquetInputFormat.class);
    private final ParquetInputFormat<ArrayWritable> realInput;
    private final transient VectorizedParquetInputFormat vectorizedSelf;

    public MapredParquetInputFormat() {
        this(new ParquetInputFormat<ArrayWritable>(DataWritableReadSupport.class));
    }

    protected MapredParquetInputFormat(ParquetInputFormat<ArrayWritable> inputFormat) {
        this.realInput = inputFormat;
        this.vectorizedSelf = new VectorizedParquetInputFormat(inputFormat);
    }

    public RecordReader<Void, ArrayWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        try {
            if (Utilities.isVectorMode((Configuration)job)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Using vectorized record reader");
                }
                return this.vectorizedSelf.getRecordReader(split, job, reporter);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Using row-mode record reader");
            }
            return new ParquetRecordReaderWrapper(this.realInput, split, job, reporter);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Cannot create a RecordReaderWrapper", e);
        }
    }
}

