/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.util.graph;

import hive.com.google.common.collect.ImmutableCollection;
import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.util.Pair;
import hive.org.apache.calcite.util.graph.DefaultDirectedGraph;
import hive.org.apache.calcite.util.graph.DefaultEdge;
import hive.org.apache.calcite.util.graph.DirectedGraph;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Graphs {
    private Graphs() {
    }

    public static <V, E extends DefaultEdge> List<V> predecessorListOf(DirectedGraph<V, E> graph, V vertex) {
        final List<E> edges = graph.getInwardEdges(vertex);
        return new AbstractList<V>(){

            @Override
            public V get(int index) {
                return ((DefaultEdge)edges.get((int)index)).source;
            }

            @Override
            public int size() {
                return edges.size();
            }
        };
    }

    public static <V, E extends DefaultEdge> FrozenGraph<V, E> makeImmutable(DirectedGraph<V, E> graph) {
        int changeCount;
        DefaultDirectedGraph graph1 = (DefaultDirectedGraph)graph;
        HashMap<Pair<ImmutableCollection, ImmutableCollection>, List<ImmutableCollection>> shortestPaths = new HashMap<Pair<ImmutableCollection, ImmutableCollection>, List<ImmutableCollection>>();
        for (DefaultDirectedGraph.VertexInfo arc : graph1.vertexMap.values()) {
            for (DefaultEdge edge : arc.outEdges) {
                Object source = graph1.source(edge);
                Object target = graph1.target(edge);
                shortestPaths.put(Pair.of(source, target), ImmutableList.of(source, target));
            }
        }
        do {
            ImmutableList<Pair> previous = ImmutableList.copyOf(shortestPaths.keySet());
            changeCount = 0;
            for (DefaultEdge edge : graph.edgeSet()) {
                for (Pair edge2 : previous) {
                    if (!edge.target.equals(edge2.left)) continue;
                    Pair key = Pair.of(graph1.source(edge), edge2.right);
                    List bestPath = (List)shortestPaths.get(key);
                    List arc2Path = (List)shortestPaths.get(edge2);
                    if (bestPath != null && bestPath.size() <= arc2Path.size() + 1) continue;
                    ImmutableList.Builder newPath = ImmutableList.builder();
                    newPath.add(graph1.source(edge));
                    newPath.addAll((Iterable)arc2Path);
                    shortestPaths.put(key, (List<ImmutableCollection>)((Object)newPath.build()));
                    ++changeCount;
                }
            }
        } while (changeCount != 0);
        return new FrozenGraph(graph1, shortestPaths);
    }

    public static class FrozenGraph<V, E extends DefaultEdge> {
        private final DefaultDirectedGraph<V, E> graph;
        private final Map<Pair<V, V>, List<V>> shortestPaths;

        FrozenGraph(DefaultDirectedGraph<V, E> graph, Map<Pair<V, V>, List<V>> shortestPaths) {
            this.graph = graph;
            this.shortestPaths = shortestPaths;
        }

        public List<List<V>> getPaths(V from, V to) {
            ArrayList<List<V>> list = new ArrayList<List<V>>();
            this.findPaths(from, to, list);
            return list;
        }

        public List<V> getShortestPath(V from, V to) {
            if (from.equals(to)) {
                return ImmutableList.of();
            }
            return this.shortestPaths.get(Pair.of(from, to));
        }

        private void findPaths(V from, V to, List<List<V>> list) {
            List<V> shortestPath = this.shortestPaths.get(Pair.of(from, to));
            if (shortestPath == null) {
                return;
            }
            ArrayList<V> prefix = new ArrayList<V>();
            prefix.add(from);
            this.findPathsExcluding(from, to, list, new HashSet(), prefix);
        }

        private void findPathsExcluding(V from, V to, List<List<V>> list, Set<V> excludedNodes, List<V> prefix) {
            excludedNodes.add(from);
            for (DefaultEdge edge : this.graph.edges) {
                if (!edge.source.equals(from)) continue;
                V target = this.graph.target(edge);
                if (target.equals(to)) {
                    prefix.add(target);
                    list.add(ImmutableList.copyOf(prefix));
                    prefix.remove(prefix.size() - 1);
                    continue;
                }
                if (excludedNodes.contains(target)) continue;
                prefix.add(target);
                this.findPathsExcluding(target, to, list, excludedNodes, prefix);
                prefix.remove(prefix.size() - 1);
            }
            excludedNodes.remove(from);
        }
    }
}

